/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.mail;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Store;
import javax.mail.UIDFolder;
import javax.mail.internet.MimeMessage;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataAccessor;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.FolderDataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.UrlNotFoundException;
import org.semanticdesktop.aperture.accessor.base.FolderDataObjectBase;
import org.semanticdesktop.aperture.crawler.base.CrawlerBase;
import org.semanticdesktop.aperture.crawler.mail.DataObjectFactory;
import org.semanticdesktop.aperture.crawler.mail.MailUtil;
import org.semanticdesktop.aperture.crawler.mail.MessageDataObject;
import org.semanticdesktop.aperture.crawler.mail.base.MessageDataObjectBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.semanticdesktop.aperture.vocabulary.NMO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaMailCrawler
extends CrawlerBase
implements DataObjectFactory.PartStreamFactory,
DataAccessor {
    protected int maxDepth;
    protected long maximumByteSize;
    protected ArrayList baseFolders = new ArrayList();
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String ACCESSED_KEY = "accessed";
    protected static final String SUBFOLDERS_KEY = "subfolders";
    protected Folder currentFolder;
    protected URI currentFolderURI;
    protected Store store;

    protected abstract URI getFolderURI(Folder var1) throws MessagingException;

    protected abstract String getMessageUri(Folder var1, Message var2) throws MessagingException;

    protected abstract String getFolderName(String var1) throws UrlNotFoundException;

    protected abstract boolean checkIfCurrentFolderHasBeenChanged(AccessData var1) throws MessagingException;

    protected abstract void recordCurrentFolderInAccessData(AccessData var1) throws MessagingException;

    protected abstract void retrieveConfigurationData(DataSource var1);

    protected abstract void ensureConnectedStore() throws MessagingException;

    protected void setCurrentFolder(Folder folder) throws MessagingException {
        this.currentFolder = folder;
        this.currentFolderURI = this.getFolderURI(folder);
    }

    protected Message getMessageFromCurrentFolder(int index) throws MessagingException {
        return this.currentFolder.getMessage(index);
    }

    protected int getCurrentFolderMessageCount() throws MessagingException {
        return this.currentFolder.getMessageCount();
    }

    protected MimeMessage getMessageByURI(String url, Folder folder) throws MessagingException {
        return null;
    }

    protected void closeConnection() {
        if (this.store != null && this.store.isConnected()) {
            try {
                this.store.close();
            }
            catch (MessagingException e) {
                this.logger.warn("Unable to close connection", e);
            }
        }
    }

    @Override
    public InputStream getPartStream(Part part) throws MessagingException, IOException {
        return part.getInputStream();
    }

    @Override
    public MessageDataObject createDataObject(URI dataObjectId, DataSource dataSource, RDFContainer metadata, MimeMessage msg) throws MessagingException {
        return new MessageDataObjectBase(dataObjectId, dataSource, metadata, msg);
    }

    @Override
    public DataObject getDataObject(String url, DataSource dataSource, Map params, RDFContainerFactory containerFactory) throws UrlNotFoundException, IOException {
        return (DataObject)this.getDataObjectOrAllObjects(url, dataSource, null, params, containerFactory, false);
    }

    @Override
    public DataObject getDataObjectIfModified(String url, DataSource dataSource, AccessData newAccessData, Map params, RDFContainerFactory containerFactory) throws UrlNotFoundException, IOException {
        return (DataObject)this.getDataObjectOrAllObjects(url, dataSource, newAccessData, params, containerFactory, false);
    }

    public Map<URI, DataObject> getAllRelatedDataObjects(String url, DataSource dataSource, Map params, RDFContainerFactory containerFactory) throws UrlNotFoundException, IOException {
        return (Map)this.getDataObjectOrAllObjects(url, dataSource, null, params, containerFactory, true);
    }

    protected Object getDataObjectOrAllObjects(String url, DataSource dataSource, AccessData newAccessData, Map params, RDFContainerFactory containerFactory, boolean all) throws UrlNotFoundException, IOException {
        if (newAccessData != null && newAccessData.get(url, ACCESSED_KEY) != null && !all) {
            return null;
        }
        this.retrieveConfigurationData(dataSource);
        Folder folder = null;
        try {
            this.ensureConnectedStore();
            String folderName = this.getFolderName(url);
            folder = folderName == null || folderName.equals("") ? this.store.getDefaultFolder() : this.store.getFolder(folderName);
            if (!folder.exists()) {
                throw new UrlNotFoundException(url, "unknown folder: " + folderName);
            }
            if (!folder.isOpen() && AbstractJavaMailCrawler.holdsMessages(folder)) {
                folder.open(1);
            }
            String folderUri = this.getFolderURI(folder).toString();
            this.setCurrentFolder(folder);
            if (!folderUri.equals(url)) {
                Object object = this.getDataObjectByMessageURI(url, dataSource, containerFactory, folder, all);
                return object;
            }
            FolderDataObject obj = this.getCurrentFolderObject(dataSource, newAccessData, containerFactory);
            if (all) {
                HashMap<URI, FolderDataObject> res = new HashMap<URI, FolderDataObject>();
                res.put(obj.getID(), obj);
                HashMap<URI, FolderDataObject> hashMap = res;
                return hashMap;
            }
            FolderDataObject folderDataObject = obj;
            return folderDataObject;
        }
        catch (MessagingException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            this.closeConnection();
        }
    }

    protected Object getDataObjectByMessageURI(String url, DataSource dataSource, RDFContainerFactory containerFactory, Folder folder, boolean all) throws MessagingException, UrlNotFoundException, IOException {
        MimeMessage mimeMessage = this.getMessageByURI(url, folder);
        if (mimeMessage != null) {
            DataObjectFactory fac = new DataObjectFactory(mimeMessage, containerFactory, this, dataSource, new URIImpl(this.getMessageUri(folder, mimeMessage)), this.getFolderURI(folder));
            if (all) {
                return fac.getAllDataObjects();
            }
            return fac.getObjectAndDisposeAllOtherObjects(url);
        }
        int separatorIndex = url.indexOf(35);
        String messageUrl = url;
        if (separatorIndex > 0 && separatorIndex < url.length() - 1) {
            messageUrl = url.substring(0, separatorIndex);
        }
        int messageCount = this.getCurrentFolderMessageCount();
        for (int i = 1; i <= messageCount; ++i) {
            MimeMessage msg = (MimeMessage)this.getMessageFromCurrentFolder(i);
            String msgUri = this.getMessageUri(folder, msg);
            if (!msgUri.equals(messageUrl)) continue;
            DataObjectFactory fac = new DataObjectFactory(msg, containerFactory, this, dataSource, new URIImpl(this.getMessageUri(folder, msg)), this.getFolderURI(folder));
            if (all) {
                return fac.getAllDataObjects();
            }
            return fac.getObjectAndDisposeAllOtherObjects(url);
        }
        throw new UrlNotFoundException("unknown url: " + url);
    }

    protected final void crawlFolder(Folder folder, int depth) throws MessagingException {
        if (this.isStopRequested()) {
            return;
        }
        if (folder == null) {
            this.logger.debug("passed null folder, ignoring");
            return;
        }
        if (!folder.exists()) {
            this.logger.debug("folder does not exist: \"{}\"", (Object)folder.getFullName());
            return;
        }
        this.logger.debug("crawling folder \"{}\"", (Object)folder.getFullName());
        this.crawlSingleFolder(folder);
        if (AbstractJavaMailCrawler.holdsFolders(folder)) {
            this.logger.debug("crawling subfolders in folder \"{}\"", (Object)folder.getFullName());
            this.crawlSubFolders(folder, depth);
        }
        if (folder.isOpen()) {
            folder.close(false);
        }
    }

    protected void crawlSingleFolder(Folder folder) throws MessagingException {
        String folderUrl;
        if (AbstractJavaMailCrawler.holdsMessages(folder) && !folder.isOpen()) {
            folder.open(1);
        }
        if (!this.inDomain(folderUrl = this.getFolderURI(folder).toString())) {
            return;
        }
        this.reportAccessingObject(folderUrl);
        this.setCurrentFolder(folder);
        boolean knownObject = this.accessData == null ? false : this.accessData.isKnownId(folderUrl);
        RDFContainerFactory containerFactory = this.getRDFContainerFactory(folderUrl);
        try {
            FolderDataObject folderObject = this.getCurrentFolderObject(this.source, this.accessData, containerFactory);
            if (this.isStopRequested()) {
                return;
            }
            if (folderObject == null) {
                this.reportNotModified(folderUrl);
            } else {
                if (knownObject) {
                    this.reportModifiedDataObject(folderObject);
                } else {
                    this.reportNewDataObject(folderObject);
                }
                if (AbstractJavaMailCrawler.holdsMessages(folder)) {
                    this.crawlMessages(folder, folderObject.getID());
                }
            }
        }
        catch (MessagingException e) {
            this.logger.warn("Exception while crawling folder " + folderUrl, e);
        }
    }

    protected void crawlSubFolders(Folder folder, int depth) {
        if (depth + 1 > this.maxDepth && this.maxDepth >= 0) {
            this.logger.debug("Reached crawling depth limit ({}) - stopping.", this.maxDepth);
            return;
        }
        try {
            Folder[] subFolders = folder.list();
            this.logger.debug("Crawling {} sub-folders.", subFolders.length);
            for (int i = 0; !this.isStopRequested() && i < subFolders.length; ++i) {
                try {
                    this.crawlFolder(subFolders[i], depth + 1);
                    continue;
                }
                catch (MessagingException e) {
                    this.logger.debug("Error crawling subfolder \"{}\"", (Object)subFolders[i].getFullName());
                }
            }
        }
        catch (MessagingException e) {
            this.logger.warn("Exception while crawling subFolders of \"" + folder.getFullName() + "\"", e);
        }
    }

    protected void crawlMessages(Folder folder, URI folderUri) throws MessagingException {
        if (this.isStopRequested()) {
            return;
        }
        this.logger.debug("Crawling messages in folder {}", (Object)folder.getFullName());
        int messageCount = this.getCurrentFolderMessageCount();
        for (int i = 1; i <= messageCount && !this.isStopRequested(); ++i) {
            try {
                MimeMessage message = (MimeMessage)this.getMessageFromCurrentFolder(i);
                String uri = this.getMessageUri(folder, message);
                if (!this.inDomain(uri)) continue;
                this.crawlSingleMessage(message, uri, folderUri);
                continue;
            }
            catch (Exception e) {
                this.logger.warn("Exception while crawling message #" + i + " in folder " + folder.getFullName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void crawlSingleMessage(MimeMessage message, String uri, URI folderUri) throws MessagingException, IOException {
        if (!this.isAcceptable(message)) {
            return;
        }
        DataObjectFactory dataObjectFactory = null;
        try {
            dataObjectFactory = new DataObjectFactory(message, this.getRDFContainerFactory(uri), this, this.getDataSource(), new URIImpl(uri), folderUri);
            DataObject object = null;
            boolean first = true;
            while (!this.isStopRequested() && (object = dataObjectFactory.getObject()) != null) {
                String queuedUri = object.getID().toString();
                this.reportAccessingObject(queuedUri);
                if (this.accessData != null && this.accessData.get(queuedUri, ACCESSED_KEY) != null) {
                    if (this.accessData.isTouched(queuedUri)) {
                        object.dispose();
                        continue;
                    }
                    object.dispose();
                    this.reportNotModified(queuedUri);
                    continue;
                }
                if (this.accessData != null) {
                    this.accessData.put(queuedUri, ACCESSED_KEY, "");
                }
                MailUtil.registerParentRelationshipInAccessData(object, this.accessData);
                if (first) {
                    object.getMetadata().add(NIE.isPartOf, folderUri);
                    first = false;
                }
                this.applySpecificProcessing(object);
                this.reportNewDataObject(object);
            }
        }
        finally {
            if (dataObjectFactory != null) {
                dataObjectFactory.disposeRemainingObjects();
            }
        }
    }

    protected void applySpecificProcessing(DataObject object) {
    }

    protected FolderDataObject getCurrentFolderObject(DataSource dataSource, AccessData newAccessData, RDFContainerFactory containerFactory) throws MessagingException {
        int i;
        boolean folderChanged = this.checkIfCurrentFolderHasBeenChanged(newAccessData);
        if (!folderChanged && newAccessData != null) {
            return null;
        }
        RDFContainer metadata = containerFactory.getRDFContainer(this.currentFolderURI);
        metadata.add(NIE.title, this.currentFolder.getName());
        Folder parent = this.currentFolder.getParent();
        if (parent != null) {
            metadata.add(NIE.isPartOf, this.getFolderURI(parent));
            metadata.getModel().addStatement(this.getFolderURI(parent), RDF.type, NFO.Folder);
        }
        if (AbstractJavaMailCrawler.holdsMessages(this.currentFolder)) {
            int messageCount = this.getCurrentFolderMessageCount();
            for (i = 1; i <= messageCount; ++i) {
                MimeMessage message = (MimeMessage)this.getMessageFromCurrentFolder(i);
                if (!this.isAcceptable(message)) continue;
                try {
                    URI messageURI = metadata.getModel().createURI(this.getMessageUri(this.currentFolder, message));
                    metadata.getModel().addStatement(messageURI, NIE.isPartOf, this.currentFolderURI);
                    metadata.getModel().addStatement(messageURI, RDF.type, NMO.MailboxDataObject);
                    continue;
                }
                catch (ModelRuntimeException e) {
                    this.logger.error("ModelException while creating URI", e);
                }
            }
        }
        Folder[] subFolders = this.currentFolder.list();
        for (i = 0; i < subFolders.length; ++i) {
            Folder subFolder = subFolders[i];
            if (!subFolder.exists()) continue;
            metadata.add(metadata.getValueFactory().createStatement(this.getFolderURI(subFolder), NIE.isPartOf, this.currentFolderURI));
        }
        this.recordCurrentFolderInAccessData(newAccessData);
        if (this.baseFolders.contains(this.currentFolder.getFullName())) {
            metadata.add(NIE.rootElementOf, dataSource.getID());
        }
        return new FolderDataObjectBase(this.currentFolderURI, dataSource, metadata);
    }

    protected long getMessageUid(Folder folder, Message message) throws MessagingException {
        if (folder instanceof UIDFolder) {
            return ((UIDFolder)((Object)folder)).getUID(message);
        }
        return -1L;
    }

    protected int getMessageCount(Message[] messages) throws MessagingException {
        int result = 0;
        for (int i = 0; i < messages.length; ++i) {
            Message message = messages[i];
            if (this.isRemoved(message)) continue;
            ++result;
        }
        return result;
    }

    protected String getSubFoldersString(Folder folder) throws MessagingException {
        Folder[] subFolders = folder.list();
        if (subFolders.length == 0) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < subFolders.length; ++i) {
            Folder subFolder = subFolders[i];
            if (!subFolder.exists()) continue;
            buffer.append(subFolder.getFullName());
            if (i >= subFolders.length - 1) continue;
            buffer.append('@');
        }
        return buffer.toString();
    }

    protected void reportNotModified(String uri) {
        this.reportUnmodifiedDataObject(uri);
    }

    protected boolean isRemoved(Message message) throws MessagingException {
        return message.isExpunged() || message.isSet(Flags.Flag.DELETED);
    }

    protected boolean isTooLarge(Message message) throws MessagingException {
        return (long)message.getSize() > this.maximumByteSize;
    }

    protected boolean isAcceptable(Message message) throws MessagingException {
        return !this.isRemoved(message) && !this.isTooLarge(message);
    }

    protected boolean checkSubfoldersChanged(AccessData ad) throws MessagingException {
        if (ad == null) {
            return true;
        }
        String registeredSubFoldersFromAccessData = ad.get(this.currentFolderURI.toString(), SUBFOLDERS_KEY);
        if (!AbstractJavaMailCrawler.holdsFolders(this.currentFolder)) {
            return registeredSubFoldersFromAccessData != null;
        }
        if (registeredSubFoldersFromAccessData == null) {
            return true;
        }
        String subfolders = this.getSubFoldersString(this.currentFolder);
        return subfolders == null || !registeredSubFoldersFromAccessData.equals(subfolders);
    }

    public static boolean holdsFolders(Folder folder) throws MessagingException {
        if ((folder.getType() & 2) == 2) {
            return folder.list().length > 0;
        }
        return false;
    }

    public static boolean holdsMessages(Folder folder) throws MessagingException {
        return (folder.getType() & 1) == 1;
    }
}

