/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.crawler.CrawlerFactory;
import org.semanticdesktop.aperture.crawler.CrawlerRegistry;

public class CrawlerRegistryImpl
implements CrawlerRegistry {
    private HashMap factories = new HashMap();

    public void add(CrawlerFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory is not allowed to be null");
        }
        for (URI type : factory.getSupportedTypes()) {
            HashSet<CrawlerFactory> factorySet = (HashSet<CrawlerFactory>)this.factories.get(type);
            if (factorySet == null) {
                factorySet = new HashSet<CrawlerFactory>();
                this.factories.put(type, factorySet);
            }
            factorySet.add(factory);
        }
    }

    public void remove(CrawlerFactory factory) {
        for (URI type : factory.getSupportedTypes()) {
            Set factorySet = (Set)this.factories.get(type);
            if (factorySet == null) continue;
            factorySet.remove(factory);
            if (!factorySet.isEmpty()) continue;
            this.factories.remove(type);
        }
    }

    public Set get(URI type) {
        Set factorySet = (Set)this.factories.get(type);
        if (factorySet == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(factorySet);
    }

    public Set getAll() {
        HashSet result = new HashSet();
        for (Set factorySet : this.factories.values()) {
            result.addAll(factorySet);
        }
        return result;
    }
}

