/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.imap;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.crawler.imap.ImapCrawler;
import org.semanticdesktop.aperture.crawler.mail.MessageDataObject;
import org.semanticdesktop.aperture.crawler.mail.base.MessageDataObjectBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImapStreamPool {
    private Logger logger = LoggerFactory.getLogger(ImapCrawler.class);
    private boolean closeRequested;
    private Store store;
    private Set<InputStream> streamSet;
    private Set<MessageDataObject> objectSet;

    public ImapStreamPool(Store store) {
        this.store = store;
        this.closeRequested = false;
        this.streamSet = new HashSet<InputStream>();
        this.objectSet = new HashSet<MessageDataObject>();
    }

    public synchronized InputStream getStreamForAMessage(Part part) throws MessagingException, IOException {
        InputStream stream;
        if (!this.store.isConnected()) {
            this.store.connect();
            this.closeRequested = false;
        }
        if ((stream = part.getInputStream()) == null) {
            return null;
        }
        ImapInputStream result = new ImapInputStream(part.getInputStream(), this);
        this.streamSet.add(result);
        return result;
    }

    public synchronized MessageDataObject getObjectForAMessage(URI dataObjectId, DataSource dataSource, RDFContainer metadata, MimeMessage msg) throws MessagingException {
        if (!this.store.isConnected()) {
            this.store.connect();
            this.closeRequested = false;
        }
        ImapDataObject result = new ImapDataObject(dataObjectId, dataSource, metadata, msg, this);
        this.objectSet.add(result);
        return result;
    }

    public synchronized void requestClose() {
        this.closeRequested = true;
        if (this.streamSet.isEmpty() && this.objectSet.isEmpty()) {
            this.closeStore();
        }
    }

    private synchronized void notifyStreamClosed(InputStream stream) {
        if (this.streamSet.contains(stream)) {
            this.streamSet.remove(stream);
            if (this.closeRequested && this.streamSet.isEmpty() && this.objectSet.isEmpty()) {
                this.closeStore();
            }
        } else {
            this.logger.warn("Trying to return a stream that doesn't belong here");
        }
    }

    private synchronized void notifyObjectClosed(ImapDataObject obj) {
        if (this.objectSet.contains(obj)) {
            this.objectSet.remove(obj);
            if (this.closeRequested && this.streamSet.isEmpty() && this.objectSet.isEmpty()) {
                this.closeStore();
            }
        } else {
            this.logger.warn("Trying to return an object that doesn't belong here");
        }
    }

    private void closeStore() {
        try {
            this.store.close();
        }
        catch (MessagingException e) {
            this.logger.warn("Couldn't close the IMAP store", e);
        }
    }

    private static class ImapInputStream
    extends FilterInputStream {
        private ImapStreamPool pool;

        public ImapInputStream(InputStream stream, ImapStreamPool pool) {
            super(stream);
            this.pool = pool;
        }

        public void close() throws IOException {
            this.pool.notifyStreamClosed(this);
            super.close();
        }
    }

    private static class ImapDataObject
    extends MessageDataObjectBase {
        private ImapStreamPool pool;

        public ImapDataObject(URI id, DataSource dataSource, RDFContainer metadata, MimeMessage message, ImapStreamPool pool) {
            super(id, dataSource, metadata, message);
            this.pool = pool;
        }

        public void dispose() {
            super.dispose();
            this.pool.notifyObjectClosed(this);
        }
    }
}

