/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.ical;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticdesktop.aperture.crawler.Crawler;
import org.semanticdesktop.aperture.crawler.CrawlerFactory;
import org.semanticdesktop.aperture.crawler.ical.IcalCrawler;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.datasource.ical.ICALDS;
import org.semanticdesktop.aperture.subcrawler.SubCrawler;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerFactory;

public class IcalCrawlerFactory
implements CrawlerFactory,
SubCrawlerFactory {
    private static final Set SUPPORTED_TYPES = Collections.singleton(ICALDS.IcalDataSource);
    private static final Set MIME_TYPES;
    public static final String ZIP_URI_PREFIX = "zip";
    private boolean attachmentOnlyMode;

    public IcalCrawlerFactory() {
        this(false);
    }

    public IcalCrawlerFactory(boolean attachmentOnlyMode) {
        this.attachmentOnlyMode = attachmentOnlyMode;
    }

    public Set getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    public Crawler getCrawler(DataSource dataSource) {
        IcalCrawler crawler = new IcalCrawler(this.attachmentOnlyMode);
        crawler.setDataSource(dataSource);
        return crawler;
    }

    public SubCrawler get() {
        return new IcalCrawler(this.attachmentOnlyMode);
    }

    public Set getSupportedMimeTypes() {
        return MIME_TYPES;
    }

    public String getUriPrefix() {
        return "imap";
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("text/calendar");
        MIME_TYPES = Collections.unmodifiableSet(set);
    }
}

