/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.bundle;

import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.semanticdesktop.aperture.crawler.CrawlerFactory;
import org.semanticdesktop.aperture.crawler.CrawlerRegistry;
import org.semanticdesktop.aperture.crawler.impl.CrawlerRegistryImpl;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerFactory;
import org.semanticdesktop.aperture.subcrawler.SubCrawlerRegistry;
import org.semanticdesktop.aperture.subcrawler.impl.SubCrawlerRegistryImpl;

public class CrawlerServiceActivator
implements BundleActivator {
    private BundleContext bc = null;
    private ServiceRegistration crawlerRegistryRegistration;
    private CrawlerRegistry crawlerRegistry;
    private ServiceRegistration subCrawlerRegistryRegistration;
    private SubCrawlerRegistry subCrawlerRegistry;
    private CrawlerServiceListener listener;
    private SubCrawlerServiceListener subListener;

    public void start(BundleContext context) throws Exception {
        this.bc = context;
        this.crawlerRegistry = new CrawlerRegistryImpl();
        this.crawlerRegistryRegistration = this.bc.registerService(CrawlerRegistry.class.getName(), (Object)this.crawlerRegistry, new Hashtable());
        this.listener = new CrawlerServiceListener();
        String filter = "(objectclass=" + CrawlerFactory.class.getName() + ")";
        this.bc.addServiceListener((ServiceListener)this.listener, filter);
        ServiceReference[] references = this.bc.getServiceReferences(null, filter);
        for (int i = 0; references != null && i < references.length; ++i) {
            this.listener.serviceChanged(new ServiceEvent(1, references[i]));
        }
        this.subCrawlerRegistry = new SubCrawlerRegistryImpl();
        this.subCrawlerRegistryRegistration = this.bc.registerService(SubCrawlerRegistry.class.getName(), (Object)this.subCrawlerRegistry, new Hashtable());
        this.subListener = new SubCrawlerServiceListener();
        String subFilter = "(objectclass=" + SubCrawlerFactory.class.getName() + ")";
        this.bc.addServiceListener((ServiceListener)this.subListener, subFilter);
        ServiceReference[] subReferences = this.bc.getServiceReferences(null, subFilter);
        for (int i = 0; subReferences != null && i < subReferences.length; ++i) {
            this.subListener.serviceChanged(new ServiceEvent(1, subReferences[i]));
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.bc.removeServiceListener((ServiceListener)this.listener);
        this.bc.removeServiceListener((ServiceListener)this.subListener);
        this.crawlerRegistryRegistration.unregister();
        this.subCrawlerRegistryRegistration.unregister();
        this.bc = null;
    }

    private class SubCrawlerServiceListener
    implements ServiceListener {
        private SubCrawlerServiceListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            if (CrawlerServiceActivator.this.bc == null) {
                return;
            }
            switch (event.getType()) {
                case 1: {
                    SubCrawlerFactory factory = (SubCrawlerFactory)CrawlerServiceActivator.this.bc.getService(event.getServiceReference());
                    CrawlerServiceActivator.this.subCrawlerRegistry.add(factory);
                    break;
                }
                case 2: {
                    SubCrawlerFactory factory = (SubCrawlerFactory)CrawlerServiceActivator.this.bc.getService(event.getServiceReference());
                    CrawlerServiceActivator.this.subCrawlerRegistry.remove(factory);
                    CrawlerServiceActivator.this.subCrawlerRegistry.add(factory);
                    break;
                }
                case 4: {
                    SubCrawlerFactory factory = (SubCrawlerFactory)CrawlerServiceActivator.this.bc.getService(event.getServiceReference());
                    CrawlerServiceActivator.this.subCrawlerRegistry.remove(factory);
                }
            }
        }
    }

    private class CrawlerServiceListener
    implements ServiceListener {
        private CrawlerServiceListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            if (CrawlerServiceActivator.this.bc == null) {
                return;
            }
            switch (event.getType()) {
                case 1: {
                    CrawlerFactory factory = (CrawlerFactory)CrawlerServiceActivator.this.bc.getService(event.getServiceReference());
                    CrawlerServiceActivator.this.crawlerRegistry.add(factory);
                    break;
                }
                case 2: {
                    CrawlerFactory factory = (CrawlerFactory)CrawlerServiceActivator.this.bc.getService(event.getServiceReference());
                    CrawlerServiceActivator.this.crawlerRegistry.remove(factory);
                    CrawlerServiceActivator.this.crawlerRegistry.add(factory);
                    break;
                }
                case 4: {
                    CrawlerFactory factory = (CrawlerFactory)CrawlerServiceActivator.this.bc.getService(event.getServiceReference());
                    CrawlerServiceActivator.this.crawlerRegistry.remove(factory);
                }
            }
        }
    }
}

