/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.addressbook.thunderbird;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.PlainLiteral;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.addressbook.AddressbookCrawler;
import org.semanticdesktop.aperture.addressbook.thunderbird.ThunderbirdAddressbookDataSource;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.demork.Demork;
import org.semanticdesktop.demork.Utils;
import org.semanticdesktop.demork.database.Cell;
import org.semanticdesktop.demork.database.Database;
import org.semanticdesktop.demork.database.Row;
import org.semanticdesktop.demork.database.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThunderbirdCrawler
extends AddressbookCrawler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String TYPE = "thunderbird";
    private static final String THUNDERBIRD_URI_BASE = "urn:thunderbird:";
    private static final Collection<String> skipProperties = new ArrayList<String>();
    private Resource affiliationResource;
    private Resource organizationResource;

    public ThunderbirdCrawler(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    public ThunderbirdCrawler() {
    }

    @Override
    public List crawlAddressbook() throws Exception {
        String abookFile = this.getAddressBookFile();
        if (abookFile == null) {
            throw new NullPointerException("No thunderbirdAddressbookPath option set");
        }
        Demork demork = new Demork();
        String encoding = demork.getEncoding(abookFile);
        String mab = Utils.readWholeFileAsEncoding((String)abookFile, (String)encoding);
        Database d = demork.inputMork(mab);
        ArrayList<DataObject> res = new ArrayList<DataObject>();
        for (Table t : d.tables.values()) {
            for (Row row : t.rows.values()) {
                DataObject o = this.reportContact(row);
                if (o == null) continue;
                res.add(o);
            }
            if (!this.stopRequested) continue;
            break;
        }
        return res;
    }

    @Override
    public URI getContactListUri() {
        String abookFile = this.getAddressBookFile();
        if (abookFile == null) {
            return null;
        }
        File file = new File(abookFile);
        try {
            return new URIImpl(file.toURI().toURL() + "#ThunderbirdContactList");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getAddressBookFile() {
        return ((ThunderbirdAddressbookDataSource)this.getDataSource()).getThunderbirdAddressbookPath();
    }

    private void addAffiliation(Resource contactResource, Model model) {
        if (this.affiliationResource == null && this.organizationResource == null) {
            this.affiliationResource = ModelUtil.generateRandomResource(model);
            this.organizationResource = ModelUtil.generateRandomResource(model);
            model.addStatement(this.affiliationResource, RDF.type, NCO.Affiliation);
            model.addStatement(this.organizationResource, RDF.type, NCO.OrganizationContact);
            model.addStatement(contactResource, NCO.hasAffiliation, this.affiliationResource);
            model.addStatement(this.affiliationResource, NCO.org, this.organizationResource);
        }
    }

    private DataObject reportContact(Row row) {
        HashMap<String, String> values = new HashMap<String, String>();
        for (Cell c : row.cells) {
            if (skipProperties.contains(c.column) || c.atom.equals("")) continue;
            values.put(c.column, c.atom);
        }
        if (values.isEmpty()) {
            return null;
        }
        String uris = this.createURI(row.id);
        URI uri = URIImpl.createURIWithoutChecking(uris);
        RDFContainerFactory rdff = this.getRDFContainerFactory(uris);
        RDFContainer rdf = rdff.getRDFContainer(uri);
        Model model = rdf.getModel();
        rdf.add(RDF.type, NCO.Contact);
        rdf.add(RDF.type, NCO.ContactListDataObject);
        this.affiliationResource = null;
        this.organizationResource = null;
        for (Map.Entry entry : values.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            try {
                Resource emailResource;
                if (key.equals("PrimaryEmail")) {
                    emailResource = ModelUtil.generateRandomResource(model);
                    model.addStatement(emailResource, RDF.type, NCO.EmailAddress);
                    model.addStatement(emailResource, NCO.emailAddress, value);
                    model.addStatement(emailResource, NCO.contactMediumComment, "Primary Email");
                } else if (key.equals("SecondEmail")) {
                    emailResource = ModelUtil.generateRandomResource(model);
                    model.addStatement(emailResource, RDF.type, NCO.EmailAddress);
                    model.addStatement(emailResource, NCO.emailAddress, value);
                    model.addStatement(emailResource, NCO.contactMediumComment, "Second Email");
                } else if (key.equals("FirstName")) {
                    rdf.add(NCO.nameGiven, rdf.getValueFactory().createLiteral(value));
                    rdf.add(RDF.type, NCO.PersonContact);
                } else if (key.equals("LastName")) {
                    rdf.add(NCO.nameFamily, rdf.getValueFactory().createLiteral(value));
                    rdf.add(RDF.type, NCO.PersonContact);
                } else if (key.equals("DisplayName")) {
                    rdf.add(RDFS.label, rdf.getValueFactory().createLiteral(value));
                    rdf.add(NCO.fullname, rdf.getValueFactory().createLiteral(value));
                } else if (key.equals("NickName")) {
                    rdf.add(NCO.nickname, rdf.getValueFactory().createLiteral(value));
                    rdf.add(RDF.type, NCO.PersonContact);
                } else if (key.equals("WorkPhone")) {
                    this.addAffiliation(uri, model);
                    this.addPhoneNumber(this.affiliationResource, model, value, null);
                } else if (key.equals("HomePhone")) {
                    this.addPhoneNumber(uri, model, value, null);
                } else if (key.equals("FaxNumber")) {
                    this.addPhoneNumber(uri, model, value, NCO.FaxNumber);
                } else if (key.equals("PagerNumber")) {
                    this.addPhoneNumber(uri, model, value, NCO.PagerNumber);
                } else if (key.equals("CellularNumber")) {
                    this.addPhoneNumber(uri, model, value, NCO.CellPhoneNumber);
                } else if (key.equals("JobTitle")) {
                    this.addAffiliation(uri, model);
                    model.addStatement(this.affiliationResource, NCO.title, value);
                } else if (key.equals("Department")) {
                    this.addAffiliation(uri, model);
                    model.addStatement(this.affiliationResource, NCO.department, value);
                } else if (key.equals("Company")) {
                    this.addAffiliation(uri, model);
                    model.addStatement(this.organizationResource, NCO.fullname, value);
                } else if (key.equals("_AimScreenName")) {
                    Resource aimResource = ModelUtil.generateRandomResource(model);
                    model.addStatement(aimResource, RDF.type, NCO.IMAccount);
                    model.addStatement(aimResource, NCO.imAccountType, "AIM");
                    model.addStatement(aimResource, NCO.imNickname, value);
                    rdf.add(NCO.hasIMAccount, aimResource);
                } else if (key.equals("WebPage1")) {
                    rdf.add(NCO.websiteUrl, value);
                } else if (key.equals("WebPage2")) {
                    rdf.add(NCO.websiteUrl, value);
                } else if (key.equals("Custom1")) {
                    rdf.add(NCO.note, rdf.getValueFactory().createLiteral(value));
                } else if (key.equals("Custom2")) {
                    rdf.add(NCO.note, rdf.getValueFactory().createLiteral(value));
                } else if (key.equals("Custom3")) {
                    rdf.add(NCO.note, rdf.getValueFactory().createLiteral(value));
                } else if (key.equals("Custom4")) {
                    rdf.add(NCO.note, rdf.getValueFactory().createLiteral(value));
                } else if (key.equals("Notes")) {
                    rdf.add(NCO.note, rdf.getValueFactory().createLiteral(value));
                }
                this.addAddress(values, uri, model, "Home", NCO.hasPostalAddress);
                this.addAddress(values, uri, model, "Work", NCO.hasPostalAddress);
                model.addStatement(model.createStatement(this.getContactListUri(), NCO.containsContact, uri));
            }
            catch (ModelException e) {
                this.logger.error("ModelException while adding statements", e);
            }
        }
        DataObjectBase object = new DataObjectBase(uri, this.source, rdf);
        return object;
    }

    private void addEmailAddress(Resource contactResource, Model model, String value, URI type, String comment) {
        Resource emailAddressResource = ModelUtil.generateRandomResource(model);
        if (type == null) {
            model.addStatement(emailAddressResource, RDF.type, NCO.EmailAddress);
        } else {
            model.addStatement(emailAddressResource, RDF.type, type);
        }
        model.addStatement(contactResource, NCO.hasEmailAddress, emailAddressResource);
        model.addStatement(emailAddressResource, NCO.emailAddress, value);
        if (comment != null) {
            model.addStatement(emailAddressResource, NCO.contactMediumComment, comment);
        }
    }

    private void addPhoneNumber(Resource contactResource, Model model, String value, URI type) {
        Resource numberResource = ModelUtil.generateRandomResource(model);
        if (type == null) {
            model.addStatement(numberResource, RDF.type, NCO.PhoneNumber);
        } else {
            model.addStatement(numberResource, RDF.type, type);
        }
        model.addStatement(contactResource, NCO.hasPhoneNumber, numberResource);
        model.addStatement(numberResource, NCO.phoneNumber, value);
    }

    private void addAddress(Map<String, String> values, Resource roleResource, Model model, String type, URI address) throws ModelException {
        URI addressURI = model.createURI(roleResource.toString() + "_" + type + "Address");
        boolean ok = false;
        if (values.containsKey(type + "Address")) {
            ok = true;
            if (values.containsKey(type + "Address2")) {
                PlainLiteral literal = model.createPlainLiteral(values.get(type + "Address") + values.get(type + "Address2"));
                model.addStatement(addressURI, NCO.streetAddress, literal);
            } else {
                PlainLiteral literal = model.createPlainLiteral(values.get(type + "Address"));
                model.addStatement(addressURI, NCO.streetAddress, literal);
            }
        }
        if (values.containsKey(type + "City")) {
            ok = true;
            model.addStatement(addressURI, NCO.locality, values.get(type + "City"));
        }
        if (values.containsKey(type + "Country")) {
            ok = true;
            model.addStatement(addressURI, NCO.country, values.get(type + "Country"));
        }
        if (values.containsKey(type + "State")) {
            ok = true;
            model.addStatement(addressURI, NCO.region, values.get(type + "State"));
        }
        if (values.containsKey(type + "ZipCode")) {
            ok = true;
            model.addStatement(addressURI, NCO.postalcode, values.get(type + "ZipCode"));
        }
        if (ok) {
            model.addStatement(addressURI, RDF.type, NCO.PostalAddress);
            model.addStatement(roleResource, NCO.hasPostalAddress, addressURI);
        }
    }

    private String createURI(String id) {
        return "urn:thunderbird:Person:" + id;
    }

    static {
        skipProperties.add("PreferMailFormat");
        skipProperties.add("PopularityIndex");
        skipProperties.add("RecordKey");
        skipProperties.add("LastModifiedData");
    }
}

