/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.addressbook;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.BlankNode;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.crawler.base.CrawlerBase;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AddressbookCrawler
extends CrawlerBase {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String ADDRESSBOOK_CHECKSUM_KEY = "ADDRESSBOOK_CHECKSUM";

    public abstract List crawlAddressbook() throws Exception;

    public abstract URI getContactListUri();

    protected ExitCode crawlObjects() {
        boolean crawlCompleted = false;
        try {
            DataObject o;
            List people = this.crawlAddressbook();
            URI contactListUri = this.getContactListUri();
            if (!(this.isStopRequested() || this.accessData != null && this.accessData.isKnownId(contactListUri.toString()))) {
                this.reportContactListDataObject(contactListUri);
            }
            Iterator it = people.iterator();
            while (!this.isStopRequested() && it.hasNext()) {
                o = (DataObject)it.next();
                String sum = this.computeChecksum(o);
                if (this.accessData != null && this.accessData.isKnownId(o.getID().toString())) {
                    if (this.accessData.get(o.getID().toString(), ADDRESSBOOK_CHECKSUM_KEY).equals(sum)) {
                        this.reportUnmodifiedDataObject(o.getID().toString());
                        continue;
                    }
                    this.reportModifiedDataObject(o);
                    continue;
                }
                if (this.accessData != null) {
                    this.accessData.put(o.getID().toString(), ADDRESSBOOK_CHECKSUM_KEY, sum);
                }
                this.reportNewDataObject(o);
            }
            if (it.hasNext()) {
                crawlCompleted = false;
                while (it.hasNext()) {
                    o = (DataObject)it.next();
                    o.dispose();
                }
            } else {
                crawlCompleted = true;
            }
        }
        catch (Exception e) {
            return this.reportFatalErrorCause("Could not crawl addressbook data source", e);
        }
        return crawlCompleted ? ExitCode.COMPLETED : ExitCode.STOP_REQUESTED;
    }

    private void reportContactListDataObject(URI contactListUri) {
        RDFContainerFactory rdff = this.getRDFContainerFactory(contactListUri.toString());
        RDFContainer rdf = rdff.getRDFContainer(contactListUri);
        rdf.add(RDF.type, NCO.ContactList);
        rdf.add(NIE.rootElementOf, this.getDataSource().getID());
        DataObjectBase object = new DataObjectBase(contactListUri, this.source, rdf);
        this.reportNewDataObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String computeChecksum(DataObject o) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("md5");
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.warn("MD5 not available - using no checksum.");
            return "nochecksum";
        }
        RDFContainer rdf = o.getMetadata();
        Model model = rdf.getModel();
        Vector<String> predValues = new Vector<String>();
        ClosableIterator i = null;
        try {
            i = model.findStatements(rdf.getDescribedUri(), Variable.ANY, Variable.ANY);
            while (i.hasNext()) {
                Statement s = (Statement)i.next();
                if (s.getObject() instanceof BlankNode) {
                    this.logger.warn("BlankNodes messes up checksum generation!");
                }
                predValues.add(s.getPredicate().toString() + s.getObject().toString());
            }
        }
        catch (ModelRuntimeException me) {
            this.logger.error("Could not find statements", me);
        }
        finally {
            if (i != null) {
                i.close();
            }
        }
        Collections.sort(predValues);
        Iterator it = predValues.iterator();
        while (it.hasNext()) {
            md.update(((String)it.next()).getBytes());
        }
        StringBuilder digest = new StringBuilder("");
        byte[] dig = md.digest();
        for (int j = 0; j < dig.length; ++j) {
            digest.append(Integer.toHexString(dig[j]));
        }
        return digest.toString();
    }
}

