/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.base;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.Literal;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.rdf.util.ModelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelAccessData
implements AccessData {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String NS_MAD_STRING = "http://aperture.sourceforge.net/2007/07/19/mad#";
    public static final URI NS_MAD = new URIImpl("http://aperture.sourceforge.net/2007/07/19/mad#");
    public static final URI linksTo = new URIImpl("http://aperture.sourceforge.net/2007/07/19/mad#linksTo");
    public static final URI aggregates = new URIImpl("http://aperture.sourceforge.net/2007/07/19/mad#aggregates");
    public static final URI redirectsTo = new URIImpl("http://aperture.sourceforge.net/2007/07/19/mad#redirectsTo");
    public static final URI dateAsNumber = new URIImpl("http://aperture.sourceforge.net/2007/07/19/mad#dateAsNumber");
    public static final URI byteSize = new URIImpl("http://aperture.sourceforge.net/2007/07/19/mad#byteSize");
    public static final URI timestamp = new URIImpl("http://aperture.sourceforge.net/2007/07/19/mad#timestamp");
    public static final String URI_PREFIX = "urn:accessdata:";
    private Model model;
    private long timestampLong = -1L;

    public ModelAccessData(Model model) {
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        this.model = model;
        this.timestampLong = -1L;
    }

    private void checkInitialization() {
        if (this.timestampLong < 0L) {
            throw new IllegalStateException("AccessData not initialized, call initialize() first");
        }
    }

    @Override
    public void clear() throws IOException {
        this.timestampLong = -1L;
        try {
            this.model.removeAll();
        }
        catch (ModelRuntimeException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public void touch(String id) {
        URI idURI = this.model.createURI(id);
        this.touch(idURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTouched(String id) {
        URI idURI = this.model.createURI(id);
        ClosableIterator iter = null;
        try {
            iter = this.model.findStatements(idURI, timestamp, Variable.ANY);
            if (!iter.hasNext()) {
                boolean bl = false;
                return bl;
            }
            Statement statement = (Statement)iter.next();
            boolean result = this.checkTouched(statement.getObject());
            iter.close();
            boolean bl = result;
            return bl;
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
    }

    private void touch(URI id) {
        this.model.removeStatement((Resource)id, timestamp, (Node)null);
        try {
            this.model.addStatement(id, timestamp, ModelUtil.createLiteral(this.model, this.timestampLong));
        }
        catch (ModelException e) {
            throw new ModelRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String id, String key) {
        this.checkInitialization();
        this.commit();
        ClosableIterator iterator = null;
        try {
            URI idURI = ModelUtil.createURI(this.model, id);
            URI keyURI = this.toURI(key);
            iterator = this.model.findStatements(idURI, keyURI, Variable.ANY);
            if (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                if (!iterator.hasNext()) {
                    Node value = statement.getObject();
                    if (value instanceof Literal) {
                        String string = ((Literal)value).getValue();
                        return string;
                    }
                    if (value instanceof URI) {
                        String string = value.toString();
                        return string;
                    }
                }
            }
            String string = null;
            return string;
        }
        catch (ModelException me) {
            this.logger.error("Could not get value for id: '" + id + "' key: '" + key + "'", me);
            String string = null;
            return string;
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getReferredIDs(String id) {
        this.checkInitialization();
        this.commit();
        ClosableIterator iterator = null;
        HashSet<String> result = null;
        try {
            URI idURI = ModelUtil.createURI(this.model, id);
            iterator = this.model.findStatements(idURI, linksTo, Variable.ANY);
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                Node value = statement.getObject();
                if (!(value instanceof URI)) continue;
                if (result == null) {
                    result = new HashSet<String>();
                }
                result.add(((URI)value).toString());
            }
        }
        catch (ModelException me) {
            this.logger.error("Could not get referred id's", me);
            Set<String> set = null;
            return set;
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        return result;
    }

    @Override
    public int getSize() {
        this.checkInitialization();
        return this.getStoredIDs().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getStoredIDs() {
        this.checkInitialization();
        this.commit();
        ClosableIterator iterator = null;
        HashSet<String> result = new HashSet<String>();
        try {
            iterator = this.model.findStatements(Variable.ANY, Variable.ANY, Variable.ANY);
            while (iterator.hasNext()) {
                result.add(((Statement)iterator.next()).getSubject().toString());
            }
        }
        catch (ModelRuntimeException me) {
            this.logger.warn("Couldn't get stored IDs", me);
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        return result;
    }

    @Override
    public void initialize() throws IOException {
        this.timestampLong = System.currentTimeMillis();
        this.safelySleep(2L);
    }

    private void safelySleep(long ms) {
        long start = System.currentTimeMillis();
        long now = System.currentTimeMillis();
        while (now < start + ms) {
            try {
                Thread.sleep(start + ms - now);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            now = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isKnownId(String id) {
        this.checkInitialization();
        this.commit();
        ClosableIterator iterator = null;
        try {
            URI idURI = ModelUtil.createURI(this.model, id);
            iterator = this.model.findStatements(idURI, Variable.ANY, Variable.ANY);
            boolean bl = iterator.hasNext();
            return bl;
        }
        catch (ModelException me) {
            this.logger.error("Could not determine if an ID is known: " + id, me);
            boolean bl = false;
            return bl;
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    @Override
    public void put(String id, String key, String value) {
        this.checkInitialization();
        try {
            URI subject = ModelUtil.createURI(this.model, id);
            URI predicate = this.toURI(key);
            this.remove(subject, predicate);
            if (predicate == redirectsTo) {
                this.add(ModelUtil.createStatement(this.model, subject, predicate, ModelUtil.createURI(this.model, value)));
            } else {
                URI dataType = predicate == dateAsNumber || predicate == byteSize ? XSD._long : XSD._string;
                Literal object = ModelUtil.createLiteral(this.model, value, dataType);
                this.add(ModelUtil.createStatement(this.model, subject, predicate, object));
            }
            this.add(this.model.createStatement(subject, timestamp, ModelUtil.createLiteral(this.model, this.timestampLong)));
        }
        catch (ModelException e) {
            this.logger.error("Could not store info for ID " + id, e);
        }
    }

    @Override
    public void putReferredID(String id, String referredID) {
        try {
            URI subject = ModelUtil.createURI(this.model, id);
            URI object = ModelUtil.createURI(this.model, referredID);
            this.add(ModelUtil.createStatement(this.model, subject, linksTo, object));
        }
        catch (ModelException e) {
            this.logger.error("Could not store referred ID for ID " + id, e);
        }
    }

    @Override
    public void remove(String id, String key) {
        try {
            URI idURI = ModelUtil.createURI(this.model, id);
            this.remove(idURI, this.toURI(key));
        }
        catch (ModelException e) {
            this.logger.error("Could not remove value for ID " + id, e);
        }
    }

    @Override
    public void remove(String id) {
        try {
            this.remove(ModelUtil.createURI(this.model, id), null);
        }
        catch (ModelException e) {
            this.logger.error("Could not remove info about ID " + id, e);
        }
    }

    @Override
    public void removeReferredID(String id, String referredID) {
        this.commit();
        try {
            URI subject = ModelUtil.createURI(this.model, id);
            URI object = ModelUtil.createURI(this.model, referredID);
            Statement statement = ModelUtil.createStatement(this.model, subject, linksTo, object);
            this.model.removeStatement(statement);
        }
        catch (ModelException e) {
            this.logger.error("Could not remove referred ID for ID " + id, e);
        }
    }

    @Override
    public void removeReferredIDs(String id) {
        try {
            URI idURI = ModelUtil.createURI(this.model, id);
            this.remove(idURI, linksTo);
        }
        catch (ModelException e) {
            this.logger.error("Could not remove referred IDs for ID " + id, e);
        }
    }

    @Override
    public void store() throws IOException {
        this.timestampLong = -1L;
        this.commit();
    }

    private void commit() {
    }

    private URI toURI(String key) throws ModelException {
        if (key == "date") {
            return dateAsNumber;
        }
        if (key == "byteSize") {
            return byteSize;
        }
        if (key == "redirectsTo") {
            return redirectsTo;
        }
        return ModelUtil.createURI(this.model, URI_PREFIX + key);
    }

    private void add(Statement statement) {
        try {
            this.model.addStatement(statement);
        }
        catch (ModelRuntimeException e) {
            this.logger.error("Exception while adding statement", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(URI subject, URI predicate) {
        this.commit();
        ClosableIterator iter = null;
        try {
            if (predicate == null) {
                iter = this.model.findStatements(subject, aggregates, Variable.ANY);
                while (iter.hasNext()) {
                    URI child = ((Statement)iter.next()).getObject().asURI();
                    this.remove(child, null);
                }
            }
            this.model.removeStatement((Resource)subject, predicate, (Node)null);
            this.model.removeStatement(null, aggregates, subject);
        }
        catch (ModelRuntimeException e) {
            this.logger.error("Exception while removing statement", e);
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getAggregatedIDs(String id) {
        this.commit();
        ClosableIterator iterator = null;
        HashSet<String> result = new HashSet<String>();
        try {
            URI idURI = ModelUtil.createURI(this.model, id);
            iterator = this.model.findStatements(idURI, aggregates, Variable.ANY);
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                Node value = statement.getObject();
                if (!(value instanceof URI)) continue;
                result.add(((URI)value).toString());
            }
        }
        catch (ModelException me) {
            this.logger.error("Could not get referred id's", me);
            Set set = null;
            return set;
        }
        finally {
            if (iterator != null) {
                iterator.close();
            }
        }
        return result;
    }

    @Override
    public void putAggregatedID(String id, String aggregatedID) {
        try {
            URI subject = ModelUtil.createURI(this.model, id);
            URI object = ModelUtil.createURI(this.model, aggregatedID);
            this.model.removeStatement(null, aggregates, object);
            this.add(ModelUtil.createStatement(this.model, subject, aggregates, object));
        }
        catch (ModelException e) {
            this.logger.error("Could not store referred ID for ID " + id, e);
        }
    }

    @Override
    public void removeAggregatedID(String id, String aggregatedID) {
        this.commit();
        try {
            URI subject = ModelUtil.createURI(this.model, id);
            URI object = ModelUtil.createURI(this.model, aggregatedID);
            Statement statement = ModelUtil.createStatement(this.model, subject, aggregates, object);
            this.model.removeStatement(statement);
        }
        catch (ModelException e) {
            this.logger.error("Could not remove referred ID for ID " + id, e);
        }
    }

    @Override
    public void removeUntouchedIDs() {
        ClosableIterator iter = null;
        LinkedList<Resource> resourcesToRemove = new LinkedList<Resource>();
        try {
            iter = this.model.findStatements(Variable.ANY, timestamp, Variable.ANY);
            while (iter.hasNext()) {
                Statement statement = (Statement)iter.next();
                Node object = statement.getObject();
                if (this.checkTouched(object)) continue;
                resourcesToRemove.add(statement.getSubject());
            }
            iter.close();
            for (Resource resource : resourcesToRemove) {
                this.model.removeStatements(resource, Variable.ANY, Variable.ANY);
                this.model.removeStatements(Variable.ANY, aggregates, resource);
            }
        }
        catch (ModelRuntimeException e) {
            throw e;
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
    }

    @Override
    public ClosableIterator getUntouchedIDsIterator() {
        return new UntouchedIterator((ClosableIterator<? extends Statement>)this.model.findStatements(Variable.ANY, timestamp, Variable.ANY));
    }

    private boolean checkTouched(Node node) {
        boolean touched = false;
        if (node instanceof Literal) {
            Literal lit = (Literal)node;
            String value = lit.getValue();
            try {
                long longValue = Long.valueOf(value);
                if (longValue == this.timestampLong) {
                    touched = true;
                }
            }
            catch (NumberFormatException nfe) {
                touched = false;
            }
        } else {
            touched = false;
        }
        return touched;
    }

    @Override
    public void touchRecursively(String id) {
        URI idURI = this.model.createURI(id);
        this.touchURIRecursively(idURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void touchURIRecursively(URI uri) {
        this.touch(uri);
        ClosableIterator iter = null;
        try {
            iter = this.model.findStatements(uri, aggregates, Variable.ANY);
            while (iter.hasNext()) {
                Statement statement = (Statement)iter.next();
                this.touchURIRecursively(statement.getObject().asURI());
            }
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
    }

    @Override
    public ClosableIterator getAggregatedIDsClosure(String id) {
        URI idURI = this.model.createURI(id);
        return new AggregatedClosureIterator((ClosableIterator<? extends Statement>)this.model.findStatements(idURI, aggregates, Variable.ANY), id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AggregatedClosureIterator
    implements ClosableIterator {
        private List<ClosableIterator<? extends Statement>> iteratorStack;
        private String nextValue;

        public AggregatedClosureIterator(ClosableIterator<? extends Statement> firstIterator, String firstValue) {
            this.nextValue = firstValue;
            this.iteratorStack = new LinkedList<ClosableIterator<? extends Statement>>();
            this.iteratorStack.add(0, firstIterator);
        }

        public boolean hasNext() {
            this.getNextValue();
            return this.nextValue != null;
        }

        public Object next() {
            this.getNextValue();
            if (this.nextValue == null) {
                throw new NoSuchElementException();
            }
            String result = this.nextValue;
            this.nextValue = null;
            return result;
        }

        private void getNextValue() {
            if (this.nextValue != null) {
                return;
            }
            while (this.iteratorStack.size() > 0) {
                ClosableIterator<? extends Statement> iter = this.iteratorStack.get(0);
                if (iter.hasNext()) {
                    Statement statement = (Statement)iter.next();
                    this.nextValue = statement.getObject().toString();
                    this.iteratorStack.add(0, (ClosableIterator<? extends Statement>)ModelAccessData.this.model.findStatements(statement.getObject().asURI(), aggregates, Variable.ANY));
                    break;
                }
                iter.close();
                this.iteratorStack.remove(0);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            for (ClosableIterator<? extends Statement> iter : this.iteratorStack) {
                iter.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UntouchedIterator
    implements ClosableIterator {
        private ClosableIterator<? extends Statement> wrappedIterator;
        private String nextValue;

        public UntouchedIterator(ClosableIterator<? extends Statement> it) {
            this.wrappedIterator = it;
        }

        public boolean hasNext() {
            this.getNextUntouched();
            return this.nextValue != null;
        }

        public Object next() {
            this.getNextUntouched();
            String result = this.nextValue;
            this.nextValue = null;
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            this.wrappedIterator.close();
        }

        private void getNextUntouched() {
            if (this.nextValue == null) {
                while (this.wrappedIterator.hasNext()) {
                    Statement statement = (Statement)this.wrappedIterator.next();
                    Node node = statement.getObject();
                    boolean touched = ModelAccessData.this.checkTouched(node);
                    if (touched) continue;
                    this.nextValue = statement.getSubject().toString();
                    break;
                }
                if (!this.wrappedIterator.hasNext()) {
                    this.wrappedIterator.close();
                }
            }
        }
    }
}

