/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.base;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.accessor.FileDataObject;
import org.semanticdesktop.aperture.accessor.base.CountingInputStream;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDataObjectBase
extends DataObjectBase
implements FileDataObject {
    private CountingInputStream content;
    private File file;

    public FileDataObjectBase() {
    }

    public FileDataObjectBase(URI id, DataSource dataSource, RDFContainer metadata, InputStream content) {
        super(id, dataSource, metadata);
        this.setContent(content);
    }

    public FileDataObjectBase(URI id, DataSource dataSource, RDFContainer metadata, File file) {
        super(id, dataSource, metadata);
        this.setFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.closeContent();
        }
        finally {
            super.finalize();
        }
    }

    public void setContent(InputStream content) {
        if (content != null && !content.markSupported()) {
            throw new IllegalArgumentException("content should support mark and reset");
        }
        this.closeContent();
        this.content = new CountingInputStream(content);
        this.file = null;
    }

    public InputStream getContent() {
        return this.content;
    }

    public void setFile(File file) {
        if (file == null) {
            throw new NullPointerException("the file passed to a FileDataObject base cannot be null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File not found: " + file);
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Not a normal file: " + file);
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("File not readable: " + file);
        }
        this.closeContent();
        try {
            this.file = file;
            this.content = new CountingInputStream(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public File getFile() {
        return this.file;
    }

    protected void setFileWithoutChecks(File file) {
        this.file = file;
    }

    public File downloadContent() throws IOException {
        if (this.content.getCurrentByte() != 0L) {
            throw new IOException("The content stream hasn't been reset before calling getFile(), can't create a temporary file");
        }
        File file = File.createTempFile("aperture", "tmp");
        IOUtil.writeStream((InputStream)this.content, file);
        return file;
    }

    public void dispose() {
        this.closeContent();
        super.dispose();
    }

    protected void closeContent() {
        try {
            if (this.content != null) {
                this.content.close();
                this.content = null;
            }
        }
        catch (IOException e) {
            Logger logger = LoggerFactory.getLogger(this.getClass());
            logger.error("IOException while closing stream", e);
        }
    }
}

