/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.base;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.util.ArrayMap;

public class AccessDataImpl
implements AccessData {
    private static final String TIMESTAMP_KEY = "aperture.timestamp";
    private String crawlIdentifier;
    protected Map<String, Map<String, String>> idMap;
    protected Map<String, Set<String>> referredIDMap;
    protected Map<String, AggregationNode> aggregatedIDMap;

    public void initialize() throws IOException {
        if (this.idMap == null) {
            this.idMap = new HashMap<String, Map<String, String>>(1024);
        }
        if (this.referredIDMap == null) {
            this.referredIDMap = new HashMap<String, Set<String>>(1024);
        }
        if (this.aggregatedIDMap == null) {
            this.aggregatedIDMap = new HashMap<String, AggregationNode>(1024);
        }
        this.crawlIdentifier = UUID.randomUUID().toString();
    }

    public void store() throws IOException {
    }

    public void clear() throws IOException {
        this.idMap = null;
        this.referredIDMap = null;
        this.aggregatedIDMap = null;
    }

    public int getSize() {
        return this.getStoredIDs().size();
    }

    public Set getStoredIDs() {
        HashSet<String> result = new HashSet<String>(this.idMap.keySet());
        result.addAll(this.referredIDMap.keySet());
        result.addAll(this.aggregatedIDMap.keySet());
        return result;
    }

    public boolean isKnownId(String id) {
        return this.idMap.containsKey(id) || this.referredIDMap.containsKey(id) || this.aggregatedIDMap.containsKey(id);
    }

    public void put(String id, String key, String value) {
        ArrayMap infoMap = this.createInfoMap(id);
        infoMap.put(key, value);
    }

    public void putReferredID(String id, String referredID) {
        Set<String> ids = this.referredIDMap.get(id);
        if (ids == null) {
            ids = new HashSet<String>();
            this.referredIDMap.put(id, ids);
        }
        ids.add(referredID);
    }

    public String get(String id, String key) {
        ArrayMap infoMap = (ArrayMap)this.idMap.get(id);
        if (infoMap == null) {
            return null;
        }
        return (String)infoMap.get(key);
    }

    public Set getReferredIDs(String id) {
        return this.referredIDMap.get(id);
    }

    public void remove(String id, String key) {
        ArrayMap infoMap = (ArrayMap)this.idMap.get(id);
        if (infoMap != null) {
            infoMap.remove(key);
        }
    }

    public void removeReferredID(String id, String referredID) {
        HashSet ids = (HashSet)this.referredIDMap.get(id);
        if (ids != null) {
            ids.remove(referredID);
            if (ids.isEmpty()) {
                this.referredIDMap.remove(id);
            }
        }
    }

    public void removeReferredIDs(String id) {
        this.referredIDMap.remove(id);
    }

    public void remove(String id) {
        this.idMap.remove(id);
        this.referredIDMap.remove(id);
        AggregationNode node = this.aggregatedIDMap.get(id);
        if (node != null) {
            if (node.parent != null) {
                this.aggregatedIDMap.get(node.parent).children.remove(id);
            }
            Set set = this.getAggregatedIDs(id);
            for (Object obj : set) {
                this.remove(obj.toString());
            }
            this.aggregatedIDMap.remove(id);
        }
    }

    private ArrayMap createInfoMap(String id) {
        ArrayMap infoMap = (ArrayMap)this.idMap.get(id);
        if (infoMap == null) {
            infoMap = new ArrayMap();
            this.idMap.put(id, infoMap);
        }
        return infoMap;
    }

    public Set getAggregatedIDs(String id) {
        AggregationNode node = this.aggregatedIDMap.get(id);
        if (node == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(node.children);
    }

    public void putAggregatedID(String parentId, String childID) {
        AggregationNode parentNode = this.aggregatedIDMap.get(parentId);
        AggregationNode childNode = this.aggregatedIDMap.get(childID);
        if (parentNode == null) {
            parentNode = new AggregationNode(null);
            this.aggregatedIDMap.put(parentId, parentNode);
        }
        if (childNode == null) {
            childNode = new AggregationNode(parentId);
            this.aggregatedIDMap.put(childID, childNode);
        } else {
            String oldParent = childNode.parent;
            if (oldParent != null && !oldParent.equals(parentId)) {
                AggregationNode oldParentNode = this.aggregatedIDMap.get(oldParent);
                oldParentNode.children.remove(childID);
                childNode.parent = parentId;
            }
        }
        parentNode.children.add(childID);
    }

    public void removeAggregatedID(String id, String aggregatedID) {
        AggregationNode parentNode = this.aggregatedIDMap.get(id);
        AggregationNode aggregatedIDNode = this.aggregatedIDMap.get(aggregatedID);
        if (parentNode != null) {
            parentNode.children.remove(aggregatedID);
        }
        this.aggregatedIDMap.remove(aggregatedID);
    }

    public ClosableIterator getUntouchedIDsIterator() {
        return new UntouchedIterator(this.idMap.keySet().iterator());
    }

    public void removeUntouchedIDs() {
        Iterator<Map.Entry<String, Map<String, String>>> it = this.idMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Map<String, String>> entry = it.next();
            String id = entry.getKey();
            if (this.isTouched(id)) continue;
            it.remove();
            this.referredIDMap.remove(id);
            this.detachFromParent(id);
            this.aggregatedIDMap.remove(id);
        }
    }

    public void touchRecursively(String id) {
        this.touch(id);
        AggregationNode node = this.aggregatedIDMap.get(id);
        if (node != null) {
            for (String child : node.children) {
                this.touchRecursively(child);
            }
        }
    }

    public void touch(String id) {
        ArrayMap infoMap = this.createInfoMap(id);
        infoMap.put(TIMESTAMP_KEY, this.crawlIdentifier);
        infoMap = null;
    }

    public ClosableIterator getAggregatedIDsClosure(String id) {
        return new AggregatedClosureIterator(id);
    }

    public boolean isTouched(String id) {
        ArrayMap infoMap = (ArrayMap)this.idMap.get(id);
        return infoMap != null && infoMap.get(TIMESTAMP_KEY) != null && infoMap.get(TIMESTAMP_KEY).equals(this.crawlIdentifier);
    }

    void detachFromParent(String id) {
        AggregationNode node = this.aggregatedIDMap.get(id);
        if (node != null && node.parent != null) {
            AggregationNode parentNode = this.aggregatedIDMap.get(node.parent);
            if (parentNode != null) {
                parentNode.children.remove(id);
            }
            node.parent = null;
        }
    }

    private class AggregatedClosureIterator
    implements ClosableIterator {
        private List<Iterator<String>> iteratorStack;
        private String nextValue;

        public AggregatedClosureIterator(String firstValue) {
            this.nextValue = firstValue;
            this.iteratorStack = new LinkedList<Iterator<String>>();
        }

        public boolean hasNext() {
            return this.nextValue != null;
        }

        public Object next() {
            String result = this.nextValue;
            this.nextValue = null;
            AggregationNode node = AccessDataImpl.this.aggregatedIDMap.get(result);
            if (node != null) {
                this.iteratorStack.add(0, node.children.iterator());
            }
            while (this.iteratorStack.size() > 0) {
                Iterator<String> it = this.iteratorStack.get(0);
                if (it.hasNext()) {
                    this.nextValue = it.next();
                    break;
                }
                this.iteratorStack.remove(0);
            }
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }
    }

    private class UntouchedIterator
    implements ClosableIterator {
        private Iterator wrappedIterator;
        private Object nextValue;

        public UntouchedIterator(Iterator it) {
            this.wrappedIterator = it;
        }

        public boolean hasNext() {
            this.getNextUntouched();
            return this.nextValue != null;
        }

        public Object next() {
            this.getNextUntouched();
            Object result = this.nextValue;
            this.nextValue = null;
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }

        private void getNextUntouched() {
            if (this.nextValue == null) {
                while (this.wrappedIterator.hasNext()) {
                    String id = (String)this.wrappedIterator.next();
                    if (AccessDataImpl.this.isTouched(id)) continue;
                    this.nextValue = id;
                    break;
                }
            }
        }
    }

    private static class AggregationNode {
        private String parent;
        private Set<String> children;

        public AggregationNode(String parent) {
            this.parent = parent;
            this.children = new HashSet<String>();
        }
    }
}

