/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.util.io;

import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import net.sf.regain.util.io.Localizer;

public class MultiLocalizer {
    private LocalizerFactory mFactory;
    private HashMap<Locale, Localizer> mLocalizerHash;

    public MultiLocalizer(Class<?> clazz) {
        this.mFactory = new ClassLocalizerFactory(clazz);
        this.mLocalizerHash = new HashMap();
    }

    public MultiLocalizer(URL baseurl, String basename) {
        this.mFactory = new BaseLocalizerFactory(baseurl, basename);
        this.mLocalizerHash = new HashMap();
    }

    public Localizer getLocalizer(Locale locale) {
        Localizer localizer = this.mLocalizerHash.get(locale);
        if (localizer == null) {
            localizer = this.mFactory.createLocalizer(locale);
            this.mLocalizerHash.put(locale, localizer);
        }
        return localizer;
    }

    private static class BaseLocalizerFactory
    implements LocalizerFactory {
        private URL mBaseUrl;
        private String mBaseName;

        public BaseLocalizerFactory(URL baseurl, String basename) {
            this.mBaseUrl = baseurl;
            this.mBaseName = basename;
        }

        @Override
        public Localizer createLocalizer(Locale locale) {
            return new Localizer(this.mBaseUrl, this.mBaseName, locale);
        }
    }

    private static class ClassLocalizerFactory
    implements LocalizerFactory {
        private Class<?> mClazz;

        public ClassLocalizerFactory(Class<?> clazz) {
            this.mClazz = clazz;
        }

        @Override
        public Localizer createLocalizer(Locale locale) {
            return new Localizer(this.mClazz, locale);
        }
    }

    private static interface LocalizerFactory {
        public Localizer createLocalizer(Locale var1);
    }
}

