/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.util.io;

import java.util.LinkedList;
import net.sf.regain.RegainException;
import net.sf.regain.util.io.Printer;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class MemoryAppender
extends AppenderSkeleton {
    private LinkedList mCache = new LinkedList();
    private int mMaxCacheSize = 30;

    public void setMaxCacheSize(int maxCacheSize) {
        this.mMaxCacheSize = maxCacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLog(Printer printer) throws RegainException {
        LinkedList linkedList = this.mCache;
        synchronized (linkedList) {
            for (Object[] itemArr : this.mCache) {
                LoggingEvent evt = (LoggingEvent)itemArr[0];
                String formattedEvt = (String)itemArr[1];
                if (formattedEvt == null) {
                    formattedEvt = this.getLayout().format(evt);
                    itemArr[1] = formattedEvt;
                }
                printer.print(formattedEvt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void append(LoggingEvent evt) {
        LinkedList linkedList = this.mCache;
        synchronized (linkedList) {
            this.mCache.add(new Object[]{evt, null});
            if (this.mCache.size() > this.mMaxCacheSize) {
                this.mCache.removeFirst();
            }
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean requiresLayout() {
        return true;
    }
}

