/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.util.io;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.regain.RegainToolkit;
import org.apache.log4j.Logger;

public class Localizer {
    private static Logger mLog = Logger.getLogger(Localizer.class.getName());
    private ResourceBundle mBundle;
    private String mKeyPrefix;
    private static HashMap mFileClassLoaderHash;

    public Localizer(URL baseurl, String basename, Locale locale) {
        try {
            URLClassLoader loader = Localizer.getClassLoader(baseurl);
            this.mBundle = ResourceBundle.getBundle(basename, locale, loader);
        }
        catch (Throwable thr) {
            mLog.error("ResourceBundle not found: '" + basename + "'", thr);
        }
        this.mKeyPrefix = "";
    }

    public Localizer(Class clazz) {
        this(clazz, Locale.getDefault());
    }

    public Localizer(Class clazz, Locale locale) {
        String packageName;
        String className = clazz.getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot == -1) {
            this.mKeyPrefix = className + ".";
            packageName = "";
        } else {
            this.mKeyPrefix = className.substring(lastDot + 1) + ".";
            packageName = className.substring(0, lastDot);
        }
        do {
            String basename = packageName.length() == 0 ? "msg" : packageName + ".msg";
            try {
                this.mBundle = ResourceBundle.getBundle(basename, locale, clazz.getClassLoader());
            }
            catch (MissingResourceException exc) {
                // empty catch block
            }
            if (this.mBundle != null) continue;
            if (packageName.length() == 0) {
                mLog.error("ResourceBundle not found for class '" + clazz + "'");
                return;
            }
            lastDot = packageName.lastIndexOf(46);
            packageName = lastDot == -1 ? "" : packageName.substring(0, lastDot);
        } while (this.mBundle == null);
    }

    private static synchronized URLClassLoader getClassLoader(URL baseurl) throws MalformedURLException {
        String baseurlAsString;
        URLClassLoader loader;
        if (mFileClassLoaderHash == null) {
            mFileClassLoaderHash = new HashMap();
        }
        if ((loader = (URLClassLoader)mFileClassLoaderHash.get(baseurlAsString = baseurl.toExternalForm())) == null) {
            loader = new URLClassLoader(new URL[]{baseurl});
            mFileClassLoaderHash.put(baseurlAsString, loader);
        }
        return loader;
    }

    public String msg(String key, String defaultMsg, Object arg1) {
        return this.msg(key, defaultMsg, new Object[]{arg1});
    }

    public String msg(String key, String defaultMsg, Object arg1, Object arg2) {
        return this.msg(key, defaultMsg, new Object[]{arg1, arg2});
    }

    public String msg(String key, String defaultMsg, Object arg1, Object arg2, Object arg3) {
        return this.msg(key, defaultMsg, new Object[]{arg1, arg2, arg3});
    }

    public String msg(String key, String defaultMsg, Object[] args) {
        String msg = this.msg(key, defaultMsg);
        msg = RegainToolkit.replace(msg, "'", "''");
        MessageFormat format = new MessageFormat(msg, this.mBundle.getLocale());
        return format.format(args);
    }

    public String msg(String key, String defaultMsg) {
        key = this.mKeyPrefix + key;
        String msg = null;
        if (this.mBundle != null) {
            try {
                msg = this.mBundle.getString(key);
            }
            catch (MissingResourceException exc) {
                // empty catch block
            }
        }
        if (msg == null) {
            return "[" + key + "#" + defaultMsg + "]";
        }
        return msg;
    }
}

