/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.util.io;

import java.util.Hashtable;

public class HtmlEntities {
    static final Hashtable<String, String> decoder = new Hashtable(300);
    static final Hashtable<String, String> decoderXML = new Hashtable(300);
    static final String[] encoder = new String[256];
    static final String[] encoderXML = new String[256];

    public static final String decode(String entity) {
        return HtmlEntities._decode(decoder, entity);
    }

    public static final String decodeXML(String entity) {
        return HtmlEntities._decode(decoderXML, entity);
    }

    private static final String _decode(Hashtable<String, String> decoder, String entity) {
        if (entity.charAt(entity.length() - 1) == ';') {
            entity = entity.substring(0, entity.length() - 1);
        }
        if (entity.charAt(1) == '#') {
            int start = 2;
            int radix = 10;
            if (entity.charAt(2) == 'X' || entity.charAt(2) == 'x') {
                ++start;
                radix = 16;
            }
            Character c = Character.valueOf((char)Integer.parseInt(entity.substring(start), radix));
            return c.toString();
        }
        String s = decoder.get(entity);
        if (s != null) {
            return s;
        }
        return "";
    }

    public static final String encode(String s) {
        return HtmlEntities._encode(encoder, s, true);
    }

    public static final String encodeXML(String s) {
        return HtmlEntities._encode(encoderXML, s, false);
    }

    private static final String _encode(String[] encoder, String s, boolean encodeUnknownEntities) {
        int length = s.length();
        StringBuffer buffer = new StringBuffer(length * 2);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            char j = c;
            if (j < '\u0100' && encoder[j] != null) {
                buffer.append(encoder[j]);
                buffer.append(';');
                continue;
            }
            if (j < ' ' && j != '\r' && j != '\n') continue;
            if (j < '\u0080' || !encodeUnknownEntities) {
                buffer.append(c);
                continue;
            }
            buffer.append("&#");
            buffer.append((int)c);
            buffer.append(';');
        }
        return buffer.toString();
    }

    static final void add(String entity, int value) {
        decoder.put(entity, Character.valueOf((char)value).toString());
        if (value < 256) {
            HtmlEntities.encoder[value] = entity;
        }
    }

    static final void addXML(String entity, int value) {
        decoderXML.put(entity, Character.valueOf((char)value).toString());
        if (value < 256) {
            HtmlEntities.encoderXML[value] = entity;
        }
    }

    static {
        HtmlEntities.add("&nbsp", 160);
        HtmlEntities.add("&iexcl", 161);
        HtmlEntities.add("&cent", 162);
        HtmlEntities.add("&pound", 163);
        HtmlEntities.add("&curren", 164);
        HtmlEntities.add("&yen", 165);
        HtmlEntities.add("&brvbar", 166);
        HtmlEntities.add("&sect", 167);
        HtmlEntities.add("&uml", 168);
        HtmlEntities.add("&copy", 169);
        HtmlEntities.add("&ordf", 170);
        HtmlEntities.add("&laquo", 171);
        HtmlEntities.add("&not", 172);
        HtmlEntities.add("&shy", 173);
        HtmlEntities.add("&reg", 174);
        HtmlEntities.add("&macr", 175);
        HtmlEntities.add("&deg", 176);
        HtmlEntities.add("&plusmn", 177);
        HtmlEntities.add("&sup2", 178);
        HtmlEntities.add("&sup3", 179);
        HtmlEntities.add("&acute", 180);
        HtmlEntities.add("&micro", 181);
        HtmlEntities.add("&para", 182);
        HtmlEntities.add("&middot", 183);
        HtmlEntities.add("&cedil", 184);
        HtmlEntities.add("&sup1", 185);
        HtmlEntities.add("&ordm", 186);
        HtmlEntities.add("&raquo", 187);
        HtmlEntities.add("&frac14", 188);
        HtmlEntities.add("&frac12", 189);
        HtmlEntities.add("&frac34", 190);
        HtmlEntities.add("&iquest", 191);
        HtmlEntities.add("&Agrave", 192);
        HtmlEntities.add("&Aacute", 193);
        HtmlEntities.add("&Acirc", 194);
        HtmlEntities.add("&Atilde", 195);
        HtmlEntities.add("&Auml", 196);
        HtmlEntities.add("&Aring", 197);
        HtmlEntities.add("&AElig", 198);
        HtmlEntities.add("&Ccedil", 199);
        HtmlEntities.add("&Egrave", 200);
        HtmlEntities.add("&Eacute", 201);
        HtmlEntities.add("&Ecirc", 202);
        HtmlEntities.add("&Euml", 203);
        HtmlEntities.add("&Igrave", 204);
        HtmlEntities.add("&Iacute", 205);
        HtmlEntities.add("&Icirc", 206);
        HtmlEntities.add("&Iuml", 207);
        HtmlEntities.add("&ETH", 208);
        HtmlEntities.add("&Ntilde", 209);
        HtmlEntities.add("&Ograve", 210);
        HtmlEntities.add("&Oacute", 211);
        HtmlEntities.add("&Ocirc", 212);
        HtmlEntities.add("&Otilde", 213);
        HtmlEntities.add("&Ouml", 214);
        HtmlEntities.add("&times", 215);
        HtmlEntities.add("&Oslash", 216);
        HtmlEntities.add("&Ugrave", 217);
        HtmlEntities.add("&Uacute", 218);
        HtmlEntities.add("&Ucirc", 219);
        HtmlEntities.add("&Uuml", 220);
        HtmlEntities.add("&Yacute", 221);
        HtmlEntities.add("&THORN", 222);
        HtmlEntities.add("&szlig", 223);
        HtmlEntities.add("&agrave", 224);
        HtmlEntities.add("&aacute", 225);
        HtmlEntities.add("&acirc", 226);
        HtmlEntities.add("&atilde", 227);
        HtmlEntities.add("&auml", 228);
        HtmlEntities.add("&aring", 229);
        HtmlEntities.add("&aelig", 230);
        HtmlEntities.add("&ccedil", 231);
        HtmlEntities.add("&egrave", 232);
        HtmlEntities.add("&eacute", 233);
        HtmlEntities.add("&ecirc", 234);
        HtmlEntities.add("&euml", 235);
        HtmlEntities.add("&igrave", 236);
        HtmlEntities.add("&iacute", 237);
        HtmlEntities.add("&icirc", 238);
        HtmlEntities.add("&iuml", 239);
        HtmlEntities.add("&eth", 240);
        HtmlEntities.add("&ntilde", 241);
        HtmlEntities.add("&ograve", 242);
        HtmlEntities.add("&oacute", 243);
        HtmlEntities.add("&ocirc", 244);
        HtmlEntities.add("&otilde", 245);
        HtmlEntities.add("&ouml", 246);
        HtmlEntities.add("&divide", 247);
        HtmlEntities.add("&oslash", 248);
        HtmlEntities.add("&ugrave", 249);
        HtmlEntities.add("&uacute", 250);
        HtmlEntities.add("&ucirc", 251);
        HtmlEntities.add("&uuml", 252);
        HtmlEntities.add("&yacute", 253);
        HtmlEntities.add("&thorn", 254);
        HtmlEntities.add("&yuml", 255);
        HtmlEntities.add("&fnof", 402);
        HtmlEntities.add("&Alpha", 913);
        HtmlEntities.add("&Beta", 914);
        HtmlEntities.add("&Gamma", 915);
        HtmlEntities.add("&Delta", 916);
        HtmlEntities.add("&Epsilon", 917);
        HtmlEntities.add("&Zeta", 918);
        HtmlEntities.add("&Eta", 919);
        HtmlEntities.add("&Theta", 920);
        HtmlEntities.add("&Iota", 921);
        HtmlEntities.add("&Kappa", 922);
        HtmlEntities.add("&Lambda", 923);
        HtmlEntities.add("&Mu", 924);
        HtmlEntities.add("&Nu", 925);
        HtmlEntities.add("&Xi", 926);
        HtmlEntities.add("&Omicron", 927);
        HtmlEntities.add("&Pi", 928);
        HtmlEntities.add("&Rho", 929);
        HtmlEntities.add("&Sigma", 931);
        HtmlEntities.add("&Tau", 932);
        HtmlEntities.add("&Upsilon", 933);
        HtmlEntities.add("&Phi", 934);
        HtmlEntities.add("&Chi", 935);
        HtmlEntities.add("&Psi", 936);
        HtmlEntities.add("&Omega", 937);
        HtmlEntities.add("&alpha", 945);
        HtmlEntities.add("&beta", 946);
        HtmlEntities.add("&gamma", 947);
        HtmlEntities.add("&delta", 948);
        HtmlEntities.add("&epsilon", 949);
        HtmlEntities.add("&zeta", 950);
        HtmlEntities.add("&eta", 951);
        HtmlEntities.add("&theta", 952);
        HtmlEntities.add("&iota", 953);
        HtmlEntities.add("&kappa", 954);
        HtmlEntities.add("&lambda", 955);
        HtmlEntities.add("&mu", 956);
        HtmlEntities.add("&nu", 957);
        HtmlEntities.add("&xi", 958);
        HtmlEntities.add("&omicron", 959);
        HtmlEntities.add("&pi", 960);
        HtmlEntities.add("&rho", 961);
        HtmlEntities.add("&sigmaf", 962);
        HtmlEntities.add("&sigma", 963);
        HtmlEntities.add("&tau", 964);
        HtmlEntities.add("&upsilon", 965);
        HtmlEntities.add("&phi", 966);
        HtmlEntities.add("&chi", 967);
        HtmlEntities.add("&psi", 968);
        HtmlEntities.add("&omega", 969);
        HtmlEntities.add("&thetasym", 977);
        HtmlEntities.add("&upsih", 978);
        HtmlEntities.add("&piv", 982);
        HtmlEntities.add("&bull", 8226);
        HtmlEntities.add("&hellip", 8230);
        HtmlEntities.add("&prime", 8242);
        HtmlEntities.add("&Prime", 8243);
        HtmlEntities.add("&oline", 8254);
        HtmlEntities.add("&frasl", 8260);
        HtmlEntities.add("&weierp", 8472);
        HtmlEntities.add("&image", 8465);
        HtmlEntities.add("&real", 8476);
        HtmlEntities.add("&trade", 8482);
        HtmlEntities.add("&alefsym", 8501);
        HtmlEntities.add("&larr", 8592);
        HtmlEntities.add("&uarr", 8593);
        HtmlEntities.add("&rarr", 8594);
        HtmlEntities.add("&darr", 8595);
        HtmlEntities.add("&harr", 8596);
        HtmlEntities.add("&crarr", 8629);
        HtmlEntities.add("&lArr", 8656);
        HtmlEntities.add("&uArr", 8657);
        HtmlEntities.add("&rArr", 8658);
        HtmlEntities.add("&dArr", 8659);
        HtmlEntities.add("&hArr", 8660);
        HtmlEntities.add("&forall", 8704);
        HtmlEntities.add("&part", 8706);
        HtmlEntities.add("&exist", 8707);
        HtmlEntities.add("&empty", 8709);
        HtmlEntities.add("&nabla", 8711);
        HtmlEntities.add("&isin", 8712);
        HtmlEntities.add("&notin", 8713);
        HtmlEntities.add("&ni", 8715);
        HtmlEntities.add("&prod", 8719);
        HtmlEntities.add("&sum", 8721);
        HtmlEntities.add("&minus", 8722);
        HtmlEntities.add("&lowast", 8727);
        HtmlEntities.add("&radic", 8730);
        HtmlEntities.add("&prop", 8733);
        HtmlEntities.add("&infin", 8734);
        HtmlEntities.add("&ang", 8736);
        HtmlEntities.add("&and", 8743);
        HtmlEntities.add("&or", 8744);
        HtmlEntities.add("&cap", 8745);
        HtmlEntities.add("&cup", 8746);
        HtmlEntities.add("&int", 8747);
        HtmlEntities.add("&there4", 8756);
        HtmlEntities.add("&sim", 8764);
        HtmlEntities.add("&cong", 8773);
        HtmlEntities.add("&asymp", 8776);
        HtmlEntities.add("&ne", 8800);
        HtmlEntities.add("&equiv", 8801);
        HtmlEntities.add("&le", 8804);
        HtmlEntities.add("&ge", 8805);
        HtmlEntities.add("&sub", 8834);
        HtmlEntities.add("&sup", 8835);
        HtmlEntities.add("&nsub", 8836);
        HtmlEntities.add("&sube", 8838);
        HtmlEntities.add("&supe", 8839);
        HtmlEntities.add("&oplus", 8853);
        HtmlEntities.add("&otimes", 8855);
        HtmlEntities.add("&perp", 8869);
        HtmlEntities.add("&sdot", 8901);
        HtmlEntities.add("&lceil", 8968);
        HtmlEntities.add("&rceil", 8969);
        HtmlEntities.add("&lfloor", 8970);
        HtmlEntities.add("&rfloor", 8971);
        HtmlEntities.add("&lang", 9001);
        HtmlEntities.add("&rang", 9002);
        HtmlEntities.add("&loz", 9674);
        HtmlEntities.add("&spades", 9824);
        HtmlEntities.add("&clubs", 9827);
        HtmlEntities.add("&hearts", 9829);
        HtmlEntities.add("&diams", 9830);
        HtmlEntities.add("&quot", 34);
        HtmlEntities.add("&amp", 38);
        HtmlEntities.add("&lt", 60);
        HtmlEntities.add("&gt", 62);
        HtmlEntities.add("&OElig", 338);
        HtmlEntities.add("&oelig", 339);
        HtmlEntities.add("&Scaron", 352);
        HtmlEntities.add("&scaron", 353);
        HtmlEntities.add("&Yuml", 376);
        HtmlEntities.add("&circ", 710);
        HtmlEntities.add("&tilde", 732);
        HtmlEntities.add("&ensp", 8194);
        HtmlEntities.add("&emsp", 8195);
        HtmlEntities.add("&thinsp", 8201);
        HtmlEntities.add("&zwnj", 8204);
        HtmlEntities.add("&zwj", 8205);
        HtmlEntities.add("&lrm", 8206);
        HtmlEntities.add("&rlm", 8207);
        HtmlEntities.add("&ndash", 8211);
        HtmlEntities.add("&mdash", 8212);
        HtmlEntities.add("&lsquo", 8216);
        HtmlEntities.add("&rsquo", 8217);
        HtmlEntities.add("&sbquo", 8218);
        HtmlEntities.add("&ldquo", 8220);
        HtmlEntities.add("&rdquo", 8221);
        HtmlEntities.add("&bdquo", 8222);
        HtmlEntities.add("&dagger", 8224);
        HtmlEntities.add("&Dagger", 8225);
        HtmlEntities.add("&permil", 8240);
        HtmlEntities.add("&lsaquo", 8249);
        HtmlEntities.add("&rsaquo", 8250);
        HtmlEntities.add("&euro", 8364);
        HtmlEntities.addXML("&quot", 34);
        HtmlEntities.addXML("&amp", 38);
        HtmlEntities.addXML("&lt", 60);
        HtmlEntities.addXML("&gt", 62);
        HtmlEntities.addXML("&apos", 39);
    }
}

