/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ChainedHashMap<K, V>
implements Map<K, V>,
Iterable<Map.Entry<K, V>> {
    private static final int DEFAULT_HASHTABLE_SIZE = 20;
    private static final int DEFAULT_LIST_SIZE = 10;
    private int listSize;
    HashMap<K, List<V>> hashtable;
    int size;

    public ChainedHashMap() {
        this(20);
    }

    public ChainedHashMap(int hashtableSize) {
        this(hashtableSize, 10);
    }

    public ChainedHashMap(int hashtableSize, int chainSize) {
        this.hashtable = new HashMap(hashtableSize);
        this.listSize = chainSize;
        this.size = 0;
    }

    public ChainedHashMap(Map<? extends K, ? extends V> map) {
        this();
        if (map instanceof ChainedHashMap) {
            ChainedHashMap hashtable = (ChainedHashMap)map;
            for (K key : hashtable.keySet()) {
                for (V value : hashtable.getList(key)) {
                    this.put((K)key, (V)value);
                }
            }
        } else {
            this.putAll(map);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hashtable.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.isEmpty()) {
            return false;
        }
        Collection<List<V>> elements = this.hashtable.values();
        for (List<V> list : elements) {
            if (!list.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        List<V> list = this.hashtable.get(key);
        if (list == null) {
            return null;
        }
        return list.get(0);
    }

    public Iterable<V> getIterable(Object key) {
        final List<V> list = this.hashtable.get(key);
        if (list == null) {
            return new Iterable<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){

                        @Override
                        public boolean hasNext() {
                            return false;
                        }

                        @Override
                        public V next() {
                            throw new NoSuchElementException("Empty");
                        }

                        @Override
                        public void remove() {
                        }
                    };
                }
            };
        }
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return list.iterator();
            }
        };
    }

    public List<V> getList(Object key) {
        List<V> list = this.hashtable.get(key);
        if (list == null) {
            list = new ArrayList<V>();
        }
        return list;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        if (this.size == 0) {
            return new Iterator<Map.Entry<K, V>>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    throw new NoSuchElementException("Empty");
                }

                @Override
                public void remove() {
                }
            };
        }
        ArrayList<AbstractMap.SimpleEntry<K, V>> entries = new ArrayList<AbstractMap.SimpleEntry<K, V>>();
        for (K key : this.hashtable.keySet()) {
            List<V> values = this.hashtable.get(key);
            for (V value : values) {
                entries.add(new AbstractMap.SimpleEntry<K, V>(key, value));
            }
        }
        return entries.iterator();
    }

    @Override
    public V put(K key, V value) {
        boolean success;
        List<V> list = this.hashtable.get(key);
        if (list == null) {
            list = new ArrayList<V>(this.listSize);
            success = list.add(value);
            this.hashtable.put(key, list);
        } else {
            success = list.add(value);
        }
        if (success) {
            ++this.size;
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        List<V> list = this.hashtable.remove(key);
        if (list == null) {
            return null;
        }
        V element = list.get(0);
        this.size -= list.size();
        return element;
    }

    @Override
    public boolean remove(K key, V value) {
        List<V> list = this.hashtable.get(key);
        if (list == null) {
            return false;
        }
        boolean removed = list.remove(value);
        if (removed) {
            if (list.isEmpty()) {
                this.hashtable.remove(key);
            }
            --this.size;
        }
        return removed;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.hashtable.clear();
        this.size = 0;
    }

    @Override
    public Set<K> keySet() {
        return this.hashtable.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> newList = new ArrayList<V>();
        if (this.isEmpty()) {
            return newList;
        }
        Collection<List<V>> values = this.hashtable.values();
        for (List<V> list : values) {
            newList.addAll(list);
        }
        return newList;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("entrySet is not implemented, as identical entries are allowed (conflict with Set contract). Instead, use .iterator() to iterate through all entries.");
    }

    public String toString() {
        StringBuffer str = new StringBuffer(200);
        for (K key : this.hashtable.keySet()) {
            str.append(key).append(":\n");
            List<V> values = this.hashtable.get(key);
            for (V value : values) {
                str.append("\t").append(value).append("\n");
            }
            str.append("\n");
        }
        return str.toString();
    }
}

