/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.plugin;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.regain.crawler.Crawler;
import net.sf.regain.crawler.CrawlerJob;
import net.sf.regain.crawler.document.RawDocument;
import net.sf.regain.crawler.document.WriteablePreparator;
import net.sf.regain.crawler.plugin.CrawlerPlugin;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;

public class CrawlerPluginManager {
    private static final int MAX_PLUGINS = 100;
    private SortedMap<Integer, CrawlerPlugin> plugins = new TreeMap<Integer, CrawlerPlugin>();
    private static CrawlerPluginManager instance = null;
    private static Logger mLog = Logger.getLogger(CrawlerPluginManager.class);
    private int nextOrder = 1;
    private int insertIndex = 0;

    public static CrawlerPluginManager getInstance() {
        if (instance == null) {
            instance = new CrawlerPluginManager();
        }
        return instance;
    }

    protected CrawlerPluginManager() {
    }

    public void registerPlugin(CrawlerPlugin plugin) {
        this.registerPlugin(plugin, this.nextOrder);
    }

    public void registerPlugin(CrawlerPlugin plugin, int order) {
        this.plugins.put(100 * order + this.insertIndex, plugin);
        if (order + 1 > this.nextOrder) {
            this.nextOrder = order + 1;
        }
        ++this.insertIndex;
    }

    public void unregisterPlugin(CrawlerPlugin plugin) {
        this.plugins.values().remove(plugin);
    }

    public void clear() {
        this.plugins.clear();
        this.nextOrder = 1;
        this.insertIndex = 0;
    }

    protected List<Object> triggerEvent(String methodName, Class<?>[] argTypes, Object ... args) {
        ArrayList<Object> returns = new ArrayList<Object>();
        this.checkIfEventExists(methodName, argTypes);
        for (Map.Entry<Integer, CrawlerPlugin> entry : this.plugins.entrySet()) {
            Object ret = null;
            CrawlerPlugin plugin = entry.getValue();
            String pluginName = plugin.getClass().getName();
            mLog.debug("Send " + methodName + "-Event to " + pluginName);
            try {
                ret = MethodUtils.invokeMethod(plugin, methodName, args, argTypes);
            }
            catch (IllegalAccessException e) {
                mLog.error("Reflection Error:", e);
            }
            catch (SecurityException e) {
                mLog.error("Reflection Error:", e);
            }
            catch (NoSuchMethodException e) {
                mLog.error("Reflection Error:", e);
            }
            catch (InvocationTargetException e) {
                mLog.error(pluginName + " has thrown an exception:", e.getCause());
            }
            catch (Throwable e) {
                mLog.error(pluginName + " has thrown an exception:", e);
            }
            returns.add(ret);
        }
        return returns;
    }

    private void checkArgsNotNull(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) continue;
            throw new IllegalArgumentException("Plugin manager was called with null parameter (param nb " + (i + 1) + ")");
        }
    }

    protected void checkIfEventExists(String methodName, Class<?>[] argTypes) {
        try {
            CrawlerPlugin.class.getMethod(methodName, argTypes);
        }
        catch (SecurityException e) {
            mLog.error("Reflection Error:", e);
        }
        catch (NoSuchMethodException e1) {
            String methodSignature = methodName + "(" + this.argTypesToString(argTypes) + ")";
            throw new RuntimeException("There is no event with this name (or different arguments): " + methodSignature + " declared in the CrawlerPlugin-Interface");
        }
    }

    private String argTypesToString(Class<?>[] argTypes) {
        StringBuilder ret = new StringBuilder(100);
        for (int i = 0; i < argTypes.length; ++i) {
            ret.append(argTypes[i].getCanonicalName());
            if (i >= argTypes.length - 1) continue;
            ret.append(", ");
        }
        return ret.toString();
    }

    public void eventStartCrawling(Crawler crawler) {
        this.triggerEvent("onStartCrawling", new Class[]{Crawler.class}, crawler);
    }

    public void eventFinishCrawling(Crawler crawler) {
        this.triggerEvent("onFinishCrawling", new Class[]{Crawler.class}, crawler);
    }

    public void eventBeforePrepare(RawDocument document, WriteablePreparator preparator) {
        this.triggerEvent("onBeforePrepare", new Class[]{RawDocument.class, WriteablePreparator.class}, document, preparator);
    }

    public void eventAfterPrepare(RawDocument document, WriteablePreparator preparator) {
        this.triggerEvent("onAfterPrepare", new Class[]{RawDocument.class, WriteablePreparator.class}, document, preparator);
    }

    public void eventCreateIndexEntry(Document doc, IndexWriter index) {
        this.triggerEvent("onCreateIndexEntry", new Class[]{Document.class, IndexWriter.class}, doc, index);
    }

    public void eventDeleteIndexEntry(Document doc, IndexReader index) {
        this.triggerEvent("onDeleteIndexEntry", new Class[]{Document.class, IndexReader.class}, doc, index);
    }

    public void eventAcceptURL(String url, CrawlerJob job) {
        this.triggerEvent("onAcceptURL", new Class[]{String.class, CrawlerJob.class}, url, job);
    }

    public void eventDeclineURL(String url) {
        this.triggerEvent("onDeclineURL", new Class[]{String.class}, url);
    }

    public boolean eventAskDynamicBlacklist(String url, String sourceUrl, String sourceLinkText) {
        List<Object> returns = this.triggerEvent("checkDynamicBlacklist", new Class[]{String.class, String.class, String.class}, url, sourceUrl, sourceLinkText);
        int i = 0;
        for (Object ret : returns) {
            if (!(ret instanceof Boolean)) continue;
            boolean blacklist = (Boolean)ret;
            if (blacklist) {
                if (mLog.isDebugEnabled()) {
                    CrawlerPlugin cp = null;
                    for (Map.Entry<Integer, CrawlerPlugin> entry : this.plugins.entrySet()) {
                        cp = entry.getValue();
                        if (i == 0) break;
                        --i;
                    }
                    mLog.debug("URL dynamically blacklisted by CrawlerPlugin " + cp.getClass().getName());
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Contains ").append(this.plugins.size()).append(" Plugins: \n");
        for (Map.Entry<Integer, CrawlerPlugin> entry : this.plugins.entrySet()) {
            str.append("Plugin ").append(entry.getValue().getClass().getName());
            str.append(" with order ").append(entry.getKey()).append("\n");
        }
        return str.toString();
    }
}

