/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.document;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPSSLStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.zip.CRC32;
import javax.mail.Flags;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import jcifs.smb.SmbFile;
import net.sf.regain.ImapToolkit;
import net.sf.regain.RegainException;
import net.sf.regain.RegainToolkit;
import net.sf.regain.crawler.CrawlerToolkit;
import net.sf.regain.crawler.Profiler;
import net.sf.regain.crawler.RedirectException;
import net.sf.regain.crawler.access.AccountPasswordEntry;
import net.sf.regain.crawler.document.HttpDownloadThread;
import org.apache.log4j.Logger;

public class RawDocument {
    private static Logger mLog = Logger.getLogger(RawDocument.class);
    private static final Profiler HTTP_LOADING_PROFILER = new Profiler("Documents loaded with HTTP", "docs");
    private static final Profiler FILE_LOADING_PROFILER = new Profiler("Documents loaded from the file system", "docs");
    private static int mHttpTimeoutSecs = 180;
    private String mUrl;
    private String mSourceUrl;
    private String mSourceLinkText;
    private byte[] mContent;
    private String mContentAsString;
    private File mContentAsFile;
    private boolean mContentAsFileIsTemporary;
    private String mMimeType;
    private HashMap<String, String> mLinks;
    AccountPasswordEntry mAccountPasswordEntry;
    Date mLastModifiedDate = new Date();

    public RawDocument(String url, String sourceUrl, String sourceLinkText, AccountPasswordEntry accountPasswordEntry) throws RegainException {
        this.mLinks = new HashMap();
        this.mUrl = url;
        this.mSourceUrl = sourceUrl;
        this.mSourceLinkText = sourceLinkText;
        this.mAccountPasswordEntry = accountPasswordEntry;
        if (url.startsWith("file://")) {
            this.mContentAsFile = RegainToolkit.urlToFile(url);
            this.mLastModifiedDate = new Date(this.mContentAsFile.lastModified());
        } else if (url.startsWith("smb://")) {
            this.mContent = null;
            this.mContentAsFile = null;
        } else if (url.startsWith("imap://") || url.startsWith("imaps://")) {
            this.mContent = null;
            this.mContentAsFile = null;
        } else {
            this.mContent = this.loadContent(url);
            this.mContentAsFile = null;
        }
    }

    public static void setHttpTimeoutSecs(int httpTimeoutSecs) {
        mHttpTimeoutSecs = httpTimeoutSecs;
    }

    private byte[] loadIMAPMessage(String url) throws RegainException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytearrayMessage = new byte[]{};
        try {
            Matcher matcher = ImapToolkit.getMessagePattern().matcher(url);
            matcher.find();
            if (matcher.groupCount() > 0) {
                int messageUID = Integer.parseInt(matcher.group(3));
                mLog.debug("Read mime message uid: " + messageUID + " for IMAP url: " + url);
                Session session = Session.getInstance(new Properties());
                URLName originURLName = new URLName(ImapToolkit.cutMessageIdentifier(CrawlerToolkit.replaceAuthenticationValuesInURL(url, this.mAccountPasswordEntry)));
                String folder = "";
                if (originURLName.getFile() != null) {
                    folder = originURLName.getFile().replaceAll("%20", " ");
                }
                URLName urlName = new URLName(originURLName.getProtocol(), originURLName.getHost(), originURLName.getPort(), folder, originURLName.getUsername(), originURLName.getPassword());
                IMAPSSLStore imapStore = new IMAPSSLStore(session, urlName);
                imapStore.connect();
                IMAPFolder currentFolder = urlName.getFile() == null ? (IMAPFolder)imapStore.getDefaultFolder() : (IMAPFolder)imapStore.getFolder(urlName.getFile());
                currentFolder.open(2);
                MimeMessage cplMessage = (MimeMessage)currentFolder.getMessageByUID(messageUID);
                if (cplMessage != null) {
                    cplMessage.setFlag(Flags.Flag.SEEN, true);
                    cplMessage.writeTo(baos);
                    baos.flush();
                    bytearrayMessage = baos.toByteArray();
                    baos.close();
                    this.mLastModifiedDate = cplMessage.getSentDate();
                }
                currentFolder.close(false);
                imapStore.close();
            }
        }
        catch (Throwable thr) {
            throw new RegainException(thr.getMessage(), thr);
        }
        CRC32 crc = new CRC32();
        crc.update(bytearrayMessage);
        mLog.debug("loadIMAPMessage crc: " + crc.getValue() + " for IMAP url: " + url);
        return bytearrayMessage;
    }

    private byte[] loadSmbFile(String url) throws RegainException {
        InputStream in = null;
        try {
            SmbFile smbFile = RegainToolkit.urlToSmbFile(CrawlerToolkit.replaceAuthenticationValuesInURL(url, this.mAccountPasswordEntry));
            if (smbFile.canRead() && !smbFile.isDirectory()) {
                in = smbFile.getInputStream();
                this.mLastModifiedDate = new Date(smbFile.lastModified());
                byte[] byArray = CrawlerToolkit.loadFileFromStream(in, smbFile.getContentLength());
                return byArray;
            }
            try {
                throw new RegainException("Can't load content from: " + smbFile.getCanonicalPath());
            }
            catch (Throwable thr) {
                throw new RegainException(thr.getMessage(), thr);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException exc) {}
            }
        }
    }

    private byte[] loadContent(String url) throws RegainException {
        HTTP_LOADING_PROFILER.startMeasuring();
        HttpDownloadThread loaderThread = new HttpDownloadThread(CrawlerToolkit.replaceAuthenticationValuesInURL(url, this.mAccountPasswordEntry), Thread.currentThread());
        loaderThread.start();
        try {
            Thread.sleep(mHttpTimeoutSecs * 1000);
        }
        catch (InterruptedException exc) {
            // empty catch block
        }
        byte[] content = loaderThread.getContent();
        if (content != null) {
            HTTP_LOADING_PROFILER.stopMeasuring(content.length);
            return content;
        }
        HTTP_LOADING_PROFILER.abortMeasuring();
        if (loaderThread.getError() != null) {
            if (loaderThread.getError() instanceof RedirectException) {
                throw (RedirectException)loaderThread.getError();
            }
            throw new RegainException("Loading Document by HTTP failed: " + url, loaderThread.getError());
        }
        throw new RegainException("Loading Document by HTTP timed out after " + mHttpTimeoutSecs + " seconds: " + url);
    }

    public int getLength() {
        int length = 0;
        if (this.mContent != null) {
            length = this.mContent.length;
        } else if (this.mContentAsFile != null) {
            length = (int)this.mContentAsFile.length();
        } else if (this.mUrl.startsWith("smb://")) {
            try {
                length = (int)RegainToolkit.urlToSmbFile(CrawlerToolkit.replaceAuthenticationValuesInURL(this.mUrl, this.mAccountPasswordEntry)).length();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return length;
    }

    public Date getLastModified() {
        return this.mLastModifiedDate;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public String getSourceUrl() {
        return this.mSourceUrl;
    }

    public String getSourceLinkText() {
        return this.mSourceLinkText;
    }

    public byte[] getContent() throws RegainException {
        if (this.mContent == null) {
            FILE_LOADING_PROFILER.startMeasuring();
            try {
                byte[] content = new byte[]{};
                if (this.mUrl.startsWith("file://")) {
                    content = CrawlerToolkit.loadFile(this.mContentAsFile);
                } else if (this.mUrl.startsWith("smb://")) {
                    content = this.loadSmbFile(this.mUrl);
                    this.mContent = content;
                } else if (this.mUrl.startsWith("imap://") || this.mUrl.startsWith("imaps://")) {
                    content = this.loadIMAPMessage(this.mUrl);
                    this.mContent = content;
                }
                FILE_LOADING_PROFILER.stopMeasuring(content.length);
                return content;
            }
            catch (RegainException exc) {
                FILE_LOADING_PROFILER.abortMeasuring();
                throw new RegainException("Loading Document for url: " + this.mUrl + " failed: " + this.mContentAsFile, exc);
            }
        }
        return this.mContent;
    }

    public String getContentAsString() throws RegainException {
        if (this.mContentAsString == null) {
            this.mContentAsString = new String(this.getContent());
        }
        return this.mContentAsString;
    }

    public InputStream getContentAsStream() throws RegainException {
        if (this.mContent != null) {
            return new ByteArrayInputStream(this.mContent);
        }
        if (this.mUrl.startsWith("file://")) {
            try {
                return new FileInputStream(this.mContentAsFile);
            }
            catch (Throwable thr) {
                throw new RegainException("Creating stream for file failed: " + this.mContentAsFile, thr);
            }
        }
        if (this.mUrl.startsWith("smb://")) {
            try {
                SmbFile smbFile = RegainToolkit.urlToSmbFile(CrawlerToolkit.replaceAuthenticationValuesInURL(this.mUrl, this.mAccountPasswordEntry));
                return smbFile.getInputStream();
            }
            catch (Throwable thr) {
                throw new RegainException("Creating stream for file failed: " + this.mContentAsFile, thr);
            }
        }
        throw new RegainException("Creating stream for unknown file protocoll failed.");
    }

    public void writeToFile(File file) throws RegainException {
        try {
            RegainToolkit.writeToFile(this.getContent(), file);
            if (this.mContentAsFile == null) {
                this.mContentAsFile = file;
            }
        }
        catch (RegainException exc) {
            throw new RegainException("Creating file that contains the document from '" + this.mUrl + "' failed", exc);
        }
    }

    public File getContentAsFile() throws RegainException {
        return this.getContentAsFile(false);
    }

    public File getContentAsFile(boolean forceTempFile) throws RegainException {
        if (this.mContentAsFile == null || forceTempFile && !this.mContentAsFileIsTemporary) {
            File tmpFile;
            String extension = "";
            if (this.mUrl.toLowerCase().startsWith("http")) {
                String path;
                try {
                    URL url = new URL(this.mUrl);
                    path = url.getPath();
                    if (path.length() == 0 && (url.getProtocol().equalsIgnoreCase("http") || url.getProtocol().equalsIgnoreCase("https")) || path.endsWith("/")) {
                        path = "index.html";
                    }
                }
                catch (MalformedURLException ex) {
                    mLog.debug("Couldn't create URL", ex);
                    path = this.mUrl;
                }
                int lastDot = path.lastIndexOf(46);
                extension = lastDot == -1 || path.length() - lastDot >= 6 ? "" : path.substring(lastDot);
            } else if (this.mUrl.toLowerCase().startsWith("imap")) {
                extension = ".mht";
            }
            try {
                tmpFile = File.createTempFile("lucenesearch_", extension);
            }
            catch (IOException exc) {
                throw new RegainException("Getting temporary File failed", exc);
            }
            this.writeToFile(tmpFile);
            this.mContentAsFile = tmpFile;
            this.mContentAsFileIsTemporary = true;
        }
        return this.mContentAsFile;
    }

    public void dispose() {
        if (this.mContentAsFile != null && this.mContentAsFileIsTemporary) {
            if (mLog.isDebugEnabled()) {
                mLog.debug("Deleting temporary file: " + this.mContentAsFile.getAbsolutePath());
            }
            if (!this.mContentAsFile.delete()) {
                this.mContentAsFile.deleteOnExit();
                mLog.debug("Deleting temporary file failed: " + this.mContentAsFile.getAbsolutePath() + "File will be deleted on program exit.");
            }
        }
    }

    public String toString() {
        return this.getUrl();
    }

    public String getMimeType() {
        return this.mMimeType;
    }

    public void setMimeType(String mMimeType) {
        this.mMimeType = mMimeType;
    }

    public boolean hasLinks() {
        return !this.mLinks.isEmpty();
    }

    public void addLink(String url, String linkText) {
        this.mLinks.put(url, linkText);
    }

    public HashMap<String, String> getLinks() {
        return this.mLinks;
    }
}

