/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.document;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.sf.regain.RegainException;
import net.sf.regain.RegainToolkit;
import net.sf.regain.crawler.config.PreparatorConfig;
import net.sf.regain.crawler.config.PreparatorSettings;
import net.sf.regain.crawler.document.Pluggable;
import org.apache.log4j.Logger;

public abstract class PluggableFactory {
    protected static Logger mLog = Logger.getLogger(PluggableFactory.class);

    protected PluggableFactory() {
    }

    public List<Pluggable> createPluggables(PreparatorSettings[] preparatorSettingsArr) throws RegainException {
        File[] jarFileArr;
        HashMap<String, Pluggable> preparatorHash = new HashMap<String, Pluggable>();
        File preparatorDir = this.getPluggableDir();
        if (preparatorDir == null) {
            return null;
        }
        for (File jarFile : jarFileArr = preparatorDir.listFiles(new ExtensionFilter(".jar"))) {
            this.loadPreparatorJar(jarFile, preparatorHash, preparatorSettingsArr);
        }
        if (mLog.isDebugEnabled()) {
            mLog.debug("Found " + preparatorHash.size() + " Preparator(s) or Plugin(s) in Jar-Files:");
            for (String entry : preparatorHash.keySet()) {
                mLog.debug(entry);
            }
        }
        ArrayList<Pluggable> preparatorArr = new ArrayList<Pluggable>(preparatorHash.size());
        for (int i = 0; i < preparatorSettingsArr.length; ++i) {
            if (!preparatorSettingsArr[i].isEnabled()) continue;
            String prepClassName = preparatorSettingsArr[i].getPreparatorClassName();
            Pluggable prep = preparatorHash.remove(prepClassName);
            if (prep == null) {
                mLog.warn("Crawler configuration contains non-existing preparator or plugin: " + prepClassName);
                continue;
            }
            prep.init(preparatorSettingsArr[i].getPreparatorConfig());
            this.pluggableAfterInit(prep, preparatorSettingsArr[i]);
            preparatorArr.add(prep);
        }
        for (Pluggable prep : preparatorHash.values()) {
            prep.init(new PreparatorConfig());
            this.pluggableAfterInit(prep, null);
            preparatorArr.add(prep);
        }
        return preparatorArr;
    }

    protected abstract File getPluggableDir() throws RegainException;

    protected abstract void pluggableAfterInit(Pluggable var1, PreparatorSettings var2) throws RegainException;

    private void loadPreparatorJar(File file, HashMap<String, Pluggable> preparatorHash, PreparatorSettings[] preparatorSettingsArr) throws RegainException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            InputStream in = jarFile.getInputStream(jarFile.getEntry("META-INF/MANIFEST.MF"));
            Manifest manifest = new Manifest(in);
            in.close();
            Attributes attributes = manifest.getMainAttributes();
            String[] classNameArr = this.getClassNames(file, attributes);
            URLClassLoader loader = null;
            for (int i = 0; i < classNameArr.length; ++i) {
                String className = classNameArr[i];
                if (className.startsWith(".")) {
                    className = this.getDefaultPackage() + className;
                }
                if (this.isPreparatorEnabled(className, preparatorSettingsArr)) {
                    if (loader == null) {
                        loader = new URLClassLoader(new URL[]{file.toURI().toURL()});
                    }
                    Pluggable prep = (Pluggable)RegainToolkit.createClassInstance(className, Pluggable.class, loader);
                    preparatorHash.put(className, prep);
                    continue;
                }
                mLog.info(className + " is disabled in configuration");
            }
        }
        catch (Throwable thr) {
            throw new RegainException("Loading preparator or plugin file '" + file + "' failed", thr);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException exc) {}
            }
        }
    }

    protected abstract String getDefaultPackage();

    protected abstract String[] getClassNames(File var1, Attributes var2) throws RegainException;

    private boolean isPreparatorEnabled(String className, PreparatorSettings[] preparatorSettingsArr) {
        for (int i = 0; i < preparatorSettingsArr.length; ++i) {
            if (!preparatorSettingsArr[i].getPreparatorClassName().equals(className)) continue;
            return preparatorSettingsArr[i].isEnabled();
        }
        return true;
    }

    static class ExtensionFilter
    implements FilenameFilter {
        private String ext;

        ExtensionFilter(String ext) {
            this.ext = ext;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(this.ext);
        }
    }
}

