/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPSSLStore;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import jcifs.smb.SmbFile;
import net.sf.regain.ImapToolkit;
import net.sf.regain.RegainException;
import net.sf.regain.RegainToolkit;
import net.sf.regain.crawler.CrawlerJob;
import net.sf.regain.crawler.CrawlerToolkit;
import net.sf.regain.crawler.ErrorLogger;
import net.sf.regain.crawler.HttpStreamException;
import net.sf.regain.crawler.IndexWriterManager;
import net.sf.regain.crawler.Profiler;
import net.sf.regain.crawler.RedirectException;
import net.sf.regain.crawler.UrlChecker;
import net.sf.regain.crawler.access.AccountPasswordEntry;
import net.sf.regain.crawler.config.CrawlerConfig;
import net.sf.regain.crawler.config.PreparatorSettings;
import net.sf.regain.crawler.config.StartUrl;
import net.sf.regain.crawler.config.UrlMatcher;
import net.sf.regain.crawler.config.UrlPattern;
import net.sf.regain.crawler.config.WhiteListEntry;
import net.sf.regain.crawler.document.RawDocument;
import net.sf.regain.crawler.plugin.CrawlerPluginFactory;
import net.sf.regain.crawler.plugin.CrawlerPluginManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class Crawler
implements ErrorLogger {
    private static Logger mLog = Logger.getLogger(Crawler.class);
    private CrawlerConfig mConfiguration;
    private UrlChecker mUrlChecker;
    private LinkedList<CrawlerJob> mJobList;
    private int mErrorCount;
    private int mFatalErrorCount;
    private CrawlerJob mCurrentJob;
    private List<Object[]> mDeadlinkList;
    private UrlPattern[] mHtmlParserUrlPatternArr;
    private RE[] mHtmlParserPatternReArr;
    private Profiler mCrawlerJobProfiler;
    private Profiler mHtmlParsingProfiler;
    private IndexWriterManager mIndexWriterManager;
    private boolean mShouldPause;
    Map<String, AccountPasswordEntry> accountPasswordStore;
    private CrawlerPluginManager pluginManager = CrawlerPluginManager.getInstance();

    public Crawler(CrawlerConfig config, Properties authProps) throws RegainException {
        Profiler.clearRegisteredProfilers();
        this.mCrawlerJobProfiler = new Profiler("Whole crawler jobs", "jobs");
        this.mHtmlParsingProfiler = new Profiler("Parsed documents", "docs");
        this.mConfiguration = config;
        this.mJobList = new LinkedList();
        this.mDeadlinkList = new LinkedList<Object[]>();
        this.mFatalErrorCount = 0;
        RawDocument.setHttpTimeoutSecs(config.getHttpTimeoutSecs());
        this.mHtmlParserUrlPatternArr = config.getHtmlParserUrlPatterns();
        if (this.mHtmlParserUrlPatternArr.length > 0) {
            mLog.error("Entries in <htmlParserPatternList/> are no longer supported. Please remove the Tag and it's children from your config file. Use <whitelist><prefix|regex parse=true|false index=true|false >http://someULR</prefix|regex> instead.");
            this.mHtmlParserPatternReArr = new RE[this.mHtmlParserUrlPatternArr.length];
            for (int i = 0; i < this.mHtmlParserPatternReArr.length; ++i) {
                String regex = this.mHtmlParserUrlPatternArr[i].getRegexPattern();
                try {
                    this.mHtmlParserPatternReArr[i] = new RE(regex);
                    continue;
                }
                catch (RESyntaxException exc) {
                    throw new RegainException("Regular exception of HTML parser pattern #" + (i + 1) + " has a wrong syntax: '" + regex + "'", exc);
                }
            }
        }
        this.accountPasswordStore = new HashMap<String, AccountPasswordEntry>();
        this.readAuthenticationProperties(authProps);
        mLog.debug(System.getenv().toString());
        PreparatorSettings[] crawlerPluginConf = config.getCrawlerPluginSettingsList();
        this.pluginManager.clear();
        CrawlerPluginFactory.getInstance().createPluggables(crawlerPluginConf);
    }

    public int getFinishedJobCount() {
        return this.mCrawlerJobProfiler.getMeasureCount();
    }

    public int getInitialDocCount() {
        IndexWriterManager mng = this.mIndexWriterManager;
        return mng == null ? -1 : mng.getInitialDocCount();
    }

    public int getAddedDocCount() {
        IndexWriterManager mng = this.mIndexWriterManager;
        return mng == null ? -1 : mng.getAddedDocCount();
    }

    public int getRemovedDocCount() {
        IndexWriterManager mng = this.mIndexWriterManager;
        return mng == null ? -1 : mng.getRemovedDocCount();
    }

    public String getCurrentJobUrl() {
        CrawlerJob job = this.mCurrentJob;
        if (job == null) {
            return null;
        }
        return job.getUrl();
    }

    public long getCurrentJobTime() {
        return this.mCrawlerJobProfiler.getCurrentMeasuringTime();
    }

    public void setShouldPause(boolean shouldPause) {
        this.mShouldPause = shouldPause;
    }

    public boolean getShouldPause() {
        return this.mShouldPause;
    }

    private void addJob(String url, String sourceUrl, boolean shouldBeParsed, boolean shouldBeIndexed, String sourceLinkText) {
        mLog.debug("Try to add " + url + " referer " + sourceUrl + " as a new crawler job.");
        if (!this.mConfiguration.getBuildIndex()) {
            shouldBeIndexed = false;
        }
        url = RegainToolkit.replace(url, " ", "%20");
        url = RegainToolkit.replace(url, "&amp;", "&");
        url = CrawlerToolkit.cleanURL(url, this.mConfiguration.getURLCleaners());
        boolean alreadyAccepted = this.mUrlChecker.wasAlreadyAccepted(url);
        boolean alreadyIgnored = this.mUrlChecker.wasAlreadyIgnored(url);
        if (!alreadyAccepted && !alreadyIgnored) {
            UrlMatcher urlMatch = this.mUrlChecker.isUrlAccepted(url);
            boolean accepted = urlMatch.getShouldBeParsed() || urlMatch.getShouldBeIndexed() ? !this.pluginManager.eventAskDynamicBlacklist(url, sourceUrl, sourceLinkText) : false;
            int mMaxCycleCount = this.mConfiguration.getMaxCycleCount();
            if (mMaxCycleCount > 0 && accepted) {
                accepted = this.mUrlChecker.hasNoCycles(url, mMaxCycleCount);
                if (mLog.isDebugEnabled() && !accepted) {
                    mLog.debug("URI seems to have cycles (maxCount=" + mMaxCycleCount + "): " + url);
                }
            }
            if (!(this.mConfiguration.getLoadUnparsedUrls() || shouldBeParsed || shouldBeIndexed)) {
                accepted = false;
            }
            if (accepted) {
                this.mUrlChecker.setAccepted(url);
                if (mLog.isDebugEnabled()) {
                    mLog.debug("Found new URL: " + url + " in page: " + sourceUrl);
                }
                CrawlerJob job = new CrawlerJob(url, sourceUrl, sourceLinkText, shouldBeParsed, shouldBeIndexed);
                this.pluginManager.eventAcceptURL(url, job);
                if (shouldBeParsed) {
                    this.mJobList.addLast(job);
                } else {
                    this.mJobList.addFirst(job);
                }
            } else {
                this.pluginManager.eventDeclineURL(url);
                this.mUrlChecker.setIgnored(url);
                if (mLog.isDebugEnabled()) {
                    mLog.debug("Ignoring URL: " + url + " in page: " + sourceUrl);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean updateIndex, boolean retryFailedDocs, String[] onlyEntriesArr) {
        double failedPercent;
        int entryCount;
        block57: {
            mLog.info("Starting crawling ...");
            this.pluginManager.eventStartCrawling(this);
            this.mShouldPause = false;
            entryCount = 0;
            failedPercent = 0.0;
            try {
                boolean thereWereFatalErrors;
                CrawlerToolkit.initHttpClient(this.mConfiguration);
                this.mIndexWriterManager = null;
                if (this.mConfiguration.getBuildIndex()) {
                    mLog.info("Preparing the index");
                    try {
                        this.mIndexWriterManager = new IndexWriterManager(this.mConfiguration, updateIndex, retryFailedDocs);
                        updateIndex = this.mIndexWriterManager.getUpdateIndex();
                    }
                    catch (RegainException exc) {
                        this.logError("Preparing the index failed!", exc, true);
                        this.pluginManager.eventFinishCrawling(this);
                        mLog.info("... Finished crawling\n");
                        return;
                    }
                }
                mLog.debug("Read whitelist entries from config");
                WhiteListEntry[] whiteList = this.mConfiguration.getWhiteList();
                whiteList = this.useOnlyWhiteListEntries(whiteList, onlyEntriesArr, updateIndex);
                this.mUrlChecker = new UrlChecker(whiteList, this.mConfiguration.getBlackList());
                mLog.info("Read start-URLs from config");
                this.addStartUrls();
                long lastBreakpointTime = System.currentTimeMillis();
                while (!this.mJobList.isEmpty()) {
                    boolean breakpointIntervalIsOver;
                    RawDocument rawDocument;
                    boolean shouldBeIndexed;
                    boolean shouldBeParsed;
                    String url;
                    block56: {
                        this.mCrawlerJobProfiler.startMeasuring();
                        this.mCurrentJob = this.mJobList.removeFirst();
                        url = this.mCurrentJob.getUrl();
                        shouldBeParsed = this.mCurrentJob.shouldBeParsed();
                        shouldBeIndexed = this.mCurrentJob.shouldBeIndexed();
                        if (url.startsWith("file://")) {
                            try {
                                File file = RegainToolkit.urlToFile(url);
                                if (!file.canRead()) {
                                    this.mCrawlerJobProfiler.abortMeasuring();
                                    mLog.debug("File rights: canRead: " + file.canRead() + " canExecute: " + file.canExecute() + " canWrite: " + file.canWrite() + " exists: " + file.exists() + " for url: " + url + ", canonical url: " + file.getCanonicalPath());
                                    this.logError("File is not readable: '" + url + "'", null, false);
                                    continue;
                                }
                                if (file.isDirectory()) {
                                    if (shouldBeParsed) {
                                        this.parseDirectory(file);
                                    }
                                    this.mCrawlerJobProfiler.stopMeasuring(0L);
                                }
                                break block56;
                            }
                            catch (Throwable thr) {
                                this.mCrawlerJobProfiler.abortMeasuring();
                                this.logError("Invalid URL: '" + url + "'", thr, false);
                            }
                            continue;
                        }
                        if (url.startsWith("smb://")) {
                            try {
                                SmbFile smbFile = RegainToolkit.urlToSmbFile(CrawlerToolkit.replaceAuthenticationValuesInURL(url, CrawlerToolkit.findAuthenticationValuesForURL(url, this.accountPasswordStore)));
                                if (!smbFile.canRead()) {
                                    this.mCrawlerJobProfiler.abortMeasuring();
                                    this.logError("File is not readable: '" + url + "'", null, false);
                                    continue;
                                }
                                if (smbFile.isDirectory()) {
                                    if (shouldBeParsed) {
                                        this.parseSmbDirectory(smbFile);
                                    }
                                    this.mCrawlerJobProfiler.stopMeasuring(0L);
                                }
                                break block56;
                            }
                            catch (Throwable thr) {
                                this.mCrawlerJobProfiler.abortMeasuring();
                                this.logError("Invalid URL: '" + url + "'", thr, false);
                            }
                            continue;
                        }
                        if (url.startsWith("imap://") || url.startsWith("imaps://")) {
                            try {
                                if (ImapToolkit.isMessageURL(url)) {
                                    if (this.mIndexWriterManager.isAlreadyIndexed(url)) {
                                        this.mCrawlerJobProfiler.stopMeasuring(0L);
                                        continue;
                                    }
                                    break block56;
                                }
                                if (shouldBeParsed) {
                                    this.parseIMAPFolder(url);
                                }
                                this.mCrawlerJobProfiler.stopMeasuring(0L);
                            }
                            catch (Throwable thr) {
                                this.mCrawlerJobProfiler.abortMeasuring();
                                this.logError("Invalid URL: '" + url + "'", thr, false);
                            }
                            continue;
                        }
                    }
                    try {
                        rawDocument = new RawDocument(url, this.mCurrentJob.getSourceUrl(), this.mCurrentJob.getSourceLinkText(), CrawlerToolkit.findAuthenticationValuesForURL(url, this.accountPasswordStore));
                    }
                    catch (RedirectException exc) {
                        String redirectUrl = exc.getRedirectUrl();
                        mLog.info("Redirect '" + url + "' -> '" + redirectUrl + "'");
                        this.mUrlChecker.setIgnored(url);
                        this.addJob(redirectUrl, this.mCurrentJob.getSourceUrl(), shouldBeParsed, shouldBeIndexed, this.mCurrentJob.getSourceLinkText());
                        this.mCrawlerJobProfiler.stopMeasuring(0L);
                        continue;
                    }
                    catch (RegainException exc) {
                        this.handleDocumentLoadingException(exc, this.mCurrentJob);
                        this.mCrawlerJobProfiler.abortMeasuring();
                        continue;
                    }
                    if (shouldBeIndexed || shouldBeParsed) {
                        if (mLog.isDebugEnabled()) {
                            mLog.debug("Parsing and indexing " + rawDocument.getUrl());
                        }
                        this.mHtmlParsingProfiler.startMeasuring();
                        if (shouldBeIndexed) {
                            try {
                                this.mIndexWriterManager.addToIndex(rawDocument, this);
                            }
                            catch (RegainException exc) {
                                this.logError("Indexing failed for: " + rawDocument.getUrl(), exc, false);
                            }
                        }
                        if (shouldBeParsed) {
                            if (!shouldBeIndexed) {
                                this.mIndexWriterManager.getDocumentFactory().createDocument(rawDocument, this);
                            }
                            try {
                                this.createCrawlerJobs(rawDocument);
                            }
                            catch (RegainException exc) {
                                this.logError("CrawlerJob creation failed for: " + rawDocument.getUrl(), exc, false);
                            }
                        }
                        this.mHtmlParsingProfiler.stopMeasuring(rawDocument.getLength());
                    }
                    rawDocument.dispose();
                    this.mCrawlerJobProfiler.stopMeasuring(rawDocument.getLength());
                    this.mCurrentJob = null;
                    int breakpointInterval = this.mConfiguration.getBreakpointInterval();
                    boolean bl = breakpointIntervalIsOver = breakpointInterval > 0 && System.currentTimeMillis() > lastBreakpointTime + (long)(breakpointInterval * 60) * 1000L;
                    if (!this.mShouldPause && !breakpointIntervalIsOver) continue;
                    try {
                        this.mIndexWriterManager.createBreakpoint();
                    }
                    catch (RegainException exc) {
                        this.logError("Creating breakpoint failed", exc, false);
                    }
                    while (this.mShouldPause) {
                        try {
                            Thread.sleep(1000L);
                            mLog.info("The crawler sleeps for 1 second.");
                        }
                        catch (InterruptedException exc) {}
                    }
                    lastBreakpointTime = System.currentTimeMillis();
                }
                if (this.mConfiguration.getBuildIndex()) {
                    mLog.info("Removing index entries of documents that do not exist any more...");
                    try {
                        this.mIndexWriterManager.removeObsoleteEntries(this.mUrlChecker);
                    }
                    catch (Throwable thr) {
                        this.logError("Removing non-existing documents from index failed", thr, true);
                    }
                }
                try {
                    entryCount = this.mIndexWriterManager.getIndexEntryCount();
                    if ((entryCount -= this.mErrorCount) < 0) {
                        entryCount = 0;
                    }
                }
                catch (Throwable thr) {
                    this.logError("Counting index entries failed", thr, true);
                }
                if (entryCount == 0) {
                    this.logError("The index is empty.", null, true);
                    failedPercent = 1.0;
                } else {
                    double maxAbortedPercent;
                    double totalDocCount;
                    double failedDocCount = this.mDeadlinkList.size() + this.mErrorCount;
                    failedPercent = failedDocCount / (totalDocCount = failedDocCount + (double)entryCount);
                    if (failedPercent > (maxAbortedPercent = this.mConfiguration.getMaxFailedDocuments())) {
                        this.logError("There are more failed documents than allowed (Failed: " + RegainToolkit.toPercentString(failedPercent) + ", allowed: " + RegainToolkit.toPercentString(maxAbortedPercent) + ").", null, true);
                    }
                }
                this.writeDeadlinkAndErrorList();
                this.writeCrawledURLsList();
                if (this.mIndexWriterManager == null) break block57;
                boolean bl = thereWereFatalErrors = this.mFatalErrorCount > 0;
                if (thereWereFatalErrors) {
                    mLog.warn("There were " + this.mFatalErrorCount + " fatal errors. " + "The index will be finished but put into quarantine.");
                } else {
                    mLog.info("Finishing the index and providing it to the search mask");
                }
                try {
                    this.mIndexWriterManager.close(thereWereFatalErrors);
                }
                catch (RegainException exc) {
                    this.logError("Finishing index failed!", exc, true);
                }
                this.mIndexWriterManager = null;
            }
            finally {
                this.pluginManager.eventFinishCrawling(this);
                mLog.info("... Finished crawling\n");
            }
        }
        mLog.info(Profiler.getProfilerResults());
        String lineSeparator = RegainToolkit.getLineSeparator();
        mLog.info("Statistics:" + lineSeparator + "  Ignored URLs:       " + this.mUrlChecker.getIgnoredCount() + lineSeparator + "  Documents in index: " + entryCount + lineSeparator + "  Dead links:         " + this.mDeadlinkList.size() + lineSeparator + "  Errors:             " + this.mErrorCount + lineSeparator + "  Error ratio:        " + RegainToolkit.toPercentString(failedPercent));
    }

    private File createTempDir() {
        File listDir = this.mConfiguration.getBuildIndex() ? new File(this.mConfiguration.getIndexDir() + File.separator + "temp" + File.separator + "log") : new File("log");
        try {
            if (!listDir.exists() && !listDir.mkdir()) {
                throw new IOException("Creating directory failed: " + listDir.getAbsolutePath());
            }
        }
        catch (IOException exc) {
            this.logError("Writing deadlink list and error list failed", exc, false);
        }
        return listDir;
    }

    private void handleDocumentLoadingException(RegainException exc, CrawlerJob job) {
        if (this.isExceptionFromDeadLink(exc)) {
            mLog.error("Dead link: '" + job.getUrl() + "'. Found in '" + job.getSourceUrl() + "'", exc);
            this.mDeadlinkList.add(new Object[]{job.getUrl(), job.getSourceUrl()});
        } else {
            this.logError("Loading " + job.getUrl() + " failed!", exc, false);
        }
    }

    private void addStartUrls() {
        StartUrl[] startUrlArr = this.mConfiguration.getStartUrls();
        startUrlArr = this.mUrlChecker.normalizeStartUrls(startUrlArr);
        mLog.info("Found " + startUrlArr.length + " startURLs.");
        for (int i = 0; i < startUrlArr.length; ++i) {
            String url = startUrlArr[i].getUrl();
            boolean shouldBeParsed = startUrlArr[i].getShouldBeParsed();
            boolean shouldBeIndexed = startUrlArr[i].getShouldBeIndexed();
            this.addJob(url, "Start URL from configuration", shouldBeParsed, shouldBeIndexed, null);
        }
    }

    private void readAuthenticationProperties(Properties authProps) {
        try {
            mLog.info("Read authentication entries from authentication properties.");
            Set<String> keys = authProps.stringPropertyNames();
            for (String key : keys) {
                String[] parts = key.split("\\.");
                String url = CrawlerToolkit.createURLFromProps(parts);
                AccountPasswordEntry acPassEntry = this.accountPasswordStore.containsKey(url) ? this.accountPasswordStore.get(url) : new AccountPasswordEntry();
                if (key.indexOf(".account") != -1) {
                    acPassEntry.setAccountName(URLEncoder.encode(authProps.getProperty(key), "UTF-8"));
                    mLog.debug("Found account name: " + acPassEntry.getAccountName() + " for auth entry: " + url);
                } else if (key.indexOf(".password") != -1) {
                    Base64 decoder = new Base64();
                    acPassEntry.setPassword(new String(decoder.decode(authProps.getProperty(key))));
                    mLog.debug("Found password for auth entry: " + url);
                }
                mLog.debug("write entry for url >" + url + "<" + " with username/password into authentication store.");
                this.accountPasswordStore.put(url, acPassEntry);
            }
        }
        catch (Exception e) {
            mLog.error("Error handling authentication.properties. ", e);
        }
    }

    private WhiteListEntry[] useOnlyWhiteListEntries(WhiteListEntry[] whiteList, String[] onlyEntriesArr, boolean updateIndex) {
        if (onlyEntriesArr != null && onlyEntriesArr.length != 0) {
            if (updateIndex) {
                int i;
                for (i = 0; i < whiteList.length; ++i) {
                    whiteList[i].setShouldBeUpdated(false);
                }
                for (i = 0; i < onlyEntriesArr.length; ++i) {
                    WhiteListEntry entry = null;
                    for (int j = 0; j < whiteList.length; ++j) {
                        if (!onlyEntriesArr[i].equals(whiteList[j].getName())) continue;
                        entry = whiteList[j];
                        break;
                    }
                    if (entry == null) {
                        this.logError("There is no white list entry named '" + onlyEntriesArr[i] + "'", null, true);
                        continue;
                    }
                    entry.setShouldBeUpdated(true);
                }
                for (i = 0; i < whiteList.length; ++i) {
                    if (whiteList[i].shouldBeUpdated()) continue;
                    mLog.info("Ignoring white list entry: " + whiteList[i].getUrlMatcher());
                }
            } else {
                mLog.warn("Unable to ignore white list entries, because a new index will be created");
            }
        }
        return whiteList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCrawledURLsList() {
        if (this.mUrlChecker.getmAcceptedUrlSet() != null) {
            File listDir = this.createTempDir();
            FileOutputStream stream = null;
            PrintStream printer = null;
            HashSet<String> crawledURLs = this.mUrlChecker.getmAcceptedUrlSet();
            try {
                stream = new FileOutputStream(new File(listDir, "crawledURLs.txt"));
                printer = new PrintStream(stream);
                for (String url : crawledURLs) {
                    printer.println(url);
                }
                printer.close();
                stream.close();
            }
            catch (IOException exc) {
                this.logError("Writing crawled URLs failed", exc, false);
            }
            finally {
                if (printer != null) {
                    printer.close();
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException exc) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDeadlinkAndErrorList() {
        if (this.mDeadlinkList.isEmpty() && this.mErrorCount == 0) {
            return;
        }
        File listDir = this.createTempDir();
        FileOutputStream stream = null;
        PrintStream printer = null;
        try {
            if (!this.mDeadlinkList.isEmpty()) {
                stream = new FileOutputStream(new File(listDir, "deadlinks.txt"));
                printer = new PrintStream(stream);
                String msg = "There were " + this.mDeadlinkList.size() + " dead links:";
                System.out.println(msg);
                printer.println(msg);
                Iterator<Object[]> iter = this.mDeadlinkList.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    Object[] tupel = iter.next();
                    String url = (String)tupel[0];
                    String sourceUrl = (String)tupel[1];
                    msg = "  Dead link #" + (i + 1) + ": '" + url + "' found in '" + sourceUrl + "'";
                    System.out.println(msg);
                    printer.println(msg);
                    ++i;
                }
                printer.close();
                stream.close();
            }
            if (this.mErrorCount > 0) {
                mLog.warn("There were " + this.mErrorCount + " errors");
            }
        }
        catch (IOException exc) {
            this.logError("Writing deadlink list and error list failed", exc, false);
        }
        finally {
            if (printer != null) {
                printer.close();
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException exc) {}
            }
        }
    }

    private boolean isExceptionFromDeadLink(Throwable thr) {
        if (thr instanceof HttpStreamException) {
            HttpStreamException exc = (HttpStreamException)thr;
            return exc.isHttpReturnCodeFromDeadLink();
        }
        if (thr instanceof RegainException) {
            RegainException exc = (RegainException)thr;
            return this.isExceptionFromDeadLink(exc.getCause());
        }
        return false;
    }

    private void parseDirectory(File dir) throws RegainException {
        String sourceUrl = RegainToolkit.fileToUrl(dir);
        File[] childArr = dir.listFiles();
        if (childArr == null) {
            if (!dir.canRead()) {
                throw new RegainException("canRead() on file returned: false. Maybe no access rights for sourceURL: " + sourceUrl);
            }
            throw new RegainException("listFiles() returned: null array. Maybe no access rights for sourceURL: " + sourceUrl);
        }
        for (int childIdx = 0; childIdx < childArr.length; ++childIdx) {
            String url = RegainToolkit.fileToUrl(childArr[childIdx]);
            if (childArr[childIdx].isDirectory()) {
                this.addJob(url, sourceUrl, true, false, null);
                continue;
            }
            this.addJob(url, sourceUrl, false, true, null);
        }
    }

    private void parseSmbDirectory(SmbFile dir) throws RegainException {
        try {
            String sourceUrl = dir.getCanonicalPath();
            SmbFile[] childArr = dir.listFiles();
            for (int childIdx = 0; childIdx < childArr.length; ++childIdx) {
                String url = childArr[childIdx].getCanonicalPath();
                if (url.contains("@")) {
                    url = "smb://" + url.substring(url.indexOf("@") + 1);
                }
                if (childArr[childIdx].isDirectory()) {
                    this.addJob(url, sourceUrl, true, false, null);
                    continue;
                }
                this.addJob(url, sourceUrl, false, true, null);
            }
        }
        catch (Exception ex) {
            throw new RegainException(ex.getMessage(), ex);
        }
    }

    private void parseIMAPFolder(String folderUrl) throws RegainException {
        mLog.debug("Determine IMAP subfolder for: " + folderUrl);
        Session session = Session.getInstance(new Properties());
        URLName originURLName = new URLName(CrawlerToolkit.replaceAuthenticationValuesInURL(folderUrl, CrawlerToolkit.findAuthenticationValuesForURL(folderUrl, this.accountPasswordStore)));
        String folder = "";
        if (originURLName.getFile() != null) {
            folder = originURLName.getFile().replaceAll("%20", " ");
        }
        URLName urlName = new URLName(originURLName.getProtocol(), originURLName.getHost(), originURLName.getPort(), folder, originURLName.getUsername(), originURLName.getPassword());
        try {
            IMAPSSLStore imapStore = new IMAPSSLStore(session, urlName);
            imapStore.connect();
            IMAPFolder startFolder = urlName.getFile() == null ? (IMAPFolder)imapStore.getDefaultFolder() : (IMAPFolder)imapStore.getFolder(urlName.getFile());
            if (startFolder.exists()) {
                try {
                    startFolder.open(1);
                    Message[] msgs = startFolder.getMessages();
                    for (int i = 0; i < msgs.length; ++i) {
                        MimeMessage message = (MimeMessage)msgs[i];
                        this.addJob(folderUrl + "/message_" + startFolder.getUID(message), folderUrl, false, true, null);
                    }
                    startFolder.close(false);
                }
                catch (MessagingException messageEx) {
                    mLog.debug("Could not open folder for reading but this is not an errror. Folder URL is " + folderUrl);
                }
            }
            Map<String, Integer> folderList = ImapToolkit.getAllFolders(startFolder, false);
            for (Map.Entry<String, Integer> entry : folderList.entrySet()) {
                String newFolder = folderUrl == null || folderUrl.length() == 0 || !folderUrl.endsWith("/") ? "/" + entry.getKey() : entry.getKey();
                this.addJob(folderUrl + newFolder, folderUrl, true, false, null);
            }
            imapStore.close();
        }
        catch (Exception ex) {
            throw new RegainException("Couldn't determine IMAP entries.", ex);
        }
    }

    private void createCrawlerJobs(RawDocument rawDocument) throws RegainException {
        if (rawDocument.hasLinks()) {
            for (Map.Entry<String, String> entry : rawDocument.getLinks().entrySet()) {
                UrlMatcher urlMatch = this.mUrlChecker.isUrlAccepted(entry.getKey());
                this.addJob(entry.getKey(), rawDocument.getUrl(), urlMatch.getShouldBeParsed(), urlMatch.getShouldBeIndexed(), entry.getValue());
            }
        }
    }

    public int getErrorCount() {
        return this.mErrorCount;
    }

    public int getFatalErrorCount() {
        return this.mFatalErrorCount;
    }

    @Override
    public void logError(String msg, Throwable thr, boolean fatal) {
        if (fatal) {
            msg = "Fatal: " + msg;
        }
        mLog.error(msg, thr);
        try {
            if (this.mIndexWriterManager != null) {
                this.mIndexWriterManager.logError(msg, thr);
            }
        }
        catch (RegainException exc) {
            mLog.error("Logging error in error log of index failed", exc);
        }
        ++this.mErrorCount;
        if (fatal) {
            ++this.mFatalErrorCount;
        }
    }
}

