/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.regain.RegainException;
import net.sf.regain.RegainToolkit;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlToolkit {
    public static Document loadXmlDocument(File xmlFile) throws RegainException {
        Document doc;
        DocumentBuilder builder;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new RegainException("Creating XML document builder failed!", exc);
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(xmlFile);
            doc = builder.parse(stream);
        }
        catch (Exception exc) {
            throw new RegainException("Parsing XML failed: " + xmlFile.getAbsolutePath(), exc);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exc) {}
            }
        }
        return doc;
    }

    public static void saveXmlDocument(File xmlFile, Document doc) throws RegainException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(xmlFile);
            String encoding = "UTF-8";
            PrintStream out = new PrintStream((OutputStream)stream, true, encoding);
            out.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
            out.println();
            out.println("<!DOCTYPE entities [");
            out.println("  <!ENTITY minus \"&#45;\">");
            out.println("  <!ENTITY lt \"&#60;\">");
            out.println("  <!ENTITY gt \"&#62;\">");
            out.println("]>");
            out.println();
            Element root = doc.getDocumentElement();
            XmlToolkit.printNode(out, "", root);
            out.close();
        }
        catch (Exception exc) {
            throw new RegainException("Saving XML file failed: " + xmlFile.getAbsolutePath(), exc);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exc) {}
            }
        }
    }

    private static void printNode(PrintStream out, String prefix, Node node) throws IOException {
        prefix = "";
        String name = node.getNodeName();
        boolean isText = name.equals("#text");
        boolean isComment = name.equals("#comment");
        boolean isCDATA = name.equals("#cdata-section");
        if (isText) {
            String text = node.getNodeValue();
            text = RegainToolkit.replace(text, "<", "&lt;");
            text = RegainToolkit.replace(text, ">", "&gt;");
            text = RegainToolkit.replace(text, "--", "&minus;&minus;");
            out.print(text);
        } else if (isComment) {
            String comment = node.getNodeValue();
            out.print("<!--" + comment + "-->");
        } else if (isCDATA) {
            String text = node.getNodeValue();
            out.print("<![CDATA[" + text + "]]>");
        } else {
            out.print(prefix + "<" + name);
            if (node.hasAttributes()) {
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attrib = attributes.item(i);
                    out.print(" " + attrib.getNodeName() + "=\"" + attrib.getNodeValue() + "\"");
                }
            }
            if (!node.hasChildNodes()) {
                out.print("/>");
            } else {
                out.print(">");
                NodeList childList = node.getChildNodes();
                String childPrefix = prefix + "  ";
                for (int i = 0; i < childList.getLength(); ++i) {
                    XmlToolkit.printNode(out, childPrefix, childList.item(i));
                }
                out.print(prefix + "</" + name + ">");
            }
        }
    }

    public static boolean getTextAsBoolean(Node node) throws RegainException {
        String asString = XmlToolkit.getText(node, true, true);
        if (asString.equalsIgnoreCase("true")) {
            return true;
        }
        if (asString.equalsIgnoreCase("false")) {
            return false;
        }
        throw new RegainException("Value of node '" + node.getNodeName() + "' must be either 'true' or 'false'!");
    }

    public static int getTextAsInt(Node node) throws RegainException {
        String asString = XmlToolkit.getText(node, true, true);
        try {
            return Integer.parseInt(asString);
        }
        catch (NumberFormatException exc) {
            throw new RegainException("Value of node '" + node.getNodeName() + "' must be an integer: '" + asString + "'", exc);
        }
    }

    public static double getTextAsDouble(Node node) throws RegainException {
        String asString = XmlToolkit.getText(node, true, true);
        try {
            return Double.parseDouble(asString);
        }
        catch (NumberFormatException exc) {
            throw new RegainException("Value of node '" + node.getNodeName() + "' must be a floating-point number (double): '" + asString + "'", exc);
        }
    }

    public static String[] getTextAsWordList(Node node, boolean mandatory) throws RegainException {
        String asString = XmlToolkit.getText(node, mandatory);
        if (asString == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(asString);
        String[] wordList = new String[tokenizer.countTokens()];
        for (int i = 0; i < wordList.length; ++i) {
            wordList[i] = tokenizer.nextToken();
        }
        return wordList;
    }

    public static String getTextOrCDataAsUrl(Node node) throws RegainException {
        String asString = XmlToolkit.getTextOrCData(node, true);
        if (asString.indexOf(92) != -1) {
            throw new RegainException("Text of node '" + node.getNodeName() + "' is not a valid URL. Use normal slashes instead of backslashes: '" + asString + "'");
        }
        return asString;
    }

    public static String getText(Node node) {
        Node textNode = XmlToolkit.getChild(node, "#text");
        if (textNode == null) {
            return null;
        }
        return textNode.getNodeValue();
    }

    public static String getCData(Node node, boolean mandatory) throws RegainException {
        return XmlToolkit.getCData(node, mandatory, false);
    }

    public static String getCData(Node node, boolean mandatory, boolean trimmed) throws RegainException {
        String text = XmlToolkit.getCData(node);
        if (trimmed && text != null) {
            text = text.trim();
        }
        if (mandatory && (text == null || text.length() == 0)) {
            throw new RegainException("Node '" + node.getNodeName() + "' has no CDATA element.");
        }
        return text;
    }

    public static String getCData(Node node) {
        Node cDataNode = XmlToolkit.getChild(node, "#cdata-section");
        if (cDataNode == null) {
            return null;
        }
        return cDataNode.getNodeValue();
    }

    public static String getTextOrCData(Node node, boolean mandatory) throws RegainException {
        String asString = XmlToolkit.getText(node, false);
        if (asString == null || asString.length() == 0) {
            asString = XmlToolkit.getCData(node, false);
        }
        if ((asString == null || asString.length() == 0) && mandatory) {
            throw new RegainException("Node '" + node.getNodeName() + "' contains no text/CDATA. This is a mandatory value.");
        }
        return asString;
    }

    public static String getText(Node node, boolean mandatory) throws RegainException {
        return XmlToolkit.getText(node, mandatory, false);
    }

    public static String getText(Node node, boolean mandatory, boolean trimmed) throws RegainException {
        String text = XmlToolkit.getText(node);
        if (trimmed && text != null) {
            text = text.trim();
        }
        if (mandatory && (text == null || text.length() == 0)) {
            throw new RegainException("Node '" + node.getNodeName() + "' has no text");
        }
        return text;
    }

    public static Node getChild(Node node, String childNodeName) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (!child.getNodeName().equals(childNodeName)) continue;
            return child;
        }
        return null;
    }

    public static Node getChild(Node node, String childNodeName, boolean mandatory) throws RegainException {
        Node childNode = XmlToolkit.getChild(node, childNodeName);
        if (mandatory && childNode == null) {
            throw new RegainException("Node '" + node.getNodeName() + "' must have a child named '" + childNodeName + "'!");
        }
        return childNode;
    }

    public static Node[] getChildArr(Node node, String childNodeName) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (!child.getNodeName().equals(childNodeName)) continue;
            list.add(child);
        }
        Node[] nodeArr = new Node[list.size()];
        list.toArray(nodeArr);
        return nodeArr;
    }

    public static Node getCascadedChild(Node node, Node defaultNode, String childNodeName) {
        Node child = XmlToolkit.getChild(node, childNodeName);
        if (child == null) {
            child = XmlToolkit.getChild(defaultNode, childNodeName);
        }
        return child;
    }

    public static Node getCascadedChild(Node node, Node defaultNode, String childNodeName, boolean mandatory) throws RegainException {
        Node child = XmlToolkit.getCascadedChild(node, defaultNode, childNodeName);
        if (mandatory && child == null) {
            throw new RegainException("Node '" + node.getNodeName() + "' or node '" + defaultNode.getNodeName() + "' must have a child named '" + childNodeName + "'!");
        }
        return child;
    }

    public static String getChildText(Node node, String childNodeName, boolean mandatory) throws RegainException {
        Node child = XmlToolkit.getChild(node, childNodeName, mandatory);
        if (child == null) {
            return null;
        }
        return XmlToolkit.getText(child, mandatory);
    }

    public static boolean getAttributeAsBoolean(Node node, String attributeName) throws RegainException {
        String asString = XmlToolkit.getAttribute(node, attributeName, true);
        if (asString.equalsIgnoreCase("true")) {
            return true;
        }
        if (asString.equalsIgnoreCase("false")) {
            return false;
        }
        throw new RegainException("Attribute '" + attributeName + "' of node '" + node.getNodeName() + "' must be either 'true' or 'false': '" + asString + "'");
    }

    public static boolean getAttributeAsBoolean(Node node, String attributeName, boolean defaultValue) throws RegainException {
        String asString = XmlToolkit.getAttribute(node, attributeName);
        if (asString == null) {
            return defaultValue;
        }
        if (asString.equalsIgnoreCase("true")) {
            return true;
        }
        if (asString.equalsIgnoreCase("false")) {
            return false;
        }
        throw new RegainException("Attribute '" + attributeName + "' of node '" + node.getNodeName() + "' must be either 'true' or 'false': '" + asString + "'");
    }

    public static int getAttributeAsInt(Node node, String attributeName) throws RegainException {
        String asString = XmlToolkit.getAttribute(node, attributeName, true);
        try {
            return Integer.parseInt(asString);
        }
        catch (NumberFormatException exc) {
            throw new RegainException("Attribute '" + attributeName + "' of node '" + node.getNodeName() + "' must be a number: '" + asString + "'");
        }
    }

    public static int getAttributeAsInt(Node node, String attributeName, int defaultValue) throws RegainException {
        String asString = XmlToolkit.getAttribute(node, attributeName);
        if (asString == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(asString);
        }
        catch (NumberFormatException exc) {
            throw new RegainException("Attribute '" + attributeName + "' of node '" + node.getNodeName() + "' must be a number: '" + asString + "'");
        }
    }

    public static String getAttribute(Node node, String attributeName) {
        Node attributeNode = node.getAttributes().getNamedItem(attributeName);
        if (attributeNode == null) {
            return null;
        }
        return attributeNode.getNodeValue();
    }

    public static String getAttribute(Node node, String attributeName, boolean mandatory) throws RegainException {
        String value = XmlToolkit.getAttribute(node, attributeName);
        if (value == null) {
            if (mandatory) {
                throw new RegainException("Node '" + node.getNodeName() + "' has no attribute '" + attributeName + "'");
            }
            return null;
        }
        return value;
    }

    public static void setText(Document doc, Node node, String text) {
        Node textNode = XmlToolkit.getChild(node, "#text");
        if (textNode == null) {
            textNode = doc.createTextNode(text);
            node.appendChild(textNode);
        } else {
            textNode.setNodeValue(text);
        }
    }

    public static void setCData(Document doc, Node node, String text) {
        Node cDataNode = XmlToolkit.getChild(node, "#cdata-section");
        if (cDataNode == null) {
            CDATASection cDataSection = doc.createCDATASection(text);
            node.appendChild(cDataSection);
        } else {
            cDataNode.setNodeValue(text);
        }
    }

    public static void removeAllChildren(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            node.removeChild(nodeList.item(i));
        }
    }

    public static void removeAllChildren(Node node, String childNodeName) {
        Node[] childArr = XmlToolkit.getChildArr(node, childNodeName);
        for (int i = 0; i < childArr.length; ++i) {
            node.removeChild(childArr[i]);
        }
    }

    public static Node addChild(Document doc, Node node, String childNodeName) {
        Element childNode = doc.createElement(childNodeName);
        node.appendChild(childNode);
        return childNode;
    }

    public static Node getOrAddChild(Document doc, Node node, String childNodeName) {
        Node child = XmlToolkit.getChild(node, childNodeName);
        if (child == null) {
            child = XmlToolkit.addChild(doc, node, childNodeName);
        }
        return child;
    }

    public static Node addChildWithText(Document doc, Node node, String childNodeName, String text) {
        Node childNode = XmlToolkit.addChild(doc, node, childNodeName);
        XmlToolkit.setText(doc, childNode, text);
        return childNode;
    }

    public static Node addChildWithCData(Document doc, Node node, String childNodeName, String text) {
        Node childNode = XmlToolkit.addChild(doc, node, childNodeName);
        XmlToolkit.setCData(doc, childNode, text);
        return childNode;
    }

    public static void setAttribute(Document doc, Node node, String attribName, String attribValue) {
        Attr attr = doc.createAttribute(attribName);
        attr.setNodeValue(attribValue);
        node.getAttributes().setNamedItem(attr);
    }

    public static void prettyPrint(Document doc, Node node) {
        Node parent = node.getParentNode();
        String indenting = "";
        NodeList siblingList = parent.getChildNodes();
        for (int i = 1; i < siblingList.getLength(); ++i) {
            String text;
            int newlinePos;
            Node sibling = siblingList.item(i);
            if (sibling != node) continue;
            Node nodeBefore = siblingList.item(i - 1);
            if (!nodeBefore.getNodeName().equals("#text") || (newlinePos = (text = nodeBefore.getNodeValue()).lastIndexOf(10)) == -1 || (indenting = text.substring(newlinePos)).trim().length() == 0) break;
            indenting = "";
            break;
        }
        XmlToolkit.prettyPrint(doc, node, indenting);
    }

    private static void prettyPrint(Document doc, Node node, String prefix) {
        String childPrefix = prefix + "  ";
        NodeList childList = node.getChildNodes();
        boolean hasChildren = false;
        for (int i = childList.getLength() - 1; i >= 0; --i) {
            boolean isNormalNode;
            Node child = childList.item(i);
            boolean bl = isNormalNode = !child.getNodeName().startsWith("#");
            if (!isNormalNode) continue;
            Text textNode = doc.createTextNode(childPrefix);
            node.insertBefore(textNode, child);
            XmlToolkit.prettyPrint(doc, child, childPrefix);
            hasChildren = true;
        }
        if (hasChildren) {
            Text textNode = doc.createTextNode(prefix);
            node.appendChild(textNode);
        }
    }
}

