/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import jcifs.smb.SmbFile;
import net.sf.regain.RegainException;
import net.sf.regain.util.io.PathFilenamePair;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.util.Version;

public class RegainToolkit {
    public static final String INDEX_ENCODING = "UTF-8";
    public static final String FIELD_ACCESS_CONTROL_GROUPS = "groups";
    private static final boolean ANALYSE_ANALYZER = false;
    private static final int SIZE_KB = 1024;
    private static final int SIZE_MB = 0x100000;
    private static final int SIZE_GB = 0x40000000;
    private static String mSystemDefaultEncoding;
    private static String mLineSeparator;
    private static final Version LUCENE_VERSION;
    private static List<File> jarFolders;

    public static Version getLuceneVersion() {
        return LUCENE_VERSION;
    }

    public static void deleteDirectory(File dir) throws RegainException {
        if (!dir.exists()) {
            return;
        }
        File[] children = dir.listFiles();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (children[i].isDirectory()) {
                    RegainToolkit.deleteDirectory(children[i]);
                    continue;
                }
                if (children[i].delete()) continue;
                throw new RegainException("Deleting " + children[i].getAbsolutePath() + " failed!");
            }
        }
        if (!dir.delete()) {
            throw new RegainException("Deleting " + dir.getAbsolutePath() + " failed!");
        }
    }

    public static void pipe(Reader reader, Writer writer) throws IOException {
        int len;
        char[] buffer = new char[10240];
        while ((len = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, len);
        }
    }

    public static void pipe(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[10240];
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
    }

    public static void copyFile(File from, File to) throws RegainException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(from);
            out = new FileOutputStream(to);
            RegainToolkit.pipe(in, out);
        }
        catch (IOException exc) {
            throw new RegainException("Copying file from " + from.getAbsolutePath() + " to " + to.getAbsolutePath() + " failed", exc);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException exc) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException exc) {}
            }
        }
    }

    public static void copyDirectory(File fromDir, File toDir, boolean copySubDirs, String excludeExtension) throws RegainException {
        File[] indexFiles = fromDir.listFiles();
        for (int i = 0; i < indexFiles.length; ++i) {
            String fileName = indexFiles[i].getName();
            File targetFile = new File(toDir, fileName);
            if (indexFiles[i].isDirectory()) {
                if (!copySubDirs) continue;
                if (!targetFile.mkdir() && !targetFile.exists()) {
                    throw new RegainException("Could not create target dir " + targetFile.getAbsolutePath());
                }
                RegainToolkit.copyDirectory(indexFiles[i], targetFile, copySubDirs, excludeExtension);
                continue;
            }
            if (excludeExtension != null && fileName.endsWith(excludeExtension)) continue;
            RegainToolkit.copyFile(indexFiles[i], targetFile);
        }
    }

    public static void copyDirectory(File fromDir, File toDir, boolean copySubDirs) throws RegainException {
        RegainToolkit.copyDirectory(fromDir, toDir, copySubDirs, null);
    }

    public static String readStringFromStream(InputStream stream, String charsetName) throws RegainException {
        InputStreamReader reader = null;
        try {
            reader = charsetName == null ? new InputStreamReader(stream) : new InputStreamReader(stream, charsetName);
            StringWriter writer = new StringWriter();
            RegainToolkit.pipe(reader, writer);
            reader.close();
            writer.close();
            String string = writer.toString();
            return string;
        }
        catch (IOException exc) {
            throw new RegainException("Reading String from stream failed", exc);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException exc) {}
            }
        }
    }

    public static String readStringFromStream(InputStream stream) throws RegainException {
        return RegainToolkit.readStringFromStream(stream, null);
    }

    public static String readStringFromFile(File file) throws RegainException {
        if (!file.exists()) {
            return null;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            String string = RegainToolkit.readStringFromStream(stream);
            return string;
        }
        catch (IOException exc) {
            throw new RegainException("Reading String from " + file.getAbsolutePath() + "failed", exc);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException exc) {}
            }
        }
    }

    public static String[] readListFromFile(File file) throws RegainException {
        if (!file.exists()) {
            return null;
        }
        FileReader reader = null;
        BufferedReader buffReader = null;
        try {
            String line;
            reader = new FileReader(file);
            buffReader = new BufferedReader(reader);
            ArrayList<String> list = new ArrayList<String>();
            while ((line = buffReader.readLine()) != null) {
                list.add(line);
            }
            String[] asArr = new String[list.size()];
            list.toArray(asArr);
            String[] stringArray = asArr;
            return stringArray;
        }
        catch (IOException exc) {
            throw new RegainException("Reading word list from " + file.getAbsolutePath() + "failed", exc);
        }
        finally {
            if (buffReader != null) {
                try {
                    buffReader.close();
                }
                catch (IOException exc) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException exc) {}
            }
        }
    }

    public static void writeToFile(byte[] data, File file) throws RegainException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            stream.write(data);
            stream.close();
        }
        catch (IOException exc) {
            throw new RegainException("Writing file failed: " + file.getAbsolutePath(), exc);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException exc) {}
            }
        }
    }

    public static void writeToFile(String text, File file) throws RegainException {
        RegainToolkit.writeListToFile(new String[]{text}, file);
    }

    public static void writeListToFile(String[] wordList, File file) throws RegainException {
        if (wordList == null || wordList.length == 0) {
            return;
        }
        FileOutputStream stream = null;
        PrintStream printer = null;
        try {
            stream = new FileOutputStream(file);
            printer = new PrintStream(stream);
            for (int i = 0; i < wordList.length; ++i) {
                printer.println(wordList[i]);
            }
        }
        catch (IOException exc) {
            throw new RegainException("Writing word list to " + file.getAbsolutePath() + " failed", exc);
        }
        finally {
            if (printer != null) {
                printer.close();
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException exc) {}
            }
        }
    }

    public static long getDirectorySize(File dir) {
        File[] childArr = dir.listFiles();
        long size = 0L;
        if (childArr != null) {
            for (int i = 0; i < childArr.length; ++i) {
                if (childArr[i].isDirectory()) {
                    size += RegainToolkit.getDirectorySize(childArr[i]);
                    continue;
                }
                size += childArr[i].length();
            }
        }
        return size;
    }

    public static HashMap<String, String[]> readFieldValues(IndexReader indexReader, String[] fieldNameArr, File indexDir) throws RegainException {
        ArrayList valueList;
        String field;
        HashMap<String, String[]> resultMap = new HashMap<String, String[]>();
        HashMap fieldsToReadSet = new HashMap();
        for (int i = 0; i < fieldNameArr.length; ++i) {
            String field2 = fieldNameArr[i];
            String[] fieldValueArr = null;
            if (indexDir != null) {
                File fieldFile = new File(indexDir, "field_values_" + field2 + ".txt");
                fieldValueArr = RegainToolkit.readListFromFile(fieldFile);
            }
            if (fieldValueArr != null) {
                resultMap.put(field2, fieldValueArr);
                continue;
            }
            fieldsToReadSet.put(field2, new ArrayList());
        }
        fieldNameArr = null;
        if (!fieldsToReadSet.isEmpty()) {
            try {
                TermEnum termEnum = indexReader.terms();
                while (termEnum.next()) {
                    Term term = termEnum.term();
                    field = term.field();
                    valueList = (ArrayList)fieldsToReadSet.get(field);
                    if (valueList == null) continue;
                    valueList.add(term.text());
                }
            }
            catch (IOException exc) {
                throw new RegainException("Reading terms from index failed", exc);
            }
        }
        for (Map.Entry entry : fieldsToReadSet.entrySet()) {
            field = (String)entry.getKey();
            valueList = (ArrayList)entry.getValue();
            Object[] valueArr = new String[valueList.size()];
            valueList.toArray(valueArr);
            Arrays.sort(valueArr);
            resultMap.put(field, (String[])valueArr);
            if (indexDir == null) continue;
            File fieldFile = new File(indexDir, "field_values_" + field + ".txt");
            RegainToolkit.writeListToFile((String[])valueArr, fieldFile);
        }
        return resultMap;
    }

    public static Analyzer createAnalyzer(String analyzerType, String[] stopWordList, String[] exclusionList, String[] untokenizedFieldNames) throws RegainException {
        Analyzer analyzer;
        Class<?> analyzerClass;
        if (analyzerType == null) {
            throw new RegainException("No analyzer type specified!");
        }
        String analyzerClassName = analyzerType = analyzerType.trim();
        if (analyzerType.equalsIgnoreCase("english")) {
            analyzerClassName = EnglishAnalyzer.class.getName();
        } else if (analyzerType.equalsIgnoreCase("german") || analyzerType.equalsIgnoreCase("deutsch")) {
            analyzerClassName = GermanAnalyzer.class.getName();
        } else if (analyzerType.equalsIgnoreCase("french") || analyzerType.equalsIgnoreCase("francais")) {
            analyzerClassName = FrenchAnalyzer.class.getName();
        } else if (analyzerType.equalsIgnoreCase("italian") || analyzerType.equalsIgnoreCase("italiano")) {
            analyzerClassName = ItalianAnalyzer.class.getName();
        }
        try {
            analyzerClass = Class.forName(analyzerClassName);
        }
        catch (ClassNotFoundException exc) {
            throw new RegainException("Analyzer class not found: " + analyzerClassName, exc);
        }
        HashSet<String> stopWordSet = new HashSet<String>();
        stopWordSet.addAll(Arrays.asList(stopWordList));
        if (stopWordList != null && stopWordList.length != 0) {
            Constructor<?> ctor;
            try {
                ctor = analyzerClass.getConstructor(Version.class, Set.class);
            }
            catch (Throwable thr) {
                throw new RegainException("Analyzer " + analyzerType + " does not support stop words", thr);
            }
            try {
                analyzer = (Analyzer)ctor.newInstance(new Object[]{RegainToolkit.getLuceneVersion(), stopWordSet});
            }
            catch (Throwable thr) {
                throw new RegainException("Creating analyzer instance failed", thr);
            }
        }
        try {
            Constructor<?> analyzerWithoutStopWords;
            try {
                analyzerWithoutStopWords = analyzerClass.getConstructor(Version.class);
            }
            catch (Throwable thr) {
                throw new RegainException("Analyzer " + analyzerType + " is not supported.", thr);
            }
            analyzer = (Analyzer)analyzerWithoutStopWords.newInstance(new Object[]{RegainToolkit.getLuceneVersion()});
        }
        catch (Throwable thr) {
            throw new RegainException("Creating analyzer instance failed", thr);
        }
        if (exclusionList != null && exclusionList.length != 0) {
            Method setter;
            try {
                setter = analyzerClass.getMethod("setStemExclusionTable", exclusionList.getClass());
            }
            catch (Throwable thr) {
                throw new RegainException("Analyzer " + analyzerType + " does not support exclusion lists");
            }
            try {
                setter.invoke((Object)analyzer, new Object[]{exclusionList});
            }
            catch (Throwable thr) {
                throw new RegainException("Applying exclusion list failed.", thr);
            }
        }
        analyzer = new WrapperAnalyzer(analyzer, untokenizedFieldNames);
        return analyzer;
    }

    private static Analyzer createAnalysingAnalyzer(final Analyzer nestedAnalyzer) {
        return new Analyzer(){

            @Override
            public TokenStream tokenStream(String fieldName, Reader reader) {
                try {
                    StringWriter writer = new StringWriter();
                    RegainToolkit.pipe(reader, writer);
                    String asString = writer.toString();
                    TokenStream stream = nestedAnalyzer.tokenStream(fieldName, new StringReader(asString));
                    CharTermAttribute termAtt = stream.addAttribute(CharTermAttribute.class);
                    System.out.println("Tokens for '" + asString + "':");
                    while (stream.incrementToken()) {
                        System.out.println(" '" + termAtt.toString() + "'");
                    }
                    stream.reset();
                    return stream;
                }
                catch (IOException exc) {
                    System.out.println("exc: " + exc);
                    return null;
                }
            }
        };
    }

    public static String replace(String source, String pattern, String replacement) {
        int pos = source.indexOf(pattern);
        if (pos == -1) {
            return source;
        }
        StringBuilder target = new StringBuilder(source.length());
        int start = 0;
        do {
            target.append(source.substring(start, pos));
            target.append(replacement);
        } while ((pos = source.indexOf(pattern, start = pos + pattern.length())) != -1);
        target.append(source.substring(start, source.length()));
        return target.toString();
    }

    public static String replace(String source, String[] patternArr, String[] replacementArr) {
        if (patternArr.length != replacementArr.length) {
            throw new IllegalArgumentException("patternArr and replacementArr must have the same length: " + patternArr.length + " != " + replacementArr.length);
        }
        int[] posArr = new int[patternArr.length];
        int minPos = Integer.MAX_VALUE;
        int minPosIdx = -1;
        for (int i = 0; i < posArr.length; ++i) {
            posArr[i] = source.indexOf(patternArr[i]);
            if (posArr[i] == -1 || posArr[i] >= minPos) continue;
            minPos = posArr[i];
            minPosIdx = i;
        }
        if (minPosIdx == -1) {
            return source;
        }
        StringBuilder target = new StringBuilder(source.length());
        int start = 0;
        do {
            target.append(source.substring(start, minPos));
            target.append(replacementArr[minPosIdx]);
            start = minPos + patternArr[minPosIdx].length();
            minPos = Integer.MAX_VALUE;
            minPosIdx = -1;
            for (int i = 0; i < posArr.length; ++i) {
                if (posArr[i] < start) {
                    posArr[i] = source.indexOf(patternArr[i], start);
                }
                if (posArr[i] == -1 || posArr[i] >= minPos) continue;
                minPos = posArr[i];
                minPosIdx = i;
            }
        } while (minPosIdx != -1);
        target.append(source.substring(start, source.length()));
        return target.toString();
    }

    public static String toPercentString(double value) {
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setMinimumFractionDigits(2);
        format.setMaximumFractionDigits(2);
        return format.format(value);
    }

    public static String bytesToString(long bytes) {
        return RegainToolkit.bytesToString(bytes, Locale.ENGLISH);
    }

    public static String bytesToString(long bytes, Locale locale) {
        return RegainToolkit.bytesToString(bytes, 2, locale);
    }

    public static String bytesToString(long bytes, int fractionDigits) {
        return RegainToolkit.bytesToString(bytes, fractionDigits, Locale.ENGLISH);
    }

    public static String bytesToString(long bytes, int fractionDigits, Locale locale) {
        String unit;
        int factor;
        if (bytes > 0x40000000L) {
            factor = 0x40000000;
            unit = "GB";
        } else if (bytes > 0x100000L) {
            factor = 0x100000;
            unit = "MB";
        } else if (bytes > 1024L) {
            factor = 1024;
            unit = "kB";
        } else {
            return bytes + " Byte";
        }
        NumberFormat format = NumberFormat.getInstance(locale);
        format.setMinimumFractionDigits(fractionDigits);
        format.setMaximumFractionDigits(fractionDigits);
        String asString = format.format((double)bytes / (double)factor);
        return asString + " " + unit;
    }

    public static String toTimeString(long time) {
        if (time == -1L) {
            return "?";
        }
        long millis = time % 1000L;
        long secs = (time /= 1000L) % 60L;
        long mins = (time /= 60L) % 60L;
        long hours = time /= 60L;
        if (hours != 0L) {
            return hours + ":" + (mins > 9L ? "" : "0") + mins + ":" + (secs > 9L ? "" : "0") + secs + " h";
        }
        if (mins != 0L) {
            return mins + ":" + (secs > 9L ? "" : "0") + secs + " min";
        }
        if (secs != 0L) {
            NumberFormat format = NumberFormat.getInstance();
            format.setMinimumFractionDigits(2);
            format.setMaximumFractionDigits(2);
            String asString = format.format((double)secs + (double)millis / 1000.0);
            return asString + " sec";
        }
        return millis + " millis";
    }

    public static String lastModifiedToString(Date lastModified) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(lastModified);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        StringBuilder buffer = new StringBuilder(16);
        buffer.append(year);
        buffer.append('-');
        if (month < 10) {
            buffer.append('0');
        }
        buffer.append(month);
        buffer.append('-');
        if (day < 10) {
            buffer.append('0');
        }
        buffer.append(day);
        buffer.append(' ');
        if (hour < 10) {
            buffer.append('0');
        }
        buffer.append(hour);
        buffer.append(':');
        if (minute < 10) {
            buffer.append('0');
        }
        buffer.append(minute);
        return buffer.toString();
    }

    public static Date stringToLastModified(String asString) throws RegainException {
        Calendar cal = Calendar.getInstance();
        try {
            int year = Integer.parseInt(asString.substring(0, 4));
            cal.set(1, year);
            int month = Integer.parseInt(asString.substring(5, 7));
            cal.set(2, month - 1);
            int day = Integer.parseInt(asString.substring(8, 10));
            cal.set(5, day);
            int hour = Integer.parseInt(asString.substring(11, 13));
            cal.set(11, hour);
            int minute = Integer.parseInt(asString.substring(14, 16));
            cal.set(12, minute);
            cal.set(13, 0);
        }
        catch (Throwable thr) {
            throw new RegainException("Last-modified-string has not the format'YYYY-MM-DD HH:MM': " + asString, thr);
        }
        return cal.getTime();
    }

    public static String[] splitString(String str, String delim) {
        return RegainToolkit.splitString(str, delim, false);
    }

    public static String[] splitString(String str, String delim, boolean trimSplits) {
        StringTokenizer tokenizer = new StringTokenizer(str, delim);
        String[] searchFieldArr = new String[tokenizer.countTokens()];
        for (int i = 0; i < searchFieldArr.length; ++i) {
            searchFieldArr[i] = tokenizer.nextToken();
            if (!trimSplits) continue;
            searchFieldArr[i] = searchFieldArr[i].trim();
        }
        return searchFieldArr;
    }

    public static String getLineSeparator() {
        if (mLineSeparator == null) {
            mLineSeparator = System.getProperty("line.separator");
        }
        return mLineSeparator;
    }

    public static String getSystemDefaultEncoding() {
        if (mSystemDefaultEncoding == null) {
            mSystemDefaultEncoding = new InputStreamReader(System.in).getEncoding();
        }
        return mSystemDefaultEncoding;
    }

    public static boolean containsWhitespace(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static void checkGroupArray(Object accessController, String[] groupArr) throws RegainException {
        if (groupArr == null) {
            throw new RegainException("Access controller " + accessController.getClass().getName() + " returned illegal " + "group array: null");
        }
        for (int i = 0; i < groupArr.length; ++i) {
            if (!RegainToolkit.containsWhitespace(groupArr[i])) continue;
            throw new RegainException("Access controller " + accessController.getClass().getName() + " returned illegal " + "group name containing whitespace: '" + groupArr[i] + "'");
        }
    }

    public static Object createClassInstance(String className, Class<?> superClass, ClassLoader classLoader) throws RegainException {
        Object obj;
        Class<?> clazz;
        try {
            clazz = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
        }
        catch (ClassNotFoundException exc) {
            throw new RegainException("The class '" + className + "' does not exist", exc);
        }
        try {
            obj = clazz.newInstance();
        }
        catch (Exception exc) {
            throw new RegainException("Error creating instance of class " + className, exc);
        }
        if (!superClass.isInstance(obj)) {
            throw new RegainException("The class " + className + " does not " + "implement " + superClass.getName());
        }
        return obj;
    }

    public static void addLibraryJarPath(File file) {
        if (file != null && file.exists() && !jarFolders.contains(file)) {
            jarFolders.add(file);
        }
    }

    private static File searchJarFile(String jarFileName) {
        for (File folder : jarFolders) {
            File file = new File(folder, jarFileName);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public static Object createClassInstance(String className, Class<?> superClass, String jarFileName) throws RegainException {
        URLClassLoader classLoader = null;
        if (jarFileName != null) {
            File jarFile = new File(jarFileName);
            if (!jarFile.exists()) {
                File jarFileNew = RegainToolkit.searchJarFile(jarFileName);
                if (jarFileNew == null) {
                    throw new RegainException("Jar file does not exist: " + jarFile.getAbsolutePath() + " (Also looked for it in:" + jarFolders + ")");
                }
                jarFile = jarFileNew;
            }
            try {
                classLoader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, superClass.getClassLoader());
            }
            catch (MalformedURLException exc) {
                throw new RegainException("Creating class loader for jar file failed: " + jarFile.getAbsolutePath(), exc);
            }
        }
        return RegainToolkit.createClassInstance(className, superClass, classLoader);
    }

    public static String urlToFileName(String url) throws RegainException {
        if (!url.startsWith("file://")) {
            throw new RegainException("URL must have the file:// protocol to get a File for it");
        }
        String fileName = url.substring(7);
        return RegainToolkit.urlDecode(fileName, INDEX_ENCODING);
    }

    public static String urlToWhitespacedFileName(String url) throws RegainException {
        PathFilenamePair pfPair = RegainToolkit.fragmentUrl(url);
        String fileName = pfPair.getFilename();
        if (fileName != null) {
            String fileNameWhitespaced;
            int lastDot = fileName.lastIndexOf(".");
            String fileNameWithoutExtension = "";
            if (lastDot > 0 && lastDot < fileName.length()) {
                fileNameWithoutExtension = fileName.substring(0, lastDot);
            }
            if (fileNameWithoutExtension.equals(fileNameWhitespaced = fileNameWithoutExtension.replaceAll("\\.", " ").replaceAll("-", " ").replaceAll("_", " "))) {
                fileNameWhitespaced = "";
            }
            return RegainToolkit.urlDecode(fileName + " " + fileNameWithoutExtension + " " + fileNameWhitespaced, INDEX_ENCODING).trim();
        }
        return "";
    }

    public static PathFilenamePair fragmentUrl(String url) throws RegainException {
        PathFilenamePair pfPair = new PathFilenamePair();
        int lastSlash = 0;
        if (url != null) {
            lastSlash = url.lastIndexOf("/");
        }
        if (lastSlash > 0 && lastSlash + 1 < url.length()) {
            String fileName = url.substring(lastSlash + 1);
            String path = url.substring(0, lastSlash + 1);
            path = RegainToolkit.removeProtocol(path);
            pfPair.setFilename(fileName);
            pfPair.setPath(path);
        } else {
            pfPair.setPath("");
            if (url != null && url.length() > 0) {
                pfPair.setFilename(url);
            } else {
                pfPair.setFilename("");
            }
        }
        return pfPair;
    }

    public static String removeProtocol(String path) {
        String newPath = "";
        if (path != null) {
            newPath = path.replace("file://", "");
            newPath = newPath.replace("http://", "");
            newPath = newPath.replace("https://", "");
            newPath = newPath.replace("imap://", "");
            newPath = newPath.replace("imaps://", "");
            newPath = newPath.replace("smb://", "");
        }
        return newPath;
    }

    public static File urlToFile(String url) throws RegainException {
        return new File(RegainToolkit.urlToFileName(url));
    }

    public static SmbFile urlToSmbFile(String url) throws RegainException {
        try {
            return new SmbFile(RegainToolkit.urlToSmbFileName(url));
        }
        catch (MalformedURLException urlEx) {
            throw new RegainException(urlEx.getMessage(), urlEx);
        }
    }

    public static String urlToSmbFileName(String url) throws RegainException {
        if (!url.startsWith("smb://")) {
            throw new RegainException("URL must have the smb:// protocol to get a File for it");
        }
        return RegainToolkit.urlDecode(url, INDEX_ENCODING);
    }

    public static String fileNameToUrl(String fileName) throws RegainException {
        fileName = RegainToolkit.urlEncode(fileName, INDEX_ENCODING);
        fileName = RegainToolkit.replace(fileName, "%2F", "/");
        fileName = RegainToolkit.replace(fileName, "%5C", "/");
        fileName = RegainToolkit.replace(fileName, "\\", "/");
        return "file://" + fileName;
    }

    public static String fileToUrl(File file) throws RegainException {
        return RegainToolkit.fileNameToUrl(file.getAbsolutePath());
    }

    public static String fileToCanonicalUrl(File file) throws RegainException {
        String canUrl = null;
        try {
            canUrl = file.getCanonicalPath();
        }
        catch (Exception e) {
            return null;
        }
        int pos = canUrl.indexOf(58) + 1;
        if (pos > 0 && pos < canUrl.length()) {
            canUrl = canUrl.substring(pos);
        }
        return RegainToolkit.fileNameToUrl(canUrl);
    }

    public static String urlEncode(String text, String encoding) throws RegainException {
        try {
            return URLEncoder.encode(text, encoding);
        }
        catch (UnsupportedEncodingException exc) {
            throw new RegainException("URL-encoding failed: '" + text + "'", exc);
        }
    }

    public static String urlDecode(String text, String encoding) throws RegainException {
        try {
            return URLDecoder.decode(text, encoding);
        }
        catch (UnsupportedEncodingException exc) {
            throw new RegainException("URL-decoding failed: '" + text + "'", exc);
        }
    }

    public static String createSummaryFromContent(String content, int maxLength) {
        if (content.length() > maxLength) {
            int lastSpacePos = content.lastIndexOf(32, maxLength);
            if (lastSpacePos == -1) {
                return null;
            }
            return content.substring(0, lastSpacePos) + " ...";
        }
        return content;
    }

    public static String createHighlightedFieldIdent(String fieldName) {
        if (fieldName != null && fieldName.length() > 1) {
            return "highlighted" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1, fieldName.length());
        }
        return null;
    }

    static {
        LUCENE_VERSION = Version.LUCENE_36;
        jarFolders = new ArrayList<File>();
    }

    private static class LowercasingReader
    extends Reader {
        private Reader mNestedReader;

        public LowercasingReader(Reader nestedReader) {
            this.mNestedReader = nestedReader;
        }

        @Override
        public void close() throws IOException {
            this.mNestedReader.close();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int charCount = this.mNestedReader.read(cbuf, off, len);
            if (charCount != -1) {
                for (int i = off; i < off + charCount; ++i) {
                    cbuf[i] = Character.toLowerCase(cbuf[i]);
                }
            }
            return charCount;
        }
    }

    private static class WrapperAnalyzer
    extends Analyzer {
        private Analyzer mNoStemmingAnalyzer = new WhitespaceAnalyzer(RegainToolkit.getLuceneVersion());
        private Analyzer mNestedAnalyzer;
        private HashSet<String> mUntokenizedFieldNames;

        public WrapperAnalyzer(Analyzer nestedAnalyzer, String[] untokenizedFieldNames) {
            this.mNestedAnalyzer = nestedAnalyzer;
            this.mUntokenizedFieldNames = new HashSet();
            this.mUntokenizedFieldNames.addAll(Arrays.asList(untokenizedFieldNames));
        }

        @Override
        public TokenStream tokenStream(String fieldName, Reader reader) {
            boolean useStemming = true;
            if (fieldName.equals(RegainToolkit.FIELD_ACCESS_CONTROL_GROUPS) || this.mUntokenizedFieldNames.contains(fieldName)) {
                useStemming = false;
            }
            if (useStemming) {
                LowercasingReader lowercasingReader = new LowercasingReader(reader);
                return this.mNestedAnalyzer.tokenStream(fieldName, lowercasingReader);
            }
            return this.mNoStemmingAnalyzer.tokenStream(fieldName, reader);
        }
    }
}

