/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain;

import com.sun.mail.imap.IMAPFolder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.URLName;

public class ImapToolkit {
    private static Pattern messagePattern = Pattern.compile(".*((message_([0-9]+))(_attachment_([0-9]+))*)$");

    public static Pattern getMessagePattern() {
        return messagePattern;
    }

    public static boolean isMessageURL(String url) throws Exception {
        URLName urlName = new URLName(url);
        boolean result = false;
        if (urlName.getFile() != null) {
            try {
                Matcher matcher = messagePattern.matcher(url);
                matcher.find();
                if (matcher.groupCount() > 0 && matcher.group(1).startsWith("message")) {
                    result = true;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String cutMessageIdentifier(String url) throws Exception {
        String result = "";
        Matcher matcher = messagePattern.matcher(url);
        matcher.find();
        if (matcher.groupCount() > 0) {
            result = url.replaceFirst("/" + matcher.group(1), "");
        }
        return result;
    }

    public static Map<String, Integer> getAllFolders(IMAPFolder entryFolder, boolean recursive) throws Exception {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        IMAPFolder currFolder = entryFolder;
        if (currFolder.list().length > 0) {
            IMAPFolder[] folderList;
            for (IMAPFolder folder : folderList = (IMAPFolder[])currFolder.list()) {
                if (!folder.exists()) continue;
                try {
                    folder.open(1);
                    result.put(folder.getName(), folder.getMessageCount());
                    folder.close(false);
                }
                catch (MessagingException messageEx) {
                    result.put(folder.getFullName(), 0);
                }
                if (!recursive) continue;
                Map<String, Integer> subFolders = ImapToolkit.getAllFolders(folder, true);
                for (Map.Entry<String, Integer> entry : subFolders.entrySet()) {
                    result.put(entry.getKey(), entry.getValue());
                }
            }
        }
        return result;
    }
}

