/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.preparator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;
import javax.mail.util.SharedByteArrayInputStream;
import net.sf.regain.RegainException;
import net.sf.regain.RegainToolkit;
import net.sf.regain.crawler.document.AbstractPreparator;
import net.sf.regain.crawler.document.RawDocument;
import net.sf.regain.crawler.preparator.util.StripEntities;
import org.apache.log4j.Logger;

public class MessagePreparator
extends AbstractPreparator {
    private static Logger mLog = Logger.getLogger(MessagePreparator.class);
    private static Pattern mURLPattern = Pattern.compile("(?im)((?:http|https|ftp|mailto):[^\\s\"'<>]*)");

    public MessagePreparator() throws RegainException {
        super("message/rfc822");
    }

    public void prepare(RawDocument rawDocument) throws RegainException {
        StringBuffer resultText;
        ArrayList<String> attachments;
        ArrayList<String> textParts;
        block37: {
            Properties mailProperties = System.getProperties();
            Session session = Session.getInstance(mailProperties, null);
            SharedByteArrayInputStream mimeInput = new SharedByteArrayInputStream(rawDocument.getContent());
            textParts = new ArrayList<String>();
            attachments = new ArrayList<String>();
            SimpleDateFormat simpleFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            resultText = new StringBuffer();
            StringBuffer keyText = new StringBuffer();
            try {
                int i;
                MimeMessage message = new MimeMessage(session, mimeInput);
                resultText.append("Subject: " + message.getSubject()).append("\n");
                if (message.getSentDate() != null) {
                    resultText.append("Sent: " + simpleFormat.format(message.getSentDate())).append("\n");
                }
                if (message.getReceivedDate() != null) {
                    resultText.append("Received: " + simpleFormat.format(message.getReceivedDate())).append("\n");
                }
                Address[] recipientsArray = null;
                try {
                    recipientsArray = message.getAllRecipients();
                }
                catch (AddressException ae) {
                    recipientsArray = this.fixAddress(ae, message, "To");
                }
                if (recipientsArray != null && recipientsArray.length > 0) {
                    String recipients = "";
                    for (int i2 = 0; i2 < recipientsArray.length; ++i2) {
                        recipients = recipients + recipientsArray[i2].toString() + ", ";
                        keyText.append(this.stripNoneWordChars(recipientsArray[i2].toString()) + " ");
                    }
                    recipients = recipients.substring(0, recipients.length() - 2);
                    resultText.append("Recipient(s): " + recipients).append("\n");
                }
                Address[] repliesArray = null;
                try {
                    repliesArray = message.getReplyTo();
                }
                catch (AddressException ae) {
                    repliesArray = this.fixAddress(ae, message, "Reply-to");
                }
                if (repliesArray != null && repliesArray.length > 0) {
                    String replies = "";
                    for (int i3 = 0; i3 < repliesArray.length; ++i3) {
                        replies = replies + repliesArray[i3].toString() + ", ";
                        keyText.append(this.stripNoneWordChars(repliesArray[i3].toString()) + " ");
                    }
                    replies = replies.substring(0, replies.length() - 2);
                    resultText.append("Reply to: " + replies).append("\n");
                }
                Address[] senderArray = null;
                try {
                    senderArray = message.getFrom();
                }
                catch (AddressException ae) {
                    senderArray = this.fixAddress(ae, message, "From");
                }
                if (senderArray != null && senderArray.length > 0) {
                    String sender = "";
                    for (i = 0; i < senderArray.length; ++i) {
                        sender = sender + senderArray[i].toString() + ", ";
                        keyText.append(this.stripNoneWordChars(senderArray[i].toString()) + " ");
                    }
                    sender = sender.substring(0, sender.length() - 2);
                    this.setTitle(message.getSubject() + " from " + sender);
                    resultText.append("Sender: " + sender).append("\n");
                }
                resultText.append("Header key words: " + keyText.toString()).append("\n");
                resultText.append("-------------------------------------------------------------").append("\n");
                if (message.getContent() instanceof Multipart) {
                    Multipart mp = (Multipart)message.getContent();
                    for (i = 0; i < mp.getCount(); ++i) {
                        BodyPart bp = mp.getBodyPart(i);
                        String disposition = bp.getDisposition();
                        if (disposition != null && disposition.equals("attachment")) {
                            attachments.add("attachment: " + bp.getFileName());
                            if (!bp.isMimeType("text/*")) continue;
                            textParts.add((String)bp.getContent());
                            mLog.debug((Object)("added txt from attachment: " + bp.getFileName() + " : " + bp.getContentType()));
                            continue;
                        }
                        if (disposition != null && !disposition.equals("inline")) continue;
                        if (bp.isMimeType("text/*")) {
                            textParts.add((String)bp.getContent());
                            continue;
                        }
                        if (bp.isMimeType("multipart/*")) {
                            Multipart mpInner = (Multipart)bp.getContent();
                            for (int k = 0; k < mpInner.getCount(); ++k) {
                                BodyPart bpInner = mpInner.getBodyPart(k);
                                if (bpInner == null || bpInner.getDisposition() != null && !bpInner.getDisposition().equals("inline") || !bpInner.isMimeType("text/*")) continue;
                                textParts.add((String)bpInner.getContent());
                            }
                            continue;
                        }
                        if (!bp.isMimeType("message/*")) continue;
                        Object bpContent = bp.getContent();
                        if (bpContent instanceof MimeMessage) {
                            MimeMessage mmInner = (MimeMessage)bp.getContent();
                            Enumeration e = mmInner.getAllHeaderLines();
                            while (e.hasMoreElements()) {
                                textParts.add((String)e.nextElement());
                            }
                            Object mmContent = mmInner.getContent();
                            if (mmContent instanceof String) {
                                textParts.add((String)mmContent);
                                continue;
                            }
                            if (mmContent instanceof InputStream) {
                                textParts.add(RegainToolkit.readStringFromStream((InputStream)((InputStream)mmContent)));
                                continue;
                            }
                            mLog.error((Object)("Message Content is of unknown Class: " + mmContent.getClass().getName()));
                            continue;
                        }
                        if (bpContent instanceof InputStream) {
                            textParts.add(RegainToolkit.readStringFromStream((InputStream)((InputStream)bpContent)));
                            continue;
                        }
                        mLog.error((Object)("Body Part Inner Message Content is of unknown Class: " + bpContent.getClass().getName()));
                    }
                    break block37;
                }
                Object content = message.getContent();
                if (content instanceof String) {
                    textParts.add((String)content);
                } else if (content instanceof InputStream) {
                    textParts.add(RegainToolkit.readStringFromStream((InputStream)((InputStream)content)));
                } else {
                    mLog.error((Object)("Message content is of unknown class: " + content.getClass().getName()));
                }
            }
            catch (MessagingException ex) {
                mLog.error((Object)"Could not instantiate mime message for parsing.", (Throwable)ex);
            }
            catch (IOException ex) {
                mLog.error((Object)"Could not parse mime message for parsing.", (Throwable)ex);
            }
        }
        if (textParts.size() > 0) {
            for (String current : textParts) {
                resultText.append(StripEntities.stripHTMLTags(current) + " ").append("\n");
                Collection<String> urls = this.extractURLs(current);
                if (urls == null || urls.isEmpty()) continue;
                Iterator<String> uIter = urls.iterator();
                while (uIter.hasNext()) {
                    resultText.append(uIter.next()).append("\n");
                }
            }
        }
        if (attachments.size() > 0) {
            Iterator iter = attachments.iterator();
            while (iter.hasNext()) {
                resultText.append(StripEntities.stripHTMLTags((String)iter.next())).append("\n");
            }
        }
        this.setCleanedContent(resultText.toString());
    }

    private Address[] fixAddress(AddressException ae, MimeMessage message, String headerName) {
        Address[] addresses = null;
        try {
            String[] toArray = message.getHeader(headerName);
            if (toArray != null && ae.getMessage().contains("Illegal semicolon, not in group")) {
                toArray[0] = toArray[0].replace(';', ',');
                message.setHeader(headerName, toArray[0]);
                try {
                    addresses = message.getAllRecipients();
                }
                catch (Exception e) {
                    addresses = null;
                }
            }
        }
        catch (MessagingException me) {
            addresses = null;
            mLog.error((Object)("Could not parse Header: " + headerName));
        }
        return addresses;
    }

    private Collection<String> extractURLs(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        Matcher matcher = mURLPattern.matcher(text);
        while (matcher.find()) {
            String url = matcher.group(1);
            result.add(url);
        }
        return result;
    }

    private String stripNoneWordChars(String uncleanString) {
        return uncleanString.replace(".", " ").replace(":", " ").replace("@", " ").replace("-", " ").replace("_", " ").replace("<", " ").replace(">", " ");
    }

    public static String inputStreamAsString(InputStream stream) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line + "\n");
        }
        br.close();
        return sb.toString();
    }
}

