/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.preparator.java;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import net.sf.regain.RegainException;
import net.sf.regain.crawler.preparator.java.JClassEnum;
import net.sf.regain.crawler.preparator.java.JMethod;
import net.sf.regain.crawler.preparator.java.Type;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class JavaParser {
    private ASTParser _parser = ASTParser.newParser(3);
    private CompilationUnit _unit = null;
    private JClassEnum _class = null;

    public void setSource(String sourceStr) throws RegainException {
        try {
            this._parser.setKind(8);
            this._parser.setSource(sourceStr.toString().toCharArray());
            Hashtable options = JavaCore.getOptions();
            JavaCore.setComplianceOptions("1.5", options);
            this._parser.setCompilerOptions(options);
            this._unit = (CompilationUnit)this._parser.createAST(null);
        }
        catch (Exception ex) {
            throw new RegainException("Error parsing Java file", (Throwable)ex);
        }
    }

    public ArrayList getImportDeclarations() {
        List imports = this._unit.imports();
        if (imports.isEmpty()) {
            return null;
        }
        ArrayList<String> importDecl = new ArrayList<String>();
        ListIterator iter = imports.listIterator();
        while (iter.hasNext()) {
            ImportDeclaration decl = (ImportDeclaration)iter.next();
            importDecl.add(decl.getName().toString());
        }
        return importDecl;
    }

    public List getComments() {
        List comments = this._unit.getCommentList();
        if (comments.isEmpty()) {
            return null;
        }
        ArrayList<String> javaDocComments = new ArrayList<String>();
        ListIterator iterator = comments.listIterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Javadoc)) continue;
            String comment = ((Javadoc)object).getComment();
            javaDocComments.add(comment);
        }
        return javaDocComments;
    }

    public JClassEnum getDeclaredClass() {
        List types = this._unit.types();
        ListIterator typeIter = types.listIterator(0);
        if (typeIter.hasNext()) {
            Object object = typeIter.next();
            this._class = new JClassEnum();
            if (object instanceof TypeDeclaration) {
                TypeDeclaration typeDeclaration = (TypeDeclaration)object;
                this.setClassInformation(this._class, typeDeclaration);
                return this._class;
            }
            if (object instanceof EnumDeclaration) {
                EnumDeclaration enumDeclaration = (EnumDeclaration)object;
                this.setEnumInformation(this._class, enumDeclaration);
                return this._class;
            }
        }
        return null;
    }

    private void setEnumInformation(JClassEnum cls, EnumDeclaration declaration) {
        cls.setType(Type.ENUM);
        cls.setClassName(declaration.getName().getIdentifier());
        List interfaceList = declaration.superInterfaceTypes();
        ListIterator interfaces = interfaceList.listIterator();
        while (interfaces.hasNext()) {
            SimpleType sin = (SimpleType)interfaces.next();
            cls.getInterfaces().add(sin.toString());
        }
        List constantsList = declaration.enumConstants();
        for (EnumConstantDeclaration constant : constantsList) {
            cls.getConstants().add(constant);
        }
    }

    private void setClassInformation(JClassEnum cls, TypeDeclaration declaration) {
        if (declaration.isInterface()) {
            cls.setType(Type.INTERFACE);
        } else {
            cls.setType(Type.CLASS);
        }
        cls.setClassName(declaration.getName().getIdentifier());
        SimpleType _superClass = (SimpleType)declaration.getSuperclassType();
        if (_superClass != null) {
            cls.setSuperClass(_superClass.getName().getFullyQualifiedName());
        }
        List interfaceLst = declaration.superInterfaceTypes();
        ListIterator interfaces = interfaceLst.listIterator();
        while (interfaces.hasNext()) {
            SimpleType sin = (SimpleType)interfaces.next();
            cls.getInterfaces().add(sin.toString());
        }
        this.addMethods(cls, declaration);
        TypeDeclaration[] innerTypes = declaration.getTypes();
        for (int i = 0; i < innerTypes.length; ++i) {
            JClassEnum innerCls = new JClassEnum();
            this.setClassInformation(innerCls, innerTypes[i]);
            cls.getInnerClasses().add(innerCls);
        }
    }

    private void addMethods(JClassEnum cls, TypeDeclaration object) {
        MethodDeclaration[] met = object.getMethods();
        for (int i = 0; i < met.length; ++i) {
            Block d;
            MethodDeclaration dec = met[i];
            JMethod method = new JMethod();
            method.setMethodName(dec.getName().toString());
            org.eclipse.jdt.core.dom.Type returnType = dec.getReturnType2();
            if (returnType != null) {
                method.setReturnType(returnType.toString());
            }
            if ((d = dec.getBody()) == null) continue;
            method.setCodeBlock(d.toString());
            List param = dec.parameters();
            ListIterator paramList = param.listIterator();
            while (paramList.hasNext()) {
                SingleVariableDeclaration sin = (SingleVariableDeclaration)paramList.next();
                method.getParameters().add(sin.getType().toString());
            }
            cls.getMethodDeclarations().add(method);
        }
    }
}

