/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.preparator;

import java.util.ArrayList;
import java.util.List;
import net.sf.regain.RegainException;
import net.sf.regain.crawler.document.AbstractPreparator;
import net.sf.regain.crawler.document.RawDocument;
import net.sf.regain.crawler.preparator.java.JClassEnum;
import net.sf.regain.crawler.preparator.java.JMethod;
import net.sf.regain.crawler.preparator.java.JavaParser;
import net.sf.regain.crawler.preparator.java.Type;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;

public class JavaPreparator
extends AbstractPreparator {
    public JavaPreparator() throws RegainException {
        super(new String[]{"text/java"});
    }

    public void prepare(RawDocument rawDocument) throws RegainException {
        ArrayList<String> contentParts = new ArrayList<String>();
        ArrayList<String> titleParts = new ArrayList<String>();
        try {
            JavaParser parser = new JavaParser();
            parser.setSource(rawDocument.getContentAsString());
            JClassEnum cls = parser.getDeclaredClass();
            titleParts.add(cls.getType().toString() + " : " + cls.getClassName());
            contentParts.add(this.extractClassInfo(cls, false).toString());
            this.setTitle(this.concatenateStringParts(titleParts, Integer.MAX_VALUE));
            this.setCleanedContent(this.concatenateStringParts(contentParts, Integer.MAX_VALUE));
        }
        catch (Exception ex) {
            throw new RegainException("Error parsing Java file: " + rawDocument.getUrl(), (Throwable)ex);
        }
    }

    private StringBuffer extractClassInfo(JClassEnum cls, boolean innerClass) {
        StringBuffer strBuffer = new StringBuffer();
        String class_interface = "";
        if (cls.getType() == Type.INTERFACE) {
            class_interface = " Interface: ";
        } else if (innerClass) {
            class_interface = ", InnerClass: ";
        } else if (cls.getType() == Type.CLASS) {
            class_interface = " Class: ";
        } else if (cls.getType() == Type.ENUM) {
            class_interface = " Enum: ";
        }
        strBuffer.append(class_interface).append(cls.getClassName());
        String superCls = cls.getSuperClass();
        if (superCls != null) {
            strBuffer.append(", Superclass: ").append(superCls);
        }
        ArrayList interfaces = cls.getInterfaces();
        for (int i = 0; i < interfaces.size(); ++i) {
            strBuffer.append(", implements: ").append((String)interfaces.get(i));
        }
        strBuffer.append(this.extractMethodInfo(cls));
        if (cls.getType() == Type.ENUM) {
            strBuffer.append(this.extractEnumInfo(cls));
        }
        ArrayList innerCls = cls.getInnerClasses();
        for (int i = 0; i < innerCls.size(); ++i) {
            strBuffer.append(this.extractClassInfo((JClassEnum)innerCls.get(i), true));
        }
        return strBuffer;
    }

    private StringBuffer extractEnumInfo(JClassEnum cls) {
        StringBuffer strBuffer = new StringBuffer();
        ArrayList constants = cls.getConstants();
        for (int i = 0; i < constants.size(); ++i) {
            strBuffer.append(" ").append(((EnumConstantDeclaration)constants.get(i)).getName().getIdentifier());
        }
        return strBuffer;
    }

    private StringBuffer extractMethodInfo(JClassEnum cls) {
        StringBuffer strBuffer = new StringBuffer();
        ArrayList methods = cls.getMethodDeclarations();
        for (int i = 0; i < methods.size(); ++i) {
            JMethod method = (JMethod)methods.get(i);
            strBuffer.append(", ");
            String returnType = method.getReturnType();
            if (returnType != null && !returnType.equalsIgnoreCase("void")) {
                strBuffer.append(" ").append(returnType);
            }
            strBuffer.append(" ").append(method.getMethodName()).append("(");
            ArrayList params = method.getParameters();
            for (int k = 0; k < params.size(); ++k) {
                if (k != 0) {
                    strBuffer.append(" ");
                }
                strBuffer.append((String)params.get(k));
            }
            strBuffer.append(") ");
            String code = method.getCodeBlock();
            if (code == null) continue;
            strBuffer.append(code);
        }
        return strBuffer;
    }

    private StringBuffer extractImportDeclarations(JavaParser parser) {
        StringBuffer strBuffer = new StringBuffer();
        ArrayList imports = parser.getImportDeclarations();
        if (imports == null) {
            return strBuffer;
        }
        for (int i = 0; i < imports.size(); ++i) {
            strBuffer.append((String)imports.get(i));
        }
        return strBuffer;
    }

    private StringBuffer extractComments(JavaParser parser) {
        StringBuffer strBuffer = new StringBuffer();
        List comments = parser.getComments();
        if (comments == null) {
            return strBuffer;
        }
        for (int i = 0; i < comments.size(); ++i) {
            String docComment = (String)comments.get(i);
            strBuffer.append(docComment);
        }
        return strBuffer;
    }
}

