/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.preparator;

import com.jacob.com.ComFailException;
import com.jacob.com.ComThread;
import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import de.filiadata.lucene.spider.generated.msoffice2000.powerpoint.Application;
import de.filiadata.lucene.spider.generated.msoffice2000.powerpoint.Presentation;
import de.filiadata.lucene.spider.generated.msoffice2000.powerpoint.Shape;
import de.filiadata.lucene.spider.generated.msoffice2000.powerpoint.Shapes;
import de.filiadata.lucene.spider.generated.msoffice2000.powerpoint.Slide;
import de.filiadata.lucene.spider.generated.msoffice2000.powerpoint.Slides;
import net.sf.regain.RegainException;
import net.sf.regain.crawler.config.PreparatorConfig;
import net.sf.regain.crawler.document.RawDocument;
import net.sf.regain.crawler.preparator.AbstractJacobMsOfficePreparator;

public class JacobMsPowerPointPreparator
extends AbstractJacobMsOfficePreparator {
    private Application mPowerPointApplication;
    private static int MSOGROUP = 6;

    public JacobMsPowerPointPreparator() throws RegainException {
        super(new String[]{"ppt", "pot"});
    }

    @Override
    public void init(PreparatorConfig config) throws RegainException {
        super.init(config);
    }

    public void prepare(RawDocument rawDocument) throws RegainException {
        if (this.mPowerPointApplication == null) {
            ComThread.InitSTA();
            this.mPowerPointApplication = new Application();
            Dispatch.put((Object)this.mPowerPointApplication, "Visible", (Object)new Variant(true));
        }
        try {
            String fileName = rawDocument.getContentAsFile().getAbsolutePath();
            Presentation pres = this.mPowerPointApplication.getPresentations().open(fileName);
            StringBuffer contentBuf = new StringBuffer(16384);
            Slides slides = pres.getSlides();
            int slideCount = slides.getCount();
            for (int slideIdx = 1; slideIdx <= slideCount; ++slideIdx) {
                Shape shape;
                int shapeIdx;
                int shapeCount;
                Shapes shapes;
                boolean didUnGroup;
                Slide slide = slides.item(new Variant(slideIdx));
                do {
                    shapes = slide.getShapes();
                    shapeCount = shapes.getCount();
                    didUnGroup = false;
                    for (shapeIdx = 1; shapeIdx <= shapeCount; ++shapeIdx) {
                        shape = shapes.item(new Variant(shapeIdx));
                        if (shape.getType() != MSOGROUP) continue;
                        didUnGroup = true;
                        shape.ungroup();
                    }
                } while (didUnGroup);
                shapes = slide.getShapes();
                shapeCount = shapes.getCount();
                for (shapeIdx = 1; shapeIdx <= shapeCount; ++shapeIdx) {
                    shape = shapes.item(new Variant(shapeIdx));
                    this.extractTextFrom(shape, contentBuf);
                }
                contentBuf.append('\n');
            }
            this.readProperties(pres);
            this.setCleanedContent(contentBuf.toString());
            pres.close();
        }
        catch (ComFailException exc) {
            throw new RegainException("Using COM failed.", (Throwable)exc);
        }
    }

    private void extractTextFrom(Shape shape, StringBuffer contentBuf) {
        String text;
        int hasTextFrame = shape.getHasTextFrame();
        if (hasTextFrame == -1 && (text = shape.getTextFrame().getTextRange().getText()) != null && (text = text.trim()).length() != 0) {
            text = this.removeHyphenation(text);
            contentBuf.append(text);
            contentBuf.append('\n');
        }
    }

    private String removeHyphenation(String text) {
        int last = 0;
        while (text.indexOf(45, last) >= 0) {
            int i = text.indexOf(45, last);
            if ((last = i + 1) >= text.length() || text.charAt(last) != '\r' && text.charAt(last) != '\u000b') continue;
            if (last + 1 < text.length() && text.charAt(last + 1) == '\n') {
                text = text.substring(0, i) + text.substring(i + 3);
                continue;
            }
            text = text.substring(0, i) + text.substring(i + 2);
        }
        return text;
    }

    public void close() throws RegainException {
        if (this.mPowerPointApplication != null) {
            try {
                System.out.println("quitting Powerpoint");
                this.mPowerPointApplication.quit();
                System.out.println("Powerpoint quitted");
            }
            catch (Throwable thr) {
                throw new RegainException("Using COM failed.", thr);
            }
            finally {
                ComThread.Release();
            }
        }
    }
}

