/*
 * Decompiled with CFR 0.152.
 */
package net.sf.regain.crawler.preparator;

import com.jacob.com.Dispatch;
import com.jacob.com.Variant;
import java.util.HashMap;
import java.util.Map;
import net.sf.regain.RegainException;
import net.sf.regain.RegainToolkit;
import net.sf.regain.crawler.config.PreparatorConfig;
import net.sf.regain.crawler.document.AbstractPreparator;

public abstract class AbstractJacobMsOfficePreparator
extends AbstractPreparator {
    private String[] mWantedPropertiesArr;
    private HashMap<String, Variant> mPropertyMap = new HashMap();

    public AbstractJacobMsOfficePreparator(String[] extensionArr) throws RegainException {
        super(extensionArr);
        this.mPropertyMap.put("propTitle", new Variant(1));
        this.mPropertyMap.put("subject", new Variant(2));
        this.mPropertyMap.put("author", new Variant(3));
        this.mPropertyMap.put("keywords", new Variant(4));
        this.mPropertyMap.put("comments", new Variant(5));
        this.mPropertyMap.put("template", new Variant(6));
        this.mPropertyMap.put("lastAuthor", new Variant(7));
        this.mPropertyMap.put("revision", new Variant(8));
        this.mPropertyMap.put("timeLastPrinted", new Variant(10));
        this.mPropertyMap.put("timeCreated", new Variant(11));
        this.mPropertyMap.put("timeLastSaved", new Variant(12));
        this.mPropertyMap.put("totalEditTime", new Variant(13));
        this.mPropertyMap.put("pages", new Variant(14));
        this.mPropertyMap.put("words", new Variant(15));
        this.mPropertyMap.put("characters", new Variant(16));
        this.mPropertyMap.put("security", new Variant(17));
        this.mPropertyMap.put("category", new Variant(18));
        this.mPropertyMap.put("manager", new Variant(20));
        this.mPropertyMap.put("company", new Variant(21));
        this.mPropertyMap.put("bytes", new Variant(22));
        this.mPropertyMap.put("lines", new Variant(23));
        this.mPropertyMap.put("paras", new Variant(24));
        this.mPropertyMap.put("slides", new Variant(25));
        this.mPropertyMap.put("notes", new Variant(26));
        this.mPropertyMap.put("hiddenSlides", new Variant(27));
        this.mPropertyMap.put("mmClips", new Variant(28));
        this.mPropertyMap.put("hyperlinkBase", new Variant(29));
        this.mPropertyMap.put("charsWSpaces", new Variant(30));
    }

    public void init(PreparatorConfig config) throws RegainException {
        String properties;
        Map main = config.getSectionWithName("main");
        if (main != null && (properties = (String)main.get("properties")) != null) {
            this.mWantedPropertiesArr = RegainToolkit.splitString((String)properties, (String)";", (boolean)true);
            for (int i = 0; i < this.mWantedPropertiesArr.length; ++i) {
                if (this.mPropertyMap.get(this.mWantedPropertiesArr[i]) != null) continue;
                StringBuffer possProp = new StringBuffer();
                for (String property : this.mPropertyMap.keySet()) {
                    if (possProp.length() > 0) {
                        possProp.append(", ");
                    }
                    possProp.append(property);
                }
                throw new RegainException("MS Word property '" + this.mWantedPropertiesArr[i] + "' does not exist. Possible " + "properties are: " + possProp.toString());
            }
        }
    }

    protected void readProperties(Dispatch document) {
        if (this.mWantedPropertiesArr != null) {
            for (int i = 0; i < this.mWantedPropertiesArr.length; ++i) {
                String propertyName = this.mWantedPropertiesArr[i];
                Variant propertyConstant = this.mPropertyMap.get(propertyName);
                Object property = Dispatch.call((Object)document, "BuiltInDocumentProperties", (Object)propertyConstant).getDispatch();
                String value = Dispatch.get(property, "Value").toString();
                this.addAdditionalField(propertyName, value);
            }
        }
    }
}

