/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data.config;

import io.tarantool.client.crud.TarantoolCrudClient;
import io.tarantool.client.factory.TarantoolCrudClientBuilder;
import io.tarantool.client.factory.TarantoolFactory;
import io.tarantool.spring.data.config.TarantoolConfiguration;
import io.tarantool.spring.data.config.properties.BaseTarantoolProperties;

public class BaseTarantoolCrudConfiguration
extends TarantoolConfiguration<TarantoolCrudClientBuilder> {
    private final TarantoolCrudClientBuilder tarantoolCrudClientBuilder;

    public BaseTarantoolCrudConfiguration(BaseTarantoolProperties properties, TarantoolCrudClientBuilder tarantoolClientConfiguration) {
        super(properties);
        this.tarantoolCrudClientBuilder = tarantoolClientConfiguration;
    }

    public TarantoolCrudClient tarantoolCrudClient() throws Exception {
        return this.getClientBuilder().build();
    }

    @Override
    public TarantoolCrudClientBuilder getClientBuilder() {
        if (this.tarantoolCrudClientBuilder != null) {
            return this.tarantoolCrudClientBuilder;
        }
        TarantoolCrudClientBuilder builder = TarantoolFactory.crud().withHost(this.properties.getHost()).withPassword(this.properties.getPassword()).withBalancerClass(this.properties.getBalancerClass()).withConnectTimeout(this.properties.getConnectTimeout()).withReconnectAfter(this.properties.getReconnectAfter()).withPort(this.properties.getPort()).withEventLoopThreadsCount(this.properties.getEventLoopThreadsCount()).withUser(this.properties.getUserName()).withGroups(this.properties.getInstanceConnectionGroups()).withHeartbeat(this.properties.getHeartbeatOpts());
        if (!this.properties.isGracefulShutdownEnabled()) {
            builder.disableGracefulShutdown();
        }
        return builder;
    }
}

