/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol;

import io.tarantool.core.protocol.ByteBodyValueWrapper;
import io.tarantool.core.protocol.IProtoResponse;
import io.tarantool.core.protocol.IProtoResponseImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;

public class IProtoRawResponse
extends IProtoResponseImpl
implements IProtoResponse {
    private final byte[] packet;
    private final int headerSize;
    private final int bodySize;
    private long schemaVersion;
    private final Map<Integer, ByteBodyValueWrapper> byteBodyValues;

    public IProtoRawResponse(MapValue header, byte[] packet, int headerSize) {
        this.header = header;
        this.headerMap = IProtoRawResponse.convertMap(header);
        this.syncId = this.headerMap.containsKey(1) ? Long.valueOf(((Value)this.headerMap.get(1)).asIntegerValue().asLong()) : null;
        if (this.headerMap.containsKey(5)) {
            this.schemaVersion = ((Value)this.headerMap.get(5)).asIntegerValue().asLong();
        }
        this.requestType = ((Value)this.headerMap.get(0)).asIntegerValue().asInt();
        this.packet = packet;
        this.headerSize = headerSize;
        this.bodySize = packet.length - headerSize;
        this.byteBodyValues = new HashMap<Integer, ByteBodyValueWrapper>();
    }

    @Override
    public ByteBodyValueWrapper getByteBodyValue(int key) {
        this.unpackByteBodyIfNeeded();
        return this.byteBodyValues.get(key);
    }

    @Override
    public Map<Integer, ByteBodyValueWrapper> getByteBodyValues() {
        this.unpackByteBodyIfNeeded();
        return this.byteBodyValues;
    }

    @Override
    public MapValue getBody() {
        this.unpackIfNeeded();
        return super.getBody();
    }

    @Override
    public boolean isBodyEmpty() {
        return this.packet[this.headerSize] == -128 || this.packet[this.headerSize + 2] == -128;
    }

    private void unpackIfNeeded() {
        if (this.body != null) {
            return;
        }
        try (MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])this.packet, (int)this.headerSize, (int)this.bodySize);){
            if (unpacker.hasNext()) {
                this.body = unpacker.unpackValue().asMapValue();
                this.bodyMap = IProtoRawResponse.convertMap(this.body);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void unpackByteBodyIfNeeded() {
        if (!this.byteBodyValues.isEmpty()) {
            return;
        }
        try (MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])this.packet, (int)this.headerSize, (int)this.bodySize);){
            if (unpacker.hasNext()) {
                int sz = unpacker.unpackMapHeader();
                for (int i = 0; i < sz; ++i) {
                    int bodyKey = unpacker.unpackInt();
                    int read = (int)unpacker.getTotalReadBytes();
                    unpacker.skipValue();
                    int end = (int)unpacker.getTotalReadBytes();
                    this.byteBodyValues.put(bodyKey, new ByteBodyValueWrapper(this.packet, this.headerSize + read, end - read));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Value getBodyValue(int key) {
        this.unpackIfNeeded();
        return super.getBodyValue(key);
    }

    @Override
    public long getSchemaVersion() {
        return this.schemaVersion;
    }
}

