/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.connection.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.tarantool.core.connection.Greeting;
import java.util.concurrent.CompletableFuture;

public class GreetingHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final int GREETING_LENGTH = 128;
    private final CompletableFuture<Greeting> promise;

    public GreetingHandler(CompletableFuture<Greeting> promise) {
        this.promise = promise;
    }

    public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) {
        if (in.readableBytes() < 128) {
            return;
        }
        byte[] greeting = new byte[128];
        in.readBytes(greeting);
        this.promise.complete(Greeting.parse(greeting));
        ctx.pipeline().remove((ChannelHandler)this);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.promise.completeExceptionally(cause);
    }
}

