/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.mapping;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import io.tarantool.core.protocol.ByteBodyValueWrapper;
import io.tarantool.core.protocol.IProtoResponse;
import io.tarantool.mapping.BaseTarantoolJacksonMapping;
import io.tarantool.mapping.Field;
import io.tarantool.mapping.SelectResponse;
import io.tarantool.mapping.TarantoolResponse;
import io.tarantool.mapping.Tuple;
import io.tarantool.mapping.crud.CrudBatchResponse;
import io.tarantool.mapping.crud.CrudResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class TarantoolJacksonMappingWithoutTargetType
extends BaseTarantoolJacksonMapping {
    public static final TypeReference<Map<Integer, List<Field>>> TYPE_REF_MAP_INTEGER_LIST_FIELD = new TypeReference<Map<Integer, List<Field>>>(){};

    public static CompletableFuture<TarantoolResponse<List<?>>> convertFutureResult(CompletableFuture<IProtoResponse> future) {
        return future.thenApply(TarantoolJacksonMappingWithoutTargetType::readResponse);
    }

    public static TarantoolResponse<List<?>> readResponse(IProtoResponse response) {
        return new TarantoolResponse(TarantoolJacksonMappingWithoutTargetType.readData(response, List.class), TarantoolJacksonMappingWithoutTargetType.getFormats(response));
    }

    public static CompletableFuture<Tuple<List<?>>> convertSpaceSingleResultFuture(CompletableFuture<IProtoResponse> future) {
        return ((CompletableFuture)future.thenApply(TarantoolJacksonMappingWithoutTargetType::readSpaceData)).thenApply(TarantoolJacksonMappingWithoutTargetType::getTupleWithInjectedFormat);
    }

    private static TarantoolResponse<List<Tuple<List<?>>>> readSpaceData(IProtoResponse response) {
        return new TarantoolResponse((List)TarantoolJacksonMappingWithoutTargetType.readData(response, (JavaType)LIST_TUPLE_LIST), TarantoolJacksonMappingWithoutTargetType.getFormats(response));
    }

    private static Tuple<List<?>> getTupleWithInjectedFormat(TarantoolResponse<List<Tuple<List<?>>>> resp) {
        Iterator<Tuple<List<?>>> iterator;
        Map<Integer, List<Field>> formats = resp.getFormats();
        List<Tuple<List<?>>> data = resp.get();
        if (data != null && (iterator = data.iterator()).hasNext()) {
            Tuple<List<?>> tuple = iterator.next();
            if (formats.isEmpty()) {
                return tuple;
            }
            Integer formatId = tuple.getFormatId();
            List<Field> format = formats.get(formatId);
            tuple.setFormat(format);
            return tuple;
        }
        return null;
    }

    public static CompletableFuture<Tuple<List<?>>> convertCrudSingleResultFuture(CompletableFuture<IProtoResponse> future) {
        return ((CompletableFuture)future.thenApply(TarantoolJacksonMappingWithoutTargetType::readCrudSingleResultData)).thenApply(TarantoolJacksonMappingWithoutTargetType::getTupleWithInjectedFormat);
    }

    public static TarantoolResponse<List<Tuple<List<?>>>> readCrudSingleResultData(IProtoResponse response) {
        return new TarantoolResponse((List)TarantoolJacksonMappingWithoutTargetType.getRows((CrudResponse)TarantoolJacksonMappingWithoutTargetType.readData(response, TarantoolJacksonMappingWithoutTargetType.wrapIntoType(CrudResponse.class, (JavaType)LIST_TUPLE_LIST))), TarantoolJacksonMappingWithoutTargetType.getFormats(response));
    }

    public static <T> T getRows(CrudResponse<T> response) {
        return response.getRows();
    }

    public static CompletableFuture<SelectResponse<List<Tuple<List<?>>>>> convertSelectResultFuture(CompletableFuture<IProtoResponse> future) {
        return ((CompletableFuture)future.thenApply(TarantoolJacksonMappingWithoutTargetType::readSelectResult)).thenApply(TarantoolJacksonMappingWithoutTargetType::injectFormatIntoTuples);
    }

    public static SelectResponse<List<Tuple<List<?>>>> readSelectResult(IProtoResponse response) {
        return new SelectResponse((List)TarantoolJacksonMappingWithoutTargetType.readData(response, (JavaType)LIST_TUPLE), TarantoolJacksonMappingWithoutTargetType.getPosition(response), TarantoolJacksonMappingWithoutTargetType.getFormats(response));
    }

    private static SelectResponse<List<Tuple<List<?>>>> injectFormatIntoTuples(SelectResponse<List<Tuple<List<?>>>> resp) {
        Map<Integer, List<Field>> formats = resp.getFormats();
        if (!formats.isEmpty()) {
            for (Tuple tuple : (List)resp.get()) {
                Integer formatId = tuple.getFormatId();
                List<Field> format = formats.get(formatId);
                tuple.setFormat(format);
            }
        }
        return resp;
    }

    public static Map<Integer, List<Field>> getFormats(IProtoResponse response) {
        Map<Integer, List<Field>> formats = Collections.emptyMap();
        ByteBodyValueWrapper rawFormats = response.getByteBodyValue(96);
        if (rawFormats != null) {
            formats = TarantoolJacksonMappingWithoutTargetType.readValue(rawFormats, TYPE_REF_MAP_INTEGER_LIST_FIELD);
        }
        return formats;
    }

    public static byte[] getPosition(IProtoResponse response) {
        byte[] position = null;
        ByteBodyValueWrapper rawPosition = response.getByteBodyValue(53);
        if (rawPosition != null) {
            position = Arrays.copyOfRange(rawPosition.getPacket(), rawPosition.getOffset(), rawPosition.getOffset() + rawPosition.getValueLength());
        }
        return position;
    }

    public static CompletableFuture<List<Tuple<List<?>>>> convertCrudSelectResultFuture(CompletableFuture<IProtoResponse> future) {
        return ((CompletableFuture)future.thenApply(resp -> TarantoolJacksonMappingWithoutTargetType.readCrudSelectResult(resp))).thenApply(resp -> TarantoolJacksonMappingWithoutTargetType.getTuplesWithInjectedFormat(resp));
    }

    public static TarantoolResponse<List<Tuple<List<?>>>> readCrudSelectResult(IProtoResponse response) {
        return new TarantoolResponse((List)TarantoolJacksonMappingWithoutTargetType.getRows((CrudResponse)TarantoolJacksonMappingWithoutTargetType.readData(response, TarantoolJacksonMappingWithoutTargetType.wrapIntoType(CrudResponse.class, (JavaType)LIST_TUPLE_LIST))), TarantoolJacksonMappingWithoutTargetType.getFormats(response));
    }

    private static List<Tuple<List<?>>> getTuplesWithInjectedFormat(TarantoolResponse<List<Tuple<List<?>>>> resp) {
        Map<Integer, List<Field>> formats = resp.getFormats();
        List<Tuple<List<?>>> tuples = resp.get();
        if (!formats.isEmpty()) {
            for (Tuple<List<?>> tuple : tuples) {
                Integer formatId = tuple.getFormatId();
                List<Field> format = formats.get(formatId);
                tuple.setFormat(format);
            }
        }
        return tuples;
    }

    public static CompletableFuture<CrudBatchResponse<List<Tuple<List<?>>>>> convertCrudBatchResultFuture(CompletableFuture<IProtoResponse> future) {
        return ((CompletableFuture)future.thenApply(resp -> TarantoolJacksonMappingWithoutTargetType.readCrudBatchResult(resp))).thenApply(resp -> TarantoolJacksonMappingWithoutTargetType.getBatchTuplesWithInjectedFormat(resp));
    }

    public static TarantoolResponse<CrudBatchResponse<List<Tuple<List<?>>>>> readCrudBatchResult(IProtoResponse response) {
        return new TarantoolResponse((CrudBatchResponse)TarantoolJacksonMappingWithoutTargetType.readData(response, TarantoolJacksonMappingWithoutTargetType.wrapIntoType(CrudBatchResponse.class, (JavaType)LIST_TUPLE_LIST)), TarantoolJacksonMappingWithoutTargetType.getFormats(response));
    }

    private static CrudBatchResponse<List<Tuple<List<?>>>> getBatchTuplesWithInjectedFormat(TarantoolResponse<CrudBatchResponse<List<Tuple<List<?>>>>> resp) {
        Map<Integer, List<Field>> formats = resp.getFormats();
        CrudBatchResponse<List<Tuple<List<?>>>> batchResp = resp.get();
        List<Tuple<List<?>>> tuples = batchResp.getRows();
        if (tuples != null && !formats.isEmpty()) {
            for (Tuple<List<?>> tuple : tuples) {
                Integer formatId = tuple.getFormatId();
                List<Field> format = formats.get(formatId);
                tuple.setFormat(format);
            }
        }
        return batchResp;
    }

    public static TarantoolResponse<?> fromEventData(IProtoResponse response) {
        return new TarantoolResponse<Object>(TarantoolJacksonMappingWithoutTargetType.readEventData(response), TarantoolJacksonMappingWithoutTargetType.getFormats(response));
    }
}

