/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.mapping;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.tarantool.mapping.Adjust;
import io.tarantool.mapping.Interval;
import io.tarantool.mapping.JacksonMappingException;
import io.tarantool.mapping.TarantoolDeserializer;
import io.tarantool.mapping.Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.jackson.dataformat.MessagePackExtensionType;

public class IntervalExtensionModule {
    private static final ThreadLocal<StringBuilder> threadLocalStringBuilder;
    public static final int FIELD_YEAR = 0;
    public static final int FIELD_MONTH = 1;
    public static final int FIELD_WEEK = 2;
    public static final int FIELD_DAY = 3;
    public static final int FIELD_HOUR = 4;
    public static final int FIELD_MIN = 5;
    public static final int FIELD_SEC = 6;
    public static final int FIELD_NSEC = 7;
    public static final int FIELD_ADJUST = 8;
    public static final int NONE_ADJUST = 0;
    public static final int EXCESS_ADJUST = 1;
    public static final int LAST_ADJUST = 2;
    public static final SimpleModule INSTANCE;

    private IntervalExtensionModule() {
    }

    static {
        INSTANCE = new SimpleModule("msgpack-ext-interval");
        threadLocalStringBuilder = ThreadLocal.withInitial(StringBuilder::new);
        INSTANCE.addSerializer(Interval.class, (JsonSerializer)new IntervalSerializer(Interval.class));
        INSTANCE.addDeserializer(Interval.class, (JsonDeserializer)new IntervalDeserializer(Interval.class));
    }

    public static class IntervalSerializer
    extends StdSerializer<Interval> {
        public IntervalSerializer(Class<Interval> t) {
            super(t);
        }

        public void serialize(Interval value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            int fieldsCount = 0;
            List<Long> fields = Arrays.asList(value.getYear(), value.getMonth(), value.getWeek(), value.getDay(), value.getHour(), value.getMin(), value.getSec(), value.getNsec());
            for (long fieldValue : fields) {
                if (fieldValue == 0L) continue;
                ++fieldsCount;
            }
            int adjust = value.getAdjust().ordinal();
            if (adjust != 0) {
                ++fieldsCount;
            }
            try (MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();){
                packer.packInt(fieldsCount);
                for (int i = 0; i < fields.size(); ++i) {
                    IntervalSerializer.packField(packer, i, fields.get(i));
                }
                if (adjust != 0) {
                    packer.packInt(8);
                    packer.packLong((long)adjust);
                }
                gen.writeObject((Object)new MessagePackExtensionType(6, packer.toByteArray()));
            }
        }

        private static void packField(MessageBufferPacker packer, int fieldId, long fieldValue) throws IOException {
            if (fieldValue != 0L) {
                packer.packInt(fieldId);
                packer.packLong(fieldValue);
            }
        }
    }

    public static class IntervalDeserializer
    extends StdDeserializer<Interval>
    implements TarantoolDeserializer<Interval> {
        public IntervalDeserializer(Class<?> vc) {
            super(vc);
        }

        public Interval deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            MessagePackExtensionType ext = (MessagePackExtensionType)p.readValueAs(MessagePackExtensionType.class);
            if (ext.getType() != 6) {
                StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                throw new JacksonMappingException(sb.delete(0, sb.length()).append("Unexpected extension type (0x").append(Utils.byteToHex(ext.getType())).append(") for Interval object").toString());
            }
            return this.deserialize(ext);
        }

        @Override
        public Interval deserialize(MessagePackExtensionType ext) throws IOException {
            byte[] data = ext.getData();
            Interval interval = new Interval();
            try (MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])data);){
                int fieldsCount = unpacker.unpackInt();
                block21: for (int i = 0; i < fieldsCount; ++i) {
                    int type = unpacker.unpackInt();
                    block2 : switch (type) {
                        case 0: {
                            interval.setYear(unpacker.unpackLong());
                            continue block21;
                        }
                        case 1: {
                            interval.setMonth(unpacker.unpackLong());
                            continue block21;
                        }
                        case 2: {
                            interval.setWeek(unpacker.unpackLong());
                            continue block21;
                        }
                        case 3: {
                            interval.setDay(unpacker.unpackLong());
                            continue block21;
                        }
                        case 4: {
                            interval.setHour(unpacker.unpackLong());
                            continue block21;
                        }
                        case 5: {
                            interval.setMin(unpacker.unpackLong());
                            continue block21;
                        }
                        case 6: {
                            interval.setSec(unpacker.unpackLong());
                            continue block21;
                        }
                        case 7: {
                            interval.setNsec(unpacker.unpackLong());
                            continue block21;
                        }
                        case 8: {
                            long adjust = unpacker.unpackLong();
                            switch ((int)adjust) {
                                case 0: {
                                    interval.setAdjust(Adjust.NoneAdjust);
                                    break block2;
                                }
                                case 1: {
                                    interval.setAdjust(Adjust.ExcessAdjust);
                                    break block2;
                                }
                                case 2: {
                                    interval.setAdjust(Adjust.LastAdjust);
                                }
                            }
                        }
                    }
                }
            }
            return interval;
        }
    }
}

