/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.mapping;

import io.tarantool.core.Assert;
import io.tarantool.mapping.Adjust;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Interval
implements TemporalAmount {
    private static final ThreadLocal<StringBuilder> threadLocalStringBuilder;
    private static final long SECS_PER_DAY = 86400L;
    private static final long MIN_DATE_YEAR = -5879610L;
    private static final long MIN_DATE_MONTH = 6L;
    private static final long MIN_DATE_DAY = 22L;
    private static final long MAX_DATE_YEAR = 5879611L;
    private static final long MAX_DATE_MONTH = 7L;
    private static final long MAX_DATE_DAY = 11L;
    private static final long AVERAGE_DAYS_YEAR = 365L;
    private static final long AVERAGE_WEEK_YEAR = 52L;
    private static final String OUT_OF_ALLOWED_RANGE = "is out of allowed range [-";
    private static final String YEARS_BOUND_FORMAT;
    private static final String MOTH_BOUND_FORMAT;
    private static final String WEEK_BOUND_FORMAT;
    private static final String DAY_BOUND_FORMAT;
    private static final String HOUR_BOUND_FORMAT;
    private static final String MIN_BOUND_FORMAT;
    private static final String SEC_BOUND_FORMAT;
    private static final String NSEC_BOUND_FORMAT;
    private static final String VALUE_BOUND_FORMAT;
    private static final List<TemporalUnit> SUPPORTED_UNITS;
    public static final long MAX_NSEC_RANGE = Integer.MAX_VALUE;
    public static final long MAX_YEAR_RANGE = 11759221L;
    public static final long MAX_MONTH_RANGE = 141110652L;
    public static final long MAX_DAY_RANGE = 4292115665L;
    public static final long MAX_HOUR_RANGE = 103010775960L;
    public static final long MAX_MIN_RANGE = 6180646557600L;
    public static final long MAX_SEC_RANGE = 370838793456000L;
    public static final long MAX_WEEK_RANGE = 611479492L;
    private long year;
    private long month;
    private long week;
    private long day;
    private long hour;
    private long min;
    private long sec;
    private long nsec;
    private Adjust adjust = Adjust.NoneAdjust;

    @Override
    public long get(TemporalUnit unit) {
        if (unit == ChronoUnit.YEARS) {
            return this.getYear();
        }
        if (unit == ChronoUnit.MONTHS) {
            return this.getMonth();
        }
        if (unit == ChronoUnit.WEEKS) {
            return this.getWeek();
        }
        if (unit == ChronoUnit.DAYS) {
            return this.getDay();
        }
        if (unit == ChronoUnit.HOURS) {
            return this.getHour();
        }
        if (unit == ChronoUnit.MINUTES) {
            return this.getMin();
        }
        if (unit == ChronoUnit.SECONDS) {
            return this.getSec();
        }
        if (unit == ChronoUnit.NANOS) {
            return this.getNsec();
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return SUPPORTED_UNITS;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        temporal = Interval.add(temporal, this.year, ChronoUnit.YEARS);
        temporal = this.addMonth(temporal);
        temporal = Interval.add(temporal, this.week, ChronoUnit.WEEKS);
        temporal = Interval.add(temporal, this.day, ChronoUnit.DAYS);
        temporal = Interval.add(temporal, this.hour, ChronoUnit.HOURS);
        temporal = Interval.add(temporal, this.min, ChronoUnit.MINUTES);
        temporal = Interval.add(temporal, this.sec, ChronoUnit.SECONDS);
        temporal = Interval.add(temporal, this.nsec, ChronoUnit.NANOS);
        return temporal;
    }

    private static Temporal add(Temporal temporal, long field, ChronoUnit fieldType) {
        if (field != 0L) {
            temporal = temporal.plus(field, fieldType);
        }
        return temporal;
    }

    private Temporal addMonth(Temporal temporal) {
        LocalDate oldYearMonth;
        int lastDayInOldMonth;
        int oldDay = temporal.get(ChronoField.DAY_OF_MONTH);
        int oldYear = temporal.get(ChronoField.YEAR);
        int oldMonth = temporal.get(ChronoField.MONTH_OF_YEAR);
        if (this.month != 0L) {
            temporal = temporal.plus(this.month, ChronoUnit.MONTHS);
        }
        int currentDay = temporal.get(ChronoField.DAY_OF_MONTH);
        if (this.adjust.equals((Object)Adjust.ExcessAdjust)) {
            return temporal.plus(oldDay - currentDay, ChronoUnit.DAYS);
        }
        if (this.adjust.equals((Object)Adjust.LastAdjust) && (lastDayInOldMonth = (oldYearMonth = LocalDate.of(oldYear, oldMonth, 1)).with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth()) == oldDay) {
            return temporal.with(TemporalAdjusters.lastDayOfMonth());
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        temporal = Interval.add(temporal, -this.year, ChronoUnit.YEARS);
        temporal = Interval.add(temporal, -this.month, ChronoUnit.MONTHS);
        temporal = Interval.add(temporal, -this.week, ChronoUnit.WEEKS);
        temporal = Interval.add(temporal, -this.day, ChronoUnit.DAYS);
        temporal = Interval.add(temporal, -this.hour, ChronoUnit.HOURS);
        temporal = Interval.add(temporal, -this.min, ChronoUnit.MINUTES);
        temporal = Interval.add(temporal, -this.sec, ChronoUnit.SECONDS);
        temporal = Interval.add(temporal, -this.nsec, ChronoUnit.NANOS);
        return temporal;
    }

    public long getYear() {
        return this.year;
    }

    public Interval setYear(long year) {
        Assert.state((-11759221L <= year && year <= 11759221L ? 1 : 0) != 0, (String)threadLocalStringBuilder.get().delete(0, threadLocalStringBuilder.get().length()).append(VALUE_BOUND_FORMAT).append(year).append(YEARS_BOUND_FORMAT).toString());
        this.year = year;
        return this;
    }

    public long getMonth() {
        return this.month;
    }

    public Interval setMonth(long month) {
        Assert.state((-141110652L <= month && month <= 141110652L ? 1 : 0) != 0, (String)threadLocalStringBuilder.get().delete(0, threadLocalStringBuilder.get().length()).append(VALUE_BOUND_FORMAT).append(month).append(MOTH_BOUND_FORMAT).toString());
        this.month = month;
        return this;
    }

    public long getWeek() {
        return this.week;
    }

    public Interval setWeek(long week) {
        Assert.state((-611479492L <= week && week <= 611479492L ? 1 : 0) != 0, (String)threadLocalStringBuilder.get().delete(0, threadLocalStringBuilder.get().length()).append(VALUE_BOUND_FORMAT).append(week).append(WEEK_BOUND_FORMAT).toString());
        this.week = week;
        return this;
    }

    public long getDay() {
        return this.day;
    }

    public Interval setDay(long day) {
        Assert.state((-4292115665L <= day && day <= 4292115665L ? 1 : 0) != 0, (String)threadLocalStringBuilder.get().delete(0, threadLocalStringBuilder.get().length()).append(VALUE_BOUND_FORMAT).append(day).append(DAY_BOUND_FORMAT).toString());
        this.day = day;
        return this;
    }

    public long getHour() {
        return this.hour;
    }

    public Interval setHour(long hour) {
        Assert.state((-103010775960L <= hour && hour <= 103010775960L ? 1 : 0) != 0, (String)threadLocalStringBuilder.get().delete(0, threadLocalStringBuilder.get().length()).append(VALUE_BOUND_FORMAT).append(hour).append(HOUR_BOUND_FORMAT).toString());
        this.hour = hour;
        return this;
    }

    public long getMin() {
        return this.min;
    }

    public Interval setMin(long min) {
        Assert.state((-6180646557600L <= min && min <= 6180646557600L ? 1 : 0) != 0, (String)threadLocalStringBuilder.get().delete(0, threadLocalStringBuilder.get().length()).append(VALUE_BOUND_FORMAT).append(min).append(MIN_BOUND_FORMAT).toString());
        this.min = min;
        return this;
    }

    public long getSec() {
        return this.sec;
    }

    public Interval setSec(long sec) {
        Assert.state((-370838793456000L <= sec && sec <= 370838793456000L ? 1 : 0) != 0, (String)threadLocalStringBuilder.get().delete(0, threadLocalStringBuilder.get().length()).append(VALUE_BOUND_FORMAT).append(sec).append(SEC_BOUND_FORMAT).toString());
        this.sec = sec;
        return this;
    }

    public long getNsec() {
        return this.nsec;
    }

    public Interval setNsec(long nsec) {
        Assert.state((-2147483647L <= nsec && nsec <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)threadLocalStringBuilder.get().delete(0, threadLocalStringBuilder.get().length()).append(VALUE_BOUND_FORMAT).append(nsec).append(NSEC_BOUND_FORMAT).toString());
        this.nsec = nsec;
        return this;
    }

    public Adjust getAdjust() {
        return this.adjust;
    }

    public Interval setAdjust(Adjust adjust) {
        this.adjust = adjust;
        return this;
    }

    public int hashCode() {
        int result = (int)(this.year ^ this.year >>> 32);
        result = 31 * result + (int)(this.month ^ this.month >>> 32);
        result = 31 * result + (int)(this.week ^ this.week >>> 32);
        result = 31 * result + (int)(this.day ^ this.day >>> 32);
        result = 31 * result + (int)(this.hour ^ this.hour >>> 32);
        result = 31 * result + (int)(this.min ^ this.min >>> 32);
        result = 31 * result + (int)(this.sec ^ this.sec >>> 32);
        result = 31 * result + (int)(this.nsec ^ this.nsec >>> 32);
        result = 31 * result + this.adjust.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interval interval = (Interval)o;
        if (this.year != interval.year) {
            return false;
        }
        if (this.month != interval.month) {
            return false;
        }
        if (this.week != interval.week) {
            return false;
        }
        if (this.day != interval.day) {
            return false;
        }
        if (this.hour != interval.hour) {
            return false;
        }
        if (this.min != interval.min) {
            return false;
        }
        if (this.sec != interval.sec) {
            return false;
        }
        if (this.nsec != interval.nsec) {
            return false;
        }
        return this.adjust == interval.adjust;
    }

    public String toString() {
        StringBuilder sb = threadLocalStringBuilder.get();
        sb.delete(0, sb.length());
        sb.append("Interval{");
        sb.append("year=").append(this.year);
        sb.append(", month=").append(this.month);
        sb.append(", week=").append(this.week);
        sb.append(", day=").append(this.day);
        sb.append(", hour=").append(this.hour);
        sb.append(", min=").append(this.min);
        sb.append(", sec=").append(this.sec);
        sb.append(", nsec=").append(this.nsec);
        sb.append(", adjust=").append((Object)this.adjust);
        sb.append('}');
        return sb.toString();
    }

    static {
        SUPPORTED_UNITS = Collections.unmodifiableList(Arrays.asList(ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.WEEKS, ChronoUnit.DAYS, ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS, ChronoUnit.NANOS));
        threadLocalStringBuilder = ThreadLocal.withInitial(StringBuilder::new);
        VALUE_BOUND_FORMAT = "Value ";
        YEARS_BOUND_FORMAT = " of year is out of allowed range [-11759221, 11759221]";
        MOTH_BOUND_FORMAT = " of month is out of allowed range [-141110652, 141110652]";
        WEEK_BOUND_FORMAT = " of week is out of allowed range [-611479492, 611479492]";
        DAY_BOUND_FORMAT = " of day is out of allowed range [-4292115665, 4292115665]";
        HOUR_BOUND_FORMAT = " of hour is out of allowed range [-103010775960, 103010775960]";
        MIN_BOUND_FORMAT = " of min is out of allowed range [-6180646557600, 6180646557600]";
        SEC_BOUND_FORMAT = " of sec is out of allowed range [-370838793456000, 370838793456000]";
        NSEC_BOUND_FORMAT = " of nsec is out of allowed range [-2147483647, 2147483647]";
    }
}

