/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.mapping;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.tarantool.core.protocol.ByteBodyValueWrapper;
import io.tarantool.core.protocol.IProtoResponse;
import io.tarantool.mapping.DatetimeExtensionModule;
import io.tarantool.mapping.DecimalExtensionModule;
import io.tarantool.mapping.FormatsModule;
import io.tarantool.mapping.IntervalExtensionModule;
import io.tarantool.mapping.JacksonMappingException;
import io.tarantool.mapping.Tuple;
import io.tarantool.mapping.TupleExtensionModule;
import io.tarantool.mapping.UUIDExtensionModule;
import io.tarantool.mapping.UniversalExtensionModule;
import java.io.IOException;
import java.util.List;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class BaseTarantoolJacksonMapping {
    public static final MessagePackFactory mpFactory = new MessagePackFactory();
    public static final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)mpFactory).registerModule((Module)DatetimeExtensionModule.INSTANCE).registerModule((Module)DecimalExtensionModule.INSTANCE).registerModule((Module)IntervalExtensionModule.INSTANCE).registerModule((Module)TupleExtensionModule.INSTANCE).registerModule((Module)UUIDExtensionModule.INSTANCE).registerModule((Module)UniversalExtensionModule.INSTANCE);
    public static final TypeFactory typeFactory = objectMapper.getTypeFactory();
    public static final CollectionType LIST_TUPLE = typeFactory.constructCollectionType(List.class, Tuple.class);
    public static final CollectionType LIST_TUPLE_LIST = typeFactory.constructCollectionType(List.class, typeFactory.constructParametricType(Tuple.class, new Class[]{List.class}));
    public static final ObjectMapper objectMapperWithMessagePackKeySerializer = new ObjectMapper((JsonFactory)mpFactory).registerModule((Module)DatetimeExtensionModule.INSTANCE).registerModule((Module)DecimalExtensionModule.INSTANCE).registerModule((Module)IntervalExtensionModule.INSTANCE).registerModule((Module)TupleExtensionModule.INSTANCE).registerModule((Module)UUIDExtensionModule.INSTANCE).registerModule((Module)UniversalExtensionModule.INSTANCE).registerModule((Module)FormatsModule.INSTANCE);
    public static final MessagePackFactory innerMpFactory = new MessagePackFactory().setReuseResourceInParser(false).setReuseResourceInGenerator(false);
    public static final ObjectMapper innerObjectMapper = new ObjectMapper((JsonFactory)innerMpFactory).registerModule((Module)DecimalExtensionModule.INSTANCE).registerModule((Module)UUIDExtensionModule.INSTANCE).registerModule((Module)DatetimeExtensionModule.INSTANCE).registerModule((Module)IntervalExtensionModule.INSTANCE).registerModule((Module)TupleExtensionModule.INSTANCE).registerModule((Module)UniversalExtensionModule.INSTANCE);

    public static Object readData(IProtoResponse response) {
        return BaseTarantoolJacksonMapping.readValue(response.getByteBodyValue(48));
    }

    public static Object readEventData(IProtoResponse response) {
        return BaseTarantoolJacksonMapping.readValue(response.getByteBodyValue(88));
    }

    public static Object readValue(ByteBodyValueWrapper byteBodyValueWrapper) {
        try {
            return objectMapper.readValue(byteBodyValueWrapper.getPacket(), byteBodyValueWrapper.getOffset(), byteBodyValueWrapper.getValueLength(), Object.class);
        }
        catch (IOException e) {
            throw new JacksonMappingException(e);
        }
    }

    public static <T> T readData(IProtoResponse response, Class<T> entity) {
        return BaseTarantoolJacksonMapping.readValue(response.getByteBodyValue(48), entity);
    }

    public static <T> T readEventData(IProtoResponse response, Class<T> entity) {
        return BaseTarantoolJacksonMapping.readValue(response.getByteBodyValue(88), entity);
    }

    public static <T> T readValue(ByteBodyValueWrapper byteBodyValueWrapper, Class<T> entity) {
        try {
            return (T)objectMapper.readValue(byteBodyValueWrapper.getPacket(), byteBodyValueWrapper.getOffset(), byteBodyValueWrapper.getValueLength(), entity);
        }
        catch (IOException e) {
            throw new JacksonMappingException(e);
        }
    }

    public static <T> T readData(IProtoResponse response, TypeReference<T> entity) {
        return BaseTarantoolJacksonMapping.readValue(response.getByteBodyValue(48), entity);
    }

    public static <T> T readEventData(IProtoResponse response, TypeReference<T> entity) {
        return BaseTarantoolJacksonMapping.readValue(response.getByteBodyValue(88), entity);
    }

    public static <T> T readValue(ByteBodyValueWrapper byteBodyValueWrapper, TypeReference<T> entity) {
        try {
            return (T)objectMapper.readValue(byteBodyValueWrapper.getPacket(), byteBodyValueWrapper.getOffset(), byteBodyValueWrapper.getValueLength(), entity);
        }
        catch (IOException e) {
            throw new JacksonMappingException(e);
        }
    }

    public static <T> T readData(IProtoResponse response, JavaType entity) {
        return BaseTarantoolJacksonMapping.readValue(response.getByteBodyValue(48), entity);
    }

    public static <T> T readValue(ByteBodyValueWrapper byteBodyValueWrapper, JavaType entity) {
        try {
            return (T)objectMapper.readValue(byteBodyValueWrapper.getPacket(), byteBodyValueWrapper.getOffset(), byteBodyValueWrapper.getValueLength(), entity);
        }
        catch (IOException e) {
            throw new JacksonMappingException(e);
        }
    }

    public static <T> T readValueAux(ByteBodyValueWrapper byteBodyValueWrapper, JavaType entity) {
        try {
            return (T)innerObjectMapper.readValue(byteBodyValueWrapper.getPacket(), byteBodyValueWrapper.getOffset(), byteBodyValueWrapper.getValueLength(), entity);
        }
        catch (IOException e) {
            throw new JacksonMappingException(e);
        }
    }

    public static byte[] toValue(Object object) {
        try {
            return objectMapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new JacksonMappingException(e);
        }
    }

    public static byte[] toValueWithKeySerializer(Object object) {
        try {
            return objectMapperWithMessagePackKeySerializer.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new JacksonMappingException(e);
        }
    }

    public static byte[] toValueAux(Object object) {
        try {
            return innerObjectMapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new JacksonMappingException(e);
        }
    }

    public static <T, E> JavaType wrapIntoType(Class<E> externalType, TypeReference<T> internalType) {
        return BaseTarantoolJacksonMapping.wrapIntoType(externalType, objectMapper.constructType(internalType));
    }

    public static <T, E> JavaType wrapIntoType(Class<E> externalType, Class<T> internalType) {
        return BaseTarantoolJacksonMapping.wrapIntoType(externalType, typeFactory.constructType(internalType));
    }

    public static <E> JavaType wrapIntoType(Class<E> externalType, JavaType internalType) {
        return typeFactory.constructParametricType(externalType, new JavaType[]{internalType});
    }

    public static <T> JavaType wrapIntoList(TypeReference<T> internalType) {
        return BaseTarantoolJacksonMapping.wrapIntoType(List.class, internalType);
    }

    public static <T> JavaType wrapIntoList(JavaType internalType) {
        return BaseTarantoolJacksonMapping.wrapIntoType(List.class, internalType);
    }

    public static <T> JavaType wrapIntoList(Class<T> internalType) {
        return BaseTarantoolJacksonMapping.wrapIntoType(List.class, internalType);
    }

    public static <T> JavaType wrapIntoTuple(TypeReference<T> internalType) {
        return BaseTarantoolJacksonMapping.wrapIntoType(Tuple.class, internalType);
    }

    public static <T> JavaType wrapIntoTuple(JavaType internalType) {
        return BaseTarantoolJacksonMapping.wrapIntoType(Tuple.class, internalType);
    }

    public static <T> JavaType wrapIntoTuple(Class<T> internalType) {
        return BaseTarantoolJacksonMapping.wrapIntoType(Tuple.class, internalType);
    }

    public static Tuple<List<?>> getFirstOrNullForReturnAsList(List<Tuple<List<?>>> multiReturnResultList) throws JacksonMappingException {
        if (multiReturnResultList == null || multiReturnResultList.isEmpty()) {
            return null;
        }
        if (multiReturnResultList.size() == 1) {
            return multiReturnResultList.get(0);
        }
        throw new JacksonMappingException("This method should return one tuple or null, but it returned " + multiReturnResultList.size());
    }

    public static <T> T getFirstOrNullForReturnAsClass(List<T> multiReturnResultList) throws JacksonMappingException {
        if (multiReturnResultList == null || multiReturnResultList.isEmpty()) {
            return null;
        }
        if (multiReturnResultList.size() == 1) {
            return multiReturnResultList.get(0);
        }
        throw new JacksonMappingException("This method should return one tuple or null, but it returned " + multiReturnResultList.size());
    }
}

