/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data32.core.mapping;

import io.tarantool.spring.data32.core.mapping.Identifier;
import io.tarantool.spring.data32.core.mapping.KeyValueCompositePersistentEntity;
import io.tarantool.spring.data32.core.mapping.KeyValueCompositeProperty;
import io.tarantool.spring.data32.core.mapping.model.CompositeIdPropertyAccessor;
import io.tarantool.spring.data32.core.mapping.model.PersistentCompositeIdIsNewStrategy;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Persistable;
import org.springframework.data.keyvalue.core.mapping.BasicKeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class BasicKeyValueCompositePersistentEntity<T, P extends KeyValueCompositeProperty<P>>
extends BasicKeyValuePersistentEntity<T, P>
implements KeyValueCompositePersistentEntity<T, P> {
    public static final String TYPE_MISMATCH = "Target bean of type %s is not of type of the persistent entity (%s)";
    private final Class<?> idClassTypeValue;
    @Nullable
    private P idProperty;
    private Map<Field, Field> entityIdClassFields;

    public BasicKeyValueCompositePersistentEntity(TypeInformation<T> information, @Nullable KeySpaceResolver fallbackKeySpaceResolver, Class<?> idClassTypeValue) {
        super(information, fallbackKeySpaceResolver);
        Assert.notNull(idClassTypeValue, (String)"idClassTypeValue must be not null for this class!");
        this.idClassTypeValue = idClassTypeValue;
    }

    public IdentifierAccessor getIdentifierAccessor(Object bean) {
        this.verifyBeanType(bean);
        if (Persistable.class.isAssignableFrom(this.getType())) {
            throw new IllegalArgumentException("Persistable override is not currently supported for entities with a composite key.");
        }
        return this.hasIdProperty() ? new CompositeIdPropertyAccessor(bean, this.entityIdClassFields, this.getIdClassType()) : new AbsentIdentifierAccessor();
    }

    @Override
    public Class<?> getIdClassType() {
        return this.idClassTypeValue;
    }

    public void verify() {
        super.verify();
        if (this.idProperty != null) {
            this.entityIdClassFields = KeyPartTypeChecker.getFieldMapIfTypesValid(this, this.idProperty);
        }
    }

    protected IsNewStrategy getFallbackIsNewStrategy() {
        return PersistentCompositeIdIsNewStrategy.of(this);
    }

    protected P returnPropertyIfBetterIdPropertyCandidateOrNull(P property) {
        Assert.isInstanceOf(Identifier.class, property, (String)"property must be Identifier for this class");
        if (!property.isIdProperty()) {
            return null;
        }
        if (this.idProperty == null) {
            this.idProperty = property;
            return this.idProperty;
        }
        ((KeyValueCompositeProperty)this.idProperty).addPart(property);
        return this.idProperty;
    }

    private void verifyBeanType(Object bean) {
        Assert.notNull((Object)bean, (String)"Target bean must not be null");
        Assert.isInstanceOf((Class)this.getType(), (Object)bean, () -> String.format(TYPE_MISMATCH, bean.getClass().getName(), this.getType().getName()));
    }

    private static class AbsentIdentifierAccessor
    implements IdentifierAccessor {
        private AbsentIdentifierAccessor() {
        }

        @Nullable
        public Object getIdentifier() {
            return null;
        }
    }

    public static class KeyPartTypeChecker {
        public static final String COMPOSITE_KEY_FIELDS_NUMBER_EXCEPTION = "Number of fields specified in domain class and composite class the key is different!";
        public static final String COMPOSITE_KEY_FIELD_DIFFERENT_EXCEPTION = "Domain class fields marked with @Id differ from fields specified in the composite key class";

        public static Map<Field, Field> getFieldMapIfTypesValid(KeyValueCompositePersistentEntity<?, ?> persistentEntity, Identifier<?> idProperty) {
            HashMap<Field, Field> entityIdClassFields = new HashMap<Field, Field>();
            List<Field> compositeKeyFields = persistentEntity.getIdClassTypeFields();
            Field[] entityFields = idProperty.getFields();
            if (compositeKeyFields.size() != entityFields.length) {
                throw new IllegalArgumentException(COMPOSITE_KEY_FIELDS_NUMBER_EXCEPTION);
            }
            for (int i = 0; i < compositeKeyFields.size(); ++i) {
                Field entityField;
                Field compositeKeyField = compositeKeyFields.get(i);
                if (!KeyPartTypeChecker.equalFields(compositeKeyField, entityField = entityFields[i])) {
                    throw new IllegalArgumentException(COMPOSITE_KEY_FIELD_DIFFERENT_EXCEPTION);
                }
                entityIdClassFields.put(entityField, compositeKeyField);
            }
            return entityIdClassFields;
        }

        private static boolean equalFields(Field firstField, Field secondField) {
            return firstField.getName().equals(secondField.getName()) && firstField.getType().equals(secondField.getType());
        }
    }
}

