/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.pool;

import io.netty.handler.flush.FlushConsolidationHandler;
import io.tarantool.core.protocol.requests.IProtoAuth;
import java.net.InetSocketAddress;

public final class InstanceConnectionGroup {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 3301;
    public static final int DEFAULT_CONNECTION_NUMBER = 1;
    private final String host;
    private final int port;
    private final int size;
    private final String user;
    private final String password;
    private final IProtoAuth.AuthType authType;
    private final InetSocketAddress address;
    private final FlushConsolidationHandler flushConsolidationHandler;
    private String tag;

    private InstanceConnectionGroup(String host, int port, int size, String tag, String user, String password, IProtoAuth.AuthType authType, FlushConsolidationHandler flushConsolidationHandler) throws IllegalArgumentException {
        if (user != null && user.equals("guest")) {
            user = null;
        }
        if (user == null && password != null) {
            throw new IllegalArgumentException("password for guest should be empty");
        }
        this.port = port;
        this.user = user;
        this.authType = authType;
        this.size = size;
        this.host = host;
        this.password = password;
        this.tag = tag;
        this.address = new InetSocketAddress(host, port);
        this.flushConsolidationHandler = flushConsolidationHandler;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getSize() {
        return this.size;
    }

    public String getTag() {
        if (this.tag == null) {
            String newTag;
            if (this.user == null) {
                String newTag2;
                this.tag = newTag2 = "guest:" + this.host + ":" + this.port;
                return this.tag;
            }
            this.tag = newTag = this.user + ":" + this.host + ":" + this.port;
            return this.tag;
        }
        return this.tag;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public IProtoAuth.AuthType getAuthType() {
        return this.authType;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public FlushConsolidationHandler getFlushConsolidationHandler() {
        return this.flushConsolidationHandler;
    }

    public static class Builder {
        private String host = "localhost";
        private int port = 3301;
        private int size = 1;
        private String tag;
        private String user;
        private String password;
        private IProtoAuth.AuthType authType = IProtoAuth.DEFAULT_AUTH_TYPE;
        private FlushConsolidationHandler flushConsolidationHandler;

        private Builder() {
        }

        public Builder withHost(String host) {
            if (host == null || host.trim().isEmpty()) {
                return this;
            }
            this.host = host;
            return this;
        }

        public Builder withPort(int port) throws IllegalArgumentException {
            if (port < 0 || port > 65535) {
                throw new IllegalArgumentException("port value should be from 0 to 65535");
            }
            this.port = port;
            return this;
        }

        public Builder withSize(int size) throws IllegalArgumentException {
            if (size <= 0) {
                throw new IllegalArgumentException("size should be greater 0");
            }
            this.size = size;
            return this;
        }

        public Builder withTag(String tag) {
            if (tag == null || tag.trim().isEmpty()) {
                return this;
            }
            this.tag = tag;
            return this;
        }

        public Builder withUser(String user) {
            if (user == null || user.trim().isEmpty()) {
                return this;
            }
            this.user = user;
            return this;
        }

        public Builder withPassword(String password) {
            if (password == null) {
                return this;
            }
            this.password = password;
            return this;
        }

        public Builder withAuthType(IProtoAuth.AuthType authType) {
            if (authType == null) {
                return this;
            }
            this.authType = authType;
            return this;
        }

        public Builder withFlushConsolidationHandler(FlushConsolidationHandler flushConsolidationHandler) {
            this.flushConsolidationHandler = flushConsolidationHandler;
            return this;
        }

        public InstanceConnectionGroup build() {
            return new InstanceConnectionGroup(this.host, this.port, this.size, this.tag, this.user, this.password, this.authType, this.flushConsolidationHandler);
        }
    }
}

