/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.pool;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.util.Timer;
import io.tarantool.core.IProtoClient;
import io.tarantool.core.WatcherOptions;
import io.tarantool.core.connection.ConnectionFactory;
import io.tarantool.core.protocol.IProtoResponse;
import io.tarantool.pool.HeartbeatOpts;
import io.tarantool.pool.IProtoClientPool;
import io.tarantool.pool.InstanceConnectionGroup;
import io.tarantool.pool.PoolEntry;
import io.tarantool.pool.TripleConsumer;
import io.tarantool.pool.exceptions.PoolClosedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IProtoClientPoolImpl
implements IProtoClientPool {
    private static final Logger log = LoggerFactory.getLogger(IProtoClientPoolImpl.class);
    private final ConnectionFactory factory;
    private final Map<String, List<PoolEntry>> entries;
    private final Map<String, InstanceConnectionGroup> groups;
    private final Timer timerService;
    private final boolean gracefulShutdown;
    private final HeartbeatOpts heartbeatOpts;
    private final WatcherOptions watcherOpts;
    private final AtomicInteger unavailable;
    private final AtomicInteger reconnecting;
    private final MeterRegistry metricsRegistry;
    private final boolean useTupleExtension;
    private final AtomicBoolean isClosed;
    private volatile StringBuilder stringBuilder;
    private long connectTimeout;
    private long reconnectAfter;
    private int totalSize;
    private Counter requestSuccess;
    private Counter requestErrors;
    private Counter invalidRequests;
    private Counter lockedConnectionRequests;
    private TripleConsumer<String, Integer, IProtoResponse> ignoredPacketsHandler;

    public IProtoClientPoolImpl(ConnectionFactory factory, Timer timerService) {
        this(factory, timerService, true, null, null, null, null, false);
    }

    public IProtoClientPoolImpl(ConnectionFactory factory, Timer timerService, boolean gracefulShutdown) {
        this(factory, timerService, gracefulShutdown, null, null, null, null, false);
    }

    public IProtoClientPoolImpl(ConnectionFactory factory, Timer timerService, boolean gracefulShutdown, HeartbeatOpts heartbeatOpts) {
        this(factory, timerService, gracefulShutdown, heartbeatOpts, null, null, null, false);
    }

    public IProtoClientPoolImpl(ConnectionFactory factory, Timer timerService, boolean gracefulShutdown, HeartbeatOpts heartbeatOpts, WatcherOptions watcherOpts, MeterRegistry metricsRegistry) {
        this(factory, timerService, gracefulShutdown, heartbeatOpts, watcherOpts, metricsRegistry, null, false);
    }

    public IProtoClientPoolImpl(ConnectionFactory factory, Timer timerService, boolean gracefulShutdown, HeartbeatOpts heartbeatOpts, WatcherOptions watcherOpts, MeterRegistry metricsRegistry, TripleConsumer<String, Integer, IProtoResponse> ignoredPacketsHandler, boolean useTupleExtension) {
        this.factory = factory;
        this.entries = new ConcurrentHashMap<String, List<PoolEntry>>();
        this.groups = new ConcurrentHashMap<String, InstanceConnectionGroup>();
        this.timerService = timerService;
        this.connectTimeout = 3000L;
        this.reconnectAfter = 1000L;
        this.isClosed = new AtomicBoolean(false);
        this.gracefulShutdown = gracefulShutdown;
        this.heartbeatOpts = heartbeatOpts;
        this.unavailable = new AtomicInteger(0);
        this.reconnecting = new AtomicInteger(0);
        this.watcherOpts = watcherOpts;
        this.totalSize = 0;
        this.metricsRegistry = metricsRegistry;
        this.ignoredPacketsHandler = ignoredPacketsHandler;
        this.useTupleExtension = useTupleExtension;
        this.initMetrics();
    }

    @Override
    public synchronized void setGroups(List<InstanceConnectionGroup> clientGroups) {
        HashMap<String, Boolean> actualTags = new HashMap<String, Boolean>();
        int newTotal = 0;
        for (InstanceConnectionGroup group : clientGroups) {
            ArrayList<PoolEntry> connects;
            String tag = group.getTag();
            int size = group.getSize();
            actualTags.put(tag, true);
            newTotal += size;
            InstanceConnectionGroup oldGroup = this.groups.put(tag, group);
            if (oldGroup == null) {
                connects = new ArrayList();
                this.entries.put(tag, connects);
            } else {
                connects = this.entries.get(tag);
                if (!oldGroup.getAddress().equals(group.getAddress())) {
                    this.shrinkGroup(connects, 0);
                }
            }
            this.expandGroup(connects, group);
            this.shrinkGroup(connects, size);
        }
        for (String tag : this.groups.keySet()) {
            if (actualTags.containsKey(tag)) continue;
            this.groups.remove(tag);
            this.shrinkGroup(this.entries.remove(tag), 0);
        }
        this.totalSize = newTotal;
    }

    @Override
    public List<String> getTags() {
        ArrayList<String> tags = new ArrayList<String>();
        for (String tag : this.groups.keySet()) {
            tags.add(tag);
        }
        return tags;
    }

    @Override
    public int getGroupSize(String tag) {
        if (!this.groups.containsKey(tag)) {
            this.initStringBuilder();
            IProtoClientPoolImpl iProtoClientPoolImpl = this;
            synchronized (iProtoClientPoolImpl) {
                throw new NoSuchElementException(this.stringBuilder.delete(0, this.stringBuilder.length()).append("can't find connection group with tag ").append(tag).toString());
            }
        }
        return this.groups.get(tag).getSize();
    }

    @Override
    public CompletableFuture<IProtoClient> get(String tag, int index) {
        if (this.isClosed.get()) {
            this.incPoolInvalidRequests();
            throw new PoolClosedException("pool is closed");
        }
        if (!this.groups.containsKey(tag)) {
            this.incPoolInvalidRequests();
            this.initStringBuilder();
            IProtoClientPoolImpl iProtoClientPoolImpl = this;
            synchronized (iProtoClientPoolImpl) {
                throw new NoSuchElementException(this.stringBuilder.delete(0, this.stringBuilder.length()).append("can't find connection group with tag ").append(tag).toString());
            }
        }
        try {
            PoolEntry entry = this.entries.get(tag).get(index);
            if (entry.isLocked()) {
                this.incPoolLockedConnectionRequests();
                return null;
            }
            CompletableFuture<IProtoClient> future = entry.connect();
            future.whenComplete(this::incPoolRequestCounters);
            return future;
        }
        catch (IndexOutOfBoundsException e) {
            this.incPoolInvalidRequests();
            this.initStringBuilder();
            IProtoClientPoolImpl iProtoClientPoolImpl = this;
            synchronized (iProtoClientPoolImpl) {
                throw new IndexOutOfBoundsException(this.stringBuilder.delete(0, this.stringBuilder.length()).append("group: ").append(tag).append(", index: ").append(index).toString());
            }
        }
    }

    @Override
    public void close() throws Exception {
        if (this.isClosed.compareAndSet(false, true)) {
            log.debug("Thread closes connection");
            this.entries.forEach((? super K tag, ? super V entryGroup) -> entryGroup.forEach(PoolEntry::close));
            this.entries.clear();
            this.timerService.stop();
            log.info("close pool");
        }
    }

    @Override
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(long timeout) throws IllegalArgumentException {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("timeout should be positive number");
        }
        this.entries.forEach((? super K tag, ? super V entryGroup) -> entryGroup.forEach((? super T pe) -> pe.setConnectTimeout(timeout)));
        this.connectTimeout = timeout;
    }

    @Override
    public boolean hasAvailableClients() {
        return this.unavailable.get() < this.totalSize;
    }

    @Override
    public int availableConnections() {
        return this.totalSize - this.unavailable.get();
    }

    @Override
    public long getReconnectAfter() {
        return this.reconnectAfter;
    }

    @Override
    public void setReconnectAfter(long reconnectAfter) throws IllegalArgumentException {
        if (reconnectAfter <= 0L) {
            throw new IllegalArgumentException("reconnect period should be positive number");
        }
        this.reconnectAfter = reconnectAfter;
    }

    @Override
    public void forEach(Consumer<IProtoClient> action) {
        for (List<PoolEntry> group : this.entries.values()) {
            for (PoolEntry entry : group) {
                action.accept(entry.getClient());
            }
        }
    }

    private void expandGroup(List<PoolEntry> connects, InstanceConnectionGroup group) {
        log.info("create new connections: group {}", (Object)group.getTag());
        while (connects.size() < group.getSize()) {
            connects.add(new PoolEntry(this.factory, this.timerService, group, connects.size(), this.gracefulShutdown, this.connectTimeout, this.reconnectAfter, this.heartbeatOpts, this.watcherOpts, this.unavailable, this.reconnecting, this.metricsRegistry, this.ignoredPacketsHandler, this.useTupleExtension));
        }
    }

    private void shrinkGroup(List<PoolEntry> connects, int count) {
        log.info("close connections");
        while (connects.size() > count) {
            PoolEntry entry = connects.remove(connects.size() - 1);
            entry.unlock();
            entry.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStringBuilder() {
        if (this.stringBuilder == null) {
            IProtoClientPoolImpl iProtoClientPoolImpl = this;
            synchronized (iProtoClientPoolImpl) {
                if (this.stringBuilder == null) {
                    this.stringBuilder = new StringBuilder();
                }
            }
        }
    }

    private void initMetrics() {
        if (this.metricsRegistry == null) {
            return;
        }
        Gauge.builder((String)"pool.size", () -> this.totalSize).description("total number of connections at the moment").register(this.metricsRegistry);
        Gauge.builder((String)"pool.available", () -> this.totalSize - this.unavailable.get()).description("total number of connections available at the moment").register(this.metricsRegistry);
        Gauge.builder((String)"pool.invalidated", () -> this.unavailable.get() - this.reconnecting.get()).description("number of connections unavailable at the moment").register(this.metricsRegistry);
        Gauge.builder((String)"pool.reconnecting", () -> this.reconnecting.get()).description("number of connections reconnecting at the moment").register(this.metricsRegistry);
        Counter.builder((String)"pool.connect.success").description("count of succeeded connects").register(this.metricsRegistry);
        Counter.builder((String)"pool.connect.errors").description("count of connect failures").register(this.metricsRegistry);
        LongTaskTimer.builder((String)"pool.connect.time").description("time of connects").register(this.metricsRegistry);
        this.requestSuccess = Counter.builder((String)"pool.request.success").description("Count of successfule connections requests from pool").register(this.metricsRegistry);
        this.requestErrors = Counter.builder((String)"pool.request.errors").description("Count of failed connection requests from pool").register(this.metricsRegistry);
        this.invalidRequests = Counter.builder((String)"pool.request.misses").description("Count of connection requests with wrong tag or index").register(this.metricsRegistry);
        this.lockedConnectionRequests = Counter.builder((String)"pool.request.unavail").description("Count of connection request finished with locked connect").register(this.metricsRegistry);
        Counter.builder((String)"pool.heartbeat.success").description("Count of successful heartbeat ping requests").register(this.metricsRegistry);
        Counter.builder((String)"pool.heartbeat.errors").description("Count of failed heartbeat ping requests").register(this.metricsRegistry);
        LongTaskTimer.builder((String)"pool.heartbeat.time").description("Time of ping request").register(this.metricsRegistry);
    }

    private void incPoolRequestCounters(Object r, Throwable e) {
        if (this.requestSuccess == null || this.requestErrors == null) {
            return;
        }
        if (e == null) {
            this.requestSuccess.increment();
        } else {
            this.requestErrors.increment();
        }
    }

    private void incPoolInvalidRequests() {
        if (this.invalidRequests == null) {
            return;
        }
        this.invalidRequests.increment();
    }

    private void incPoolLockedConnectionRequests() {
        if (this.lockedConnectionRequests == null) {
            return;
        }
        this.lockedConnectionRequests.increment();
    }

    @Override
    public ConnectionFactory getFactory() {
        return this.factory;
    }
}

