/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.pool;

import io.tarantool.core.IProtoClient;
import io.tarantool.core.protocol.IProtoRequestOpts;
import io.tarantool.core.protocol.IProtoResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.ValueFactory;

public final class HeartbeatOpts {
    public static final long DEFAULT_PING_INTERVAL = 3000L;
    public static final int DEFAULT_INVALIDATION_THRESHOLD = 2;
    public static final int DEFAULT_WINDOW_SIZE = 4;
    public static final int DEFAULT_DEATH_THRESHOLD = 4;
    private long pingInterval = 3000L;
    private int invalidationThreshold = 2;
    private int windowSize = 4;
    private int deathThreshold = 4;
    private BiFunction<IProtoClient, IProtoRequestOpts, CompletableFuture<IProtoResponse>> pingFunction = IProtoClient::ping;

    public static HeartbeatOpts getDefault() {
        return new HeartbeatOpts();
    }

    private HeartbeatOpts() {
    }

    public HeartbeatOpts withPingInterval(long interval) {
        if (interval <= 0L) {
            throw new IllegalArgumentException("ping interval should positive number");
        }
        this.pingInterval = interval;
        return this;
    }

    public HeartbeatOpts withInvalidationThreshold(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("a count of failed pings should be more than 0");
        }
        this.invalidationThreshold = count;
        return this;
    }

    public HeartbeatOpts withDeathThreshold(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count of death pings should be positive number");
        }
        this.deathThreshold = count;
        return this;
    }

    public HeartbeatOpts withWindowSize(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("count of death pings should be positive number");
        }
        this.windowSize = count;
        return this;
    }

    public HeartbeatOpts withCrudHealthCheck() {
        return this.withPingFunction((client, heartbeatPingOpts) -> client.eval("return rawget(_G, 'crud') ~= nil", (ArrayValue)ValueFactory.emptyArray(), heartbeatPingOpts));
    }

    public HeartbeatOpts withPingFunction(BiFunction<IProtoClient, IProtoRequestOpts, CompletableFuture<IProtoResponse>> pingFunction) {
        this.pingFunction = pingFunction;
        return this;
    }

    public long getPingInterval() {
        return this.pingInterval;
    }

    public int getInvalidationThreshold() {
        return this.invalidationThreshold;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int getDeathThreshold() {
        return this.deathThreshold;
    }

    public BiFunction<IProtoClient, IProtoRequestOpts, CompletableFuture<IProtoResponse>> getPingFunction() {
        return this.pingFunction;
    }
}

