/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.schema;

import com.fasterxml.jackson.core.type.TypeReference;
import io.tarantool.balancer.TarantoolBalancer;
import io.tarantool.core.protocol.BoxIterator;
import io.tarantool.core.protocol.IProtoResponse;
import io.tarantool.mapping.TarantoolJacksonMapping;
import io.tarantool.mapping.Tuple;
import io.tarantool.schema.Index;
import io.tarantool.schema.NoSchemaException;
import io.tarantool.schema.SchemaFetchingException;
import io.tarantool.schema.Space;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.ValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarantoolSchemaFetcher {
    static final Logger log = LoggerFactory.getLogger(TarantoolSchemaFetcher.class);
    private static final int BOX_VSPACE_ID = 281;
    private static final int BOX_VINDEX_ID = 289;
    public static final int PRIMARY = 0;
    private static final int SPACE_MAX = 65000;
    private static final int SPACE_INDEX_MAX = 128;
    private static final int INDEX_MAX = 8320000;
    private static final int OFFSET = 0;
    private static final BoxIterator ITERATOR = BoxIterator.EQ;
    public static final TypeReference<List<Tuple<Space>>> LIST_TUPLE_SPACE = new TypeReference<List<Tuple<Space>>>(){};
    public static final TypeReference<List<Tuple<Index>>> LIST_TUPLE_INDEX = new TypeReference<List<Tuple<Index>>>(){};
    private final TarantoolBalancer balancer;
    private final boolean ignoreOldSchemaVersion;
    private Long schemaVersion;
    private final Map<String, Space> spaceHolderByName;
    private final Map<Integer, Space> spaceHolderById;

    public TarantoolSchemaFetcher(TarantoolBalancer balancer, boolean ignoreOldSchemaVersion) {
        this.balancer = balancer;
        this.schemaVersion = 0L;
        this.spaceHolderByName = new HashMap<String, Space>();
        this.spaceHolderById = new HashMap<Integer, Space>();
        this.ignoreOldSchemaVersion = ignoreOldSchemaVersion;
        this.fetchSchema();
    }

    public CompletableFuture<IProtoResponse> processRequest(CompletableFuture<IProtoResponse> request) {
        return request.thenCompose(requestResponse -> {
            Long responseSchemaVersion = requestResponse.getSchemaVersion();
            if (responseSchemaVersion.equals(this.schemaVersion)) {
                return CompletableFuture.completedFuture(requestResponse);
            }
            if (responseSchemaVersion < this.schemaVersion) {
                log.error("Response has older schema version than client has");
                if (this.ignoreOldSchemaVersion) {
                    return CompletableFuture.completedFuture(requestResponse);
                }
                throw new SchemaFetchingException("Response has older schema version than client has");
            }
            return this.vspaceSelect().thenCombine(this.vindexSelect(), (schemaResponse, indexesResponse) -> {
                this.updateSchema((List)TarantoolJacksonMapping.readResponse((IProtoResponse)schemaResponse, LIST_TUPLE_SPACE).get(), (List)TarantoolJacksonMapping.readResponse((IProtoResponse)indexesResponse, LIST_TUPLE_INDEX).get());
                long newSchemaVersion = schemaResponse.getSchemaVersion();
                if (newSchemaVersion > this.schemaVersion) {
                    this.schemaVersion = newSchemaVersion;
                }
                return requestResponse;
            });
        });
    }

    public void updateSchema(List<Tuple<Space>> spaces, List<Tuple<Index>> indexes) {
        int i = 0;
        int indexesSize = indexes.size();
        for (Tuple<Space> tuple : spaces) {
            Space space = (Space)tuple.get();
            int spaceId = space.getId();
            while (i < indexesSize && ((Index)indexes.get(i).get()).getSpaceId() <= spaceId) {
                Index index = (Index)indexes.get(i).get();
                if (index.getSpaceId() == spaceId) {
                    space.addIndex(index);
                }
                ++i;
            }
            this.spaceHolderById.put(space.getId(), space);
            this.spaceHolderByName.put(space.getName(), space);
        }
    }

    public void fetchSchema() {
        CompletableFuture<IProtoResponse> vspaceRequest = this.vspaceSelect();
        CompletableFuture<IProtoResponse> vindexRequest = this.vindexSelect();
        CompletableFuture.allOf(vspaceRequest, vindexRequest).join();
        IProtoResponse vspaceRequestResponse = vspaceRequest.join();
        IProtoResponse vindexRequestResponse = vindexRequest.join();
        List spaces = (List)TarantoolJacksonMapping.readResponse((IProtoResponse)vspaceRequestResponse, LIST_TUPLE_SPACE).get();
        List indexes = (List)TarantoolJacksonMapping.readResponse((IProtoResponse)vindexRequestResponse, LIST_TUPLE_INDEX).get();
        this.updateSchema(spaces, indexes);
        this.schemaVersion = vspaceRequestResponse.getSchemaVersion();
    }

    private CompletableFuture<IProtoResponse> vspaceSelect() {
        return this.balancer.getNext().thenCompose(c -> c.select(281, 0, (ArrayValue)ValueFactory.emptyArray(), 65000, 0, ITERATOR));
    }

    private CompletableFuture<IProtoResponse> vindexSelect() {
        return this.balancer.getNext().thenCompose(c -> c.select(289, 0, (ArrayValue)ValueFactory.emptyArray(), 8320000, 0, ITERATOR));
    }

    public Space getSpace(String spaceName) {
        Space space = this.spaceHolderByName.get(spaceName);
        if (space == null) {
            this.fetchSchema();
            space = this.spaceHolderByName.get(spaceName);
            if (space == null) {
                throw new NoSchemaException("No schema for space: " + spaceName);
            }
        }
        return space;
    }

    public Space getSpace(Integer id) {
        Space space = this.spaceHolderById.get(id);
        if (space == null) {
            this.fetchSchema();
            space = this.spaceHolderById.get(id);
            if (space == null) {
                throw new NoSchemaException("No schema for space: " + id);
            }
        }
        return space;
    }

    public Long getSchemaVersion() {
        return this.schemaVersion;
    }
}

