/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol.requests;

import io.tarantool.core.protocol.requests.IProtoBaseRequest;
import io.tarantool.core.protocol.requests.IProtoConstant;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class IProtoUpsert
extends IProtoBaseRequest {
    private final Integer spaceId;
    private final int indexBase;
    private final String spaceName;
    private ArrayValue tuple;
    private ArrayValue operations;
    private byte[] rawTuple;
    private byte[] rawOperations;

    public IProtoUpsert(Integer spaceId, String spaceName, int indexBase, ArrayValue tuple, ArrayValue operations, Long streamId) {
        this.spaceId = spaceId;
        this.indexBase = indexBase;
        this.spaceName = spaceName;
        this.tuple = tuple;
        this.operations = operations;
        this.setStreamId(streamId);
    }

    public IProtoUpsert(Integer spaceId, String spaceName, int indexBase, byte[] tuple, byte[] operations, Long streamId) {
        this.spaceId = spaceId;
        this.indexBase = indexBase;
        this.spaceName = spaceName;
        this.rawTuple = tuple;
        this.rawOperations = operations;
        this.setStreamId(streamId);
    }

    @Override
    protected byte[] getRequestTypeRaw() {
        return IProtoConstant.RAW_IPROTO_TYPE_UPSERT;
    }

    @Override
    public byte[] getPacket(MessageBufferPacker packer) throws IOException {
        this.preparePacker(packer);
        packer.addPayload(IProtoConstant.RAW_MAP_HEADER_WITH_FOUR_ITEMS);
        if (this.spaceId != null) {
            packer.addPayload(IProtoConstant.RAW_IPROTO_SPACE_ID);
            packer.packInt(this.spaceId.intValue());
        } else {
            packer.addPayload(IProtoConstant.RAW_IPROTO_SPACE_NAME);
            packer.packString(this.spaceName);
        }
        packer.addPayload(IProtoConstant.RAW_IPROTO_INDEX_BASE);
        packer.packInt(this.indexBase);
        packer.addPayload(IProtoConstant.RAW_IPROTO_TUPLE);
        this.packValue(packer, this.rawTuple, (Value)this.tuple);
        packer.addPayload(IProtoConstant.RAW_IPROTO_OPS);
        this.packValue(packer, this.rawOperations, (Value)this.operations);
        return this.getPacketFromBase(packer);
    }

    @Override
    public MapValue getBody() throws Exception {
        HashMap<Value, Object> map = new HashMap<Value, Object>();
        map.put(IProtoConstant.MP_IPROTO_SPACE_ID, ValueFactory.newInteger((int)this.spaceId));
        map.put(IProtoConstant.MP_IPROTO_SPACE_NAME, ValueFactory.newString((String)this.spaceName));
        map.put(IProtoConstant.MP_IPROTO_INDEX_BASE, ValueFactory.newInteger((int)this.indexBase));
        map.put(IProtoConstant.MP_IPROTO_TUPLE, this.tuple);
        map.put(IProtoConstant.MP_IPROTO_OPS, this.operations);
        return ValueFactory.newMap(map);
    }

    @Override
    public int getRequestType() {
        return 9;
    }

    public String toString() {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
            this.stringBuilder.append("IProtoUpsert(syncId = ").append(this.getSyncId()).append(", spaceId = ").append(this.spaceId).append(", indexId = ").append(this.indexBase).append(", spaceName = ").append(this.spaceName).append(", tuple = ").append(this.tuple != null ? this.tuple : Arrays.toString(this.rawTuple)).append(", operations = ").append(this.operations != null ? this.operations : Arrays.toString(this.rawOperations)).append(")");
        }
        return this.stringBuilder.toString();
    }
}

