/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol.fsm;

import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.tarantool.core.connection.Connection;
import io.tarantool.core.exceptions.BoxError;
import io.tarantool.core.protocol.IProtoMessage;
import io.tarantool.core.protocol.IProtoRequest;
import io.tarantool.core.protocol.IProtoRequestOpts;
import io.tarantool.core.protocol.IProtoResponse;
import io.tarantool.core.protocol.fsm.IProtoStateMachine;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestStateMachine
implements IProtoStateMachine {
    private final IProtoRequest request;
    private final CompletableFuture<IProtoResponse> promise;
    private final Consumer<IProtoMessage> pushConsumer;
    private final Map<Long, IProtoStateMachine> fsmRegistry;
    private final Timer timerService;
    private final long syncId;
    static final Logger log = LoggerFactory.getLogger(RequestStateMachine.class);
    private final Connection connection;
    private final long timeout;
    private Timeout timer;
    private boolean calledOnce = false;

    public RequestStateMachine(Connection connection, long syncId, IProtoRequest request, CompletableFuture<IProtoResponse> promise, IProtoRequestOpts opts, Map<Long, IProtoStateMachine> fsmRegistry, Timer timerService) {
        this.connection = connection;
        this.syncId = syncId;
        request.setSyncId(syncId);
        this.request = request;
        this.promise = promise;
        this.pushConsumer = opts.getPushHandler();
        this.fsmRegistry = fsmRegistry;
        this.timerService = timerService;
        this.timeout = opts.getRequestTimeout();
        fsmRegistry.put(syncId, this);
    }

    @Override
    public void runOnce() {
        if (this.calledOnce) {
            throw new IllegalStateException("runOnce() is called before, cannot be called again.");
        }
        this.calledOnce = true;
        this.timer = this.runAfter(this.timeout, () -> this.kill(new TimeoutException(String.format("Request timeout: %s; timeout = %sms", this.request, this.timeout))));
        this.promise.whenComplete((iProtoResponse, throwable) -> this.timer.cancel());
        this.connection.send(this.request).handle((r, ex) -> {
            if (ex != null) {
                log.debug(ex.toString(), ex);
                this.fsmRegistry.remove(this.syncId);
                this.promise.completeExceptionally((Throwable)ex);
            }
            return null;
        });
    }

    @Override
    public boolean process(IProtoResponse message) {
        if (message.isOutOfBand()) {
            if (this.pushConsumer != null) {
                this.pushConsumer.accept(message);
            } else {
                log.debug("Can not process message \"{}\" because pushConsumer is empty", (Object)message);
            }
            return false;
        }
        if (message.isError()) {
            this.promise.completeExceptionally(BoxError.fromIProtoMessage(message));
        } else {
            this.promise.complete(message);
        }
        return true;
    }

    @Override
    public void kill(Throwable ex) {
        this.fsmRegistry.remove(this.syncId);
        this.promise.completeExceptionally(ex);
    }

    private Timeout runAfter(long after, Runnable cb) {
        if (after == 0L) {
            cb.run();
            return null;
        }
        return this.timerService.newTimeout(timeoutHandler -> cb.run(), after, TimeUnit.MILLISECONDS);
    }
}

