/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.protocol;

import io.tarantool.core.protocol.IProtoMessage;
import java.util.Map;
import java.util.stream.Collectors;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.IntegerValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.StringValue;
import org.msgpack.value.Value;

public class IProtoResponseImpl
implements IProtoMessage {
    private StringBuilder stringBuilder;
    protected MapValue header;
    protected MapValue body;
    protected Map<Integer, Value> headerMap;
    protected int requestType;
    protected Long syncId;
    protected Map<Integer, Value> bodyMap;

    public IProtoResponseImpl() {
    }

    public IProtoResponseImpl(MapValue header, MapValue body) {
        this.header = header;
        this.headerMap = IProtoResponseImpl.convertMap(header);
        this.body = body;
        this.bodyMap = IProtoResponseImpl.convertMap(body);
        this.syncId = this.headerMap.containsKey(1) ? Long.valueOf(this.headerMap.get(1).asIntegerValue().asLong()) : null;
        this.requestType = this.headerMap.get(0).asIntegerValue().asInt();
    }

    protected static Map<Integer, Value> convertMap(MapValue map) {
        return map.map().entrySet().stream().collect(Collectors.toMap(e -> ((IntegerValue)e.getKey()).asInt(), Map.Entry::getValue));
    }

    public String toString() {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
            this.stringBuilder.append("IProtoResponseImpl(header = ").append(this.getHeader().toJson()).append(", body = ").append(this.getBody().toJson()).append(")");
        }
        return this.stringBuilder.toString();
    }

    @Override
    public MapValue getBody() {
        return this.body;
    }

    @Override
    public MapValue getHeader() {
        return this.header;
    }

    @Override
    public long getSyncId() {
        if (!this.hasSyncId()) {
            return -1L;
        }
        return this.syncId;
    }

    @Override
    public boolean hasSyncId() {
        return this.syncId != null;
    }

    @Override
    public int getRequestType() {
        return this.requestType;
    }

    @Override
    public boolean isOutOfBand() {
        return this.getRequestType() == 128;
    }

    @Override
    public boolean isError() {
        return this.getRequestType() >= 32768;
    }

    @Override
    public int getErrorCode() {
        return this.getRequestType() - 32768;
    }

    @Override
    public Value getHeaderValue(int key) {
        return this.headerMap.get(key);
    }

    @Override
    public IntegerValue getHeaderIntegerValue(int key) {
        return this.getHeaderValue(key).asIntegerValue();
    }

    @Override
    public Value getBodyValue(int key) {
        return this.bodyMap.get(key);
    }

    @Override
    public ArrayValue getBodyArrayValue(int key) {
        return this.getBodyValue(key).asArrayValue();
    }

    @Override
    public MapValue getBodyMapValue(int key) {
        return this.getBodyValue(key).asMapValue();
    }

    @Override
    public StringValue getBodyStringValue(int key) {
        return this.getBodyValue(key).asStringValue();
    }

    @Override
    public IntegerValue getBodyIntegerValue(int key) {
        return this.getBodyValue(key).asIntegerValue();
    }
}

