/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.core.connection;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.GenericFutureListener;
import io.tarantool.core.connection.Greeting;
import io.tarantool.core.connection.codecs.IProtoFrameDecoder;
import io.tarantool.core.connection.codecs.IProtoFrameEncoder;
import io.tarantool.core.connection.handlers.GreetingHandler;
import io.tarantool.core.connection.handlers.IncomingIProtoMessageHandler;
import io.tarantool.core.connection.handlers.OutgoingIProtoMessageHandler;
import io.tarantool.core.protocol.IProtoResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

class ConnectionChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private final CompletableFuture<Greeting> promise;
    private final Consumer<IProtoResponse> messageHandler;
    private final SslContext sslContext;
    private final ChannelFutureListener closeHandler;
    private final FlushConsolidationHandler flushConsolidationHandler;

    private ConnectionChannelInitializer(CompletableFuture<Greeting> promise, Consumer<IProtoResponse> messageHandler, SslContext sslContext, ChannelFutureListener closeHandler, FlushConsolidationHandler flushConsolidationHandler) {
        this.promise = promise;
        this.messageHandler = messageHandler;
        this.sslContext = sslContext;
        this.closeHandler = closeHandler;
        this.flushConsolidationHandler = flushConsolidationHandler;
    }

    protected void initChannel(SocketChannel socketChannel) {
        ChannelPipeline pipeline = socketChannel.pipeline();
        socketChannel.closeFuture().addListener((GenericFutureListener)this.closeHandler);
        if (this.flushConsolidationHandler != null) {
            pipeline.addLast("FlushConsolidationHandler", (ChannelHandler)this.flushConsolidationHandler);
        }
        if (this.sslContext != null) {
            pipeline.addLast(new ChannelHandler[]{this.sslContext.newHandler(socketChannel.alloc())});
        }
        pipeline.addLast("GreetingHandler", (ChannelHandler)new GreetingHandler(this.promise));
        pipeline.addLast("MessagePackFrameDecoder", (ChannelHandler)new IProtoFrameDecoder());
        pipeline.addLast("MessagePackFrameEncoder", (ChannelHandler)new IProtoFrameEncoder());
        pipeline.addLast("OutgoingIProtoMessageHandler", (ChannelHandler)new OutgoingIProtoMessageHandler());
        pipeline.addLast("IncomingIProtoMessageHandler", (ChannelHandler)new IncomingIProtoMessageHandler(this.messageHandler));
    }

    public static class Builder {
        private CompletableFuture<Greeting> promise;
        private Consumer<IProtoResponse> messageHandler;
        private SslContext sslContext = null;
        private ChannelFutureListener closeHandler;
        private FlushConsolidationHandler flushConsolidationHandler = null;

        public Builder withConnectPromise(CompletableFuture<Greeting> promise) {
            this.promise = promise;
            return this;
        }

        public Builder withMessageHandler(Consumer<IProtoResponse> handler) {
            this.messageHandler = handler;
            return this;
        }

        public Builder withSSLContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder withCloseHandler(ChannelFutureListener listener) {
            this.closeHandler = listener;
            return this;
        }

        public Builder withFlushConsolidationHandler(FlushConsolidationHandler flushConsolidationHandler) {
            this.flushConsolidationHandler = flushConsolidationHandler;
            return this;
        }

        public ConnectionChannelInitializer build() {
            return new ConnectionChannelInitializer(this.promise, this.messageHandler, this.sslContext, this.closeHandler, this.flushConsolidationHandler);
        }
    }
}

