/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data.config;

import io.tarantool.client.box.TarantoolBoxClient;
import io.tarantool.client.factory.TarantoolBoxClientBuilder;
import io.tarantool.client.factory.TarantoolFactory;
import io.tarantool.spring.data.config.TarantoolConfiguration;
import io.tarantool.spring.data.config.properties.BaseTarantoolProperties;

public class BaseTarantoolBoxConfiguration
extends TarantoolConfiguration<TarantoolBoxClientBuilder> {
    private final TarantoolBoxClientBuilder tarantoolBoxClientBuilder;

    public BaseTarantoolBoxConfiguration(BaseTarantoolProperties properties, TarantoolBoxClientBuilder tarantoolBoxClientBuilder) {
        super(properties);
        this.tarantoolBoxClientBuilder = tarantoolBoxClientBuilder;
    }

    public TarantoolBoxClient tarantoolBoxClient() throws Exception {
        return this.getClientBuilder().build();
    }

    @Override
    public TarantoolBoxClientBuilder getClientBuilder() {
        if (this.tarantoolBoxClientBuilder != null) {
            return this.tarantoolBoxClientBuilder;
        }
        TarantoolBoxClientBuilder builder = TarantoolFactory.box().withHost(this.properties.getHost()).withPassword(this.properties.getPassword()).withBalancerClass(this.properties.getBalancerClass()).withConnectTimeout(this.properties.getConnectTimeout()).withReconnectAfter(this.properties.getReconnectAfter()).withPort(this.properties.getPort()).withEventLoopThreadsCount(this.properties.getEventLoopThreadsCount()).withUser(this.properties.getUserName()).withGroups(this.properties.getInstanceConnectionGroups()).withHeartbeat(this.properties.getHeartbeatOpts()).withFetchSchema(this.properties.isFetchSchema());
        if (!this.properties.isGracefulShutdownEnabled()) {
            builder.disableGracefulShutdown();
        }
        if (!this.properties.isIgnoreOldSchemaVersion()) {
            builder.enableOldSchemaVersionCheck();
        }
        return builder;
    }
}

