/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.mapping;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.tarantool.mapping.JacksonMappingException;
import io.tarantool.mapping.TarantoolDeserializer;
import io.tarantool.mapping.TarantoolTimezones;
import io.tarantool.mapping.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.msgpack.jackson.dataformat.MessagePackExtensionType;

public class DatetimeExtensionModule {
    private static final ThreadLocal<StringBuilder> threadLocalStringBuilder;
    private static final String UNEXPECTED_EXTENSION_TYPE = "Unexpected extension type (0x";
    public static final SimpleModule INSTANCE;
    public static final int HOURS_PER_DAY = 24;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int MINUTES_PER_DAY = 1440;
    public static final short SECONDS_PER_MINUTE = 60;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final long SECONDS_PER_DAY = 86400L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long MICROS_PER_DAY = 86400000000L;
    public static final long NANOS_PER_MILLI = 1000000L;
    public static final long NANOS_PER_SECOND = 1000000000L;
    public static final long NANOS_PER_MINUTE = 60000000000L;
    public static final long NANOS_PER_HOUR = 3600000000000L;
    public static final long NANOS_PER_DAY = 86400000000000L;
    public static final short SHORT_ZERO = 0;

    private DatetimeExtensionModule() {
    }

    private static MessagePackExtensionType marshallDatetime(long seconds, Integer nano, Short tzOffset, Short tzIndex) {
        boolean withOptionalFields;
        int size = 8;
        boolean bl = withOptionalFields = !nano.equals(0) || !tzOffset.equals((short)0) || tzIndex.equals((short)0);
        if (withOptionalFields) {
            size = 16;
        }
        ByteBuffer buffer = ByteBuffer.wrap(new byte[size]);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putLong(seconds);
        if (withOptionalFields) {
            buffer.putInt(nano);
            buffer.putShort(tzOffset);
            buffer.putShort(tzIndex);
        }
        return new MessagePackExtensionType(4, buffer.array());
    }

    private static String getZone(Short tzIndex) {
        if (!tzIndex.equals((short)0)) {
            return TarantoolTimezones.indexToTimezone.get(tzIndex);
        }
        return null;
    }

    static {
        INSTANCE = new SimpleModule("msgpack-ext-datetime");
        threadLocalStringBuilder = ThreadLocal.withInitial(StringBuilder::new);
        INSTANCE.addSerializer(Instant.class, (JsonSerializer)new InstantSerializer(Instant.class));
        INSTANCE.addDeserializer(Instant.class, (JsonDeserializer)new InstantDeserializer(Instant.class));
        INSTANCE.addSerializer(ZonedDateTime.class, (JsonSerializer)new ZonedDateTimeSerializer(ZonedDateTime.class));
        INSTANCE.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new ZonedDateTimeDeserializer(ZonedDateTime.class));
        INSTANCE.addSerializer(OffsetDateTime.class, (JsonSerializer)new OffsetDateTimeSerializer(OffsetDateTime.class));
        INSTANCE.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new OffsetDateTimeDeserializer(OffsetDateTime.class));
        INSTANCE.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(LocalDateTime.class));
        INSTANCE.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(LocalDateTime.class));
        INSTANCE.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(LocalDate.class));
        INSTANCE.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(LocalDate.class));
        INSTANCE.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(LocalTime.class));
        INSTANCE.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(LocalTime.class));
    }

    public static class InstantSerializer
    extends StdSerializer<Instant> {
        public InstantSerializer(Class<Instant> t) {
            super(t);
        }

        public void serialize(Instant value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeObject((Object)DatetimeExtensionModule.marshallDatetime(value.getEpochSecond(), value.getNano(), (short)0, (short)0));
        }
    }

    public static class InstantDeserializer
    extends StdDeserializer<Instant> {
        public InstantDeserializer(Class<?> vc) {
            super(vc);
        }

        public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            MessagePackExtensionType ext = (MessagePackExtensionType)p.readValueAs(MessagePackExtensionType.class);
            if (ext.getType() != 4) {
                StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                throw new JacksonMappingException(sb.delete(0, sb.length()).append(DatetimeExtensionModule.UNEXPECTED_EXTENSION_TYPE).append(Utils.byteToHex(ext.getType())).append(") for Instant object").toString());
            }
            byte[] data = ext.getData();
            int size = data.length;
            ByteBuffer buffer = ByteBuffer.wrap(data);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            long seconds = buffer.getLong();
            int nsec = 0;
            if (size == 16) {
                nsec = buffer.getInt();
            }
            return Instant.ofEpochSecond(seconds, nsec);
        }
    }

    public static class ZonedDateTimeSerializer
    extends StdSerializer<ZonedDateTime> {
        public ZonedDateTimeSerializer(Class<ZonedDateTime> t) {
            super(t);
        }

        public void serialize(ZonedDateTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            long seconds = value.toEpochSecond();
            int nano = value.getNano();
            short tzOffset = (short)(value.getOffset().getTotalSeconds() / 60);
            ZoneId zoneId = value.getZone();
            Short tzIndex = TarantoolTimezones.timezoneToIndex.get(zoneId.getId());
            gen.writeObject((Object)DatetimeExtensionModule.marshallDatetime(seconds, nano, tzOffset, tzIndex == null ? (short)0 : tzIndex));
        }
    }

    public static class ZonedDateTimeDeserializer
    extends StdDeserializer<ZonedDateTime>
    implements TarantoolDeserializer<ZonedDateTime> {
        public ZonedDateTimeDeserializer(Class<?> vc) {
            super(vc);
        }

        public ZonedDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            MessagePackExtensionType ext = (MessagePackExtensionType)p.readValueAs(MessagePackExtensionType.class);
            if (ext.getType() != 4) {
                StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                throw new JacksonMappingException(sb.delete(0, sb.length()).append(DatetimeExtensionModule.UNEXPECTED_EXTENSION_TYPE).append(Utils.byteToHex(ext.getType())).append(") for ZonedDateTime object").toString());
            }
            return this.deserialize(ext);
        }

        @Override
        public ZonedDateTime deserialize(MessagePackExtensionType ext) throws IOException {
            byte[] data = ext.getData();
            int size = data.length;
            ByteBuffer buffer = ByteBuffer.wrap(data);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            long seconds = buffer.getLong();
            int nsec = 0;
            short tzOffset = 0;
            short tzIndex = 0;
            if (size == 16) {
                nsec = buffer.getInt();
                tzOffset = buffer.getShort();
                tzIndex = buffer.getShort();
            }
            Instant instant = Instant.ofEpochSecond(seconds, nsec);
            String zone = DatetimeExtensionModule.getZone(tzIndex);
            if (zone != null) {
                return ZonedDateTime.ofInstant(instant, ZoneId.of(zone));
            }
            return ZonedDateTime.ofInstant(instant, ZoneOffset.ofTotalSeconds(tzOffset * 60));
        }
    }

    public static class OffsetDateTimeSerializer
    extends StdSerializer<OffsetDateTime> {
        public OffsetDateTimeSerializer(Class<OffsetDateTime> t) {
            super(t);
        }

        public void serialize(OffsetDateTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            long seconds = value.toEpochSecond();
            int nano = value.getNano();
            short tzOffset = (short)(value.getOffset().getTotalSeconds() / 60);
            gen.writeObject((Object)DatetimeExtensionModule.marshallDatetime(seconds, nano, tzOffset, (short)0));
        }
    }

    public static class OffsetDateTimeDeserializer
    extends StdDeserializer<OffsetDateTime> {
        public OffsetDateTimeDeserializer(Class<?> vc) {
            super(vc);
        }

        public OffsetDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            MessagePackExtensionType ext = (MessagePackExtensionType)p.readValueAs(MessagePackExtensionType.class);
            if (ext.getType() != 4) {
                StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                throw new JacksonMappingException(sb.delete(0, sb.length()).append(DatetimeExtensionModule.UNEXPECTED_EXTENSION_TYPE).append(Utils.byteToHex(ext.getType())).append(") for OffsetDateTime object").toString());
            }
            byte[] data = ext.getData();
            int size = data.length;
            ByteBuffer buffer = ByteBuffer.wrap(data);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            long seconds = buffer.getLong();
            int nsec = 0;
            short tzOffset = 0;
            short tzIndex = 0;
            if (size == 16) {
                nsec = buffer.getInt();
                tzOffset = buffer.getShort();
                tzIndex = buffer.getShort();
            }
            Instant instant = Instant.ofEpochSecond(seconds, nsec);
            String zone = DatetimeExtensionModule.getZone(tzIndex);
            if (zone != null) {
                return OffsetDateTime.ofInstant(instant, ZoneId.of(zone));
            }
            return OffsetDateTime.ofInstant(instant, ZoneOffset.ofTotalSeconds(tzOffset * 60));
        }
    }

    public static class LocalDateTimeSerializer
    extends StdSerializer<LocalDateTime> {
        public LocalDateTimeSerializer(Class<LocalDateTime> t) {
            super(t);
        }

        public void serialize(LocalDateTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeObject((Object)DatetimeExtensionModule.marshallDatetime(value.toEpochSecond(ZoneOffset.UTC), value.getNano(), (short)0, (short)0));
        }
    }

    public static class LocalDateTimeDeserializer
    extends StdDeserializer<LocalDateTime> {
        public LocalDateTimeDeserializer(Class<?> vc) {
            super(vc);
        }

        public LocalDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            MessagePackExtensionType ext = (MessagePackExtensionType)p.readValueAs(MessagePackExtensionType.class);
            if (ext.getType() != 4) {
                StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                throw new JacksonMappingException(sb.delete(0, sb.length()).append(DatetimeExtensionModule.UNEXPECTED_EXTENSION_TYPE).append(Utils.byteToHex(ext.getType())).append(") for LocalDateTime object").toString());
            }
            byte[] data = ext.getData();
            int size = data.length;
            ByteBuffer buffer = ByteBuffer.wrap(data);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            long seconds = buffer.getLong();
            int nsec = 0;
            short tzOffset = 0;
            short tzIndex = 0;
            if (size == 16) {
                nsec = buffer.getInt();
                tzOffset = buffer.getShort();
                tzIndex = buffer.getShort();
            }
            Instant instant = Instant.ofEpochSecond(seconds, nsec);
            String zone = DatetimeExtensionModule.getZone(tzIndex);
            if (zone != null) {
                return LocalDateTime.ofInstant(instant, ZoneId.of(zone));
            }
            return LocalDateTime.ofInstant(instant, ZoneOffset.ofTotalSeconds(tzOffset * 60));
        }
    }

    public static class LocalDateSerializer
    extends StdSerializer<LocalDate> {
        public LocalDateSerializer(Class<LocalDate> t) {
            super(t);
        }

        public void serialize(LocalDate value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeObject((Object)DatetimeExtensionModule.marshallDatetime(value.toEpochDay() * 86400L, 0, (short)0, (short)0));
        }
    }

    public static class LocalDateDeserializer
    extends StdDeserializer<LocalDate> {
        public LocalDateDeserializer(Class<?> vc) {
            super(vc);
        }

        public LocalDate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            MessagePackExtensionType ext = (MessagePackExtensionType)p.readValueAs(MessagePackExtensionType.class);
            if (ext.getType() != 4) {
                StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                throw new JacksonMappingException(sb.delete(0, sb.length()).append(DatetimeExtensionModule.UNEXPECTED_EXTENSION_TYPE).append(Utils.byteToHex(ext.getType())).append(") for LocalDate object").toString());
            }
            byte[] data = ext.getData();
            int size = data.length;
            ByteBuffer buffer = ByteBuffer.wrap(data);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            long seconds = buffer.getLong();
            short tzOffset = 0;
            if (size == 16) {
                tzOffset = buffer.getShort();
            }
            long localSecond = seconds + (long)(tzOffset * 60);
            long epochDay = Math.floorDiv(localSecond, 86400L);
            return LocalDate.ofEpochDay(epochDay);
        }
    }

    public static class LocalTimeSerializer
    extends StdSerializer<LocalTime> {
        public LocalTimeSerializer(Class<LocalTime> t) {
            super(t);
        }

        public void serialize(LocalTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeObject((Object)DatetimeExtensionModule.marshallDatetime(value.toSecondOfDay(), value.getNano(), (short)0, (short)0));
        }
    }

    public static class LocalTimeDeserializer
    extends StdDeserializer<LocalTime> {
        public LocalTimeDeserializer(Class<?> vc) {
            super(vc);
        }

        public LocalTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            MessagePackExtensionType ext = (MessagePackExtensionType)p.readValueAs(MessagePackExtensionType.class);
            if (ext.getType() != 4) {
                StringBuilder sb = (StringBuilder)threadLocalStringBuilder.get();
                throw new JacksonMappingException(sb.delete(0, sb.length()).append(DatetimeExtensionModule.UNEXPECTED_EXTENSION_TYPE).append(Utils.byteToHex(ext.getType())).append(") for LocalTime object").toString());
            }
            byte[] data = ext.getData();
            int size = data.length;
            ByteBuffer buffer = ByteBuffer.wrap(data);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            long seconds = buffer.getLong();
            int nsec = 0;
            int tzOffset = 0;
            if (size == 16) {
                nsec = buffer.getInt();
                tzOffset = buffer.getShort();
            }
            long localSecond = seconds + (long)(tzOffset * 60);
            long secsOfDay = Math.floorMod(localSecond, 86400L);
            return LocalTime.ofNanoOfDay(secsOfDay * 1000000000L + (long)nsec);
        }
    }
}

