/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data27.repository.config;

import io.tarantool.client.crud.TarantoolCrudClient;
import io.tarantool.spring.data27.query.TarantoolPartTreeQuery;
import io.tarantool.spring.data27.query.TarantoolQueryMethodImpl;
import io.tarantool.spring.data27.query.TarantoolRepositoryQuery;
import java.lang.reflect.Method;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.util.Assert;

public class TarantoolQueryLookupStrategy
implements QueryLookupStrategy {
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final KeyValueOperations keyValueOperations;
    private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;
    private final TarantoolCrudClient client;

    public TarantoolQueryLookupStrategy(TarantoolCrudClient client, QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider, KeyValueOperations keyValueOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
        Assert.notNull((Object)keyValueOperations, (String)"KeyValueOperations must not be null!");
        Assert.notNull(queryCreator, (String)"Query creator type must not be null!");
        this.client = client;
        this.evaluationContextProvider = evaluationContextProvider;
        this.keyValueOperations = keyValueOperations;
        this.queryCreator = queryCreator;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
        TarantoolQueryMethodImpl queryMethod = new TarantoolQueryMethodImpl(method, metadata, projectionFactory);
        if (queryMethod.hasAnnotatedQuery()) {
            return new TarantoolRepositoryQuery(this.client, queryMethod);
        }
        return new TarantoolPartTreeQuery(queryMethod, this.evaluationContextProvider, this.keyValueOperations, this.queryCreator);
    }
}

