/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.spring.data27.query;

import io.tarantool.spring.data.query.PaginationDirection;
import io.tarantool.spring.data27.query.TarantoolPageable;
import java.util.Objects;
import org.springframework.data.domain.AbstractPageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public final class TarantoolPageRequest<T>
extends AbstractPageRequest
implements TarantoolPageable<T> {
    private static final long serialVersionUID = -4541509938956089562L;
    private final Sort sort;
    private final T tupleCursor;
    private final PaginationDirection paginationDirection;

    public TarantoolPageRequest(int pageSize) {
        this(0, pageSize, null);
    }

    public TarantoolPageRequest(int page, int size, T tupleCursor) {
        this(page, size, Sort.unsorted(), tupleCursor, PaginationDirection.FORWARD);
    }

    TarantoolPageRequest(int page, int size, Sort sort, T tupleCursor, @NonNull PaginationDirection direction) {
        super(page, size);
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        Assert.notNull((Object)direction, (String)"PaginationDirection must not be null");
        this.sort = sort;
        this.tupleCursor = tupleCursor;
        this.paginationDirection = direction;
    }

    @NonNull
    public TarantoolPageRequest<T> withPage(int pageNumber) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("method \"withPage(int pageNumber)\" unsupported");
    }

    @Override
    @NonNull
    public TarantoolPageable<T> first() {
        return new TarantoolPageRequest<T>(this.getPageSize());
    }

    @NonNull
    public TarantoolPageRequest<T> next() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("method \"next()\" unsupported, use next(T nextTupleCursor)");
    }

    @Override
    public TarantoolPageRequest<T> next(T tupleCursor) {
        return new TarantoolPageRequest<T>(this.getPageNumber() + 1, this.getPageSize(), this.getSort(), tupleCursor, PaginationDirection.FORWARD);
    }

    @NonNull
    public TarantoolPageRequest<T> previous() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("method \"previous()\" unsupported, use previous(T prevTupleCursor)");
    }

    private TarantoolPageRequest<T> previous(T tupleCursor) {
        if (this.hasPrevious()) {
            return new TarantoolPageRequest<T>(this.getPageNumber() - 1, this.getPageSize(), this.getSort(), tupleCursor, PaginationDirection.BACKWARD);
        }
        return this;
    }

    @NonNull
    public TarantoolPageable<T> previousOrFirst() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("method \"previousOrFirst()\" unsupported, use previousOrFirst(T prevTupleCursor)");
    }

    @Override
    public TarantoolPageable<T> previousOrFirst(T tupleCursor) {
        if (this.hasPrevious()) {
            return this.previous(tupleCursor);
        }
        return new TarantoolPageRequest<Object>(0, this.getPageSize(), this.getSort(), null, PaginationDirection.BACKWARD);
    }

    @Override
    public PaginationDirection getPaginationDirection() {
        return this.paginationDirection;
    }

    @NonNull
    public Sort getSort() {
        return this.sort;
    }

    @Override
    public T getTupleCursor() {
        return this.tupleCursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TarantoolPageRequest)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TarantoolPageRequest that = (TarantoolPageRequest)o;
        return this.sort.equals((Object)that.sort) && Objects.equals(this.tupleCursor, that.tupleCursor) && this.paginationDirection == that.paginationDirection;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sort, this.tupleCursor, this.paginationDirection);
    }
}

