/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.client.operation;

import io.tarantool.client.operation.Operation;
import io.tarantool.client.operation.SimpleOperation;
import io.tarantool.client.operation.StringSpliceOperation;
import java.util.LinkedList;

public final class Operations
extends LinkedList<Operation> {
    private static final long serialVersionUID = -2208389705628662951L;

    public static Operations create() {
        return new Operations();
    }

    public Operations set(String fieldName, Object value) {
        this.add(new SimpleOperation('=', fieldName, value));
        return this;
    }

    public Operations set(Integer fieldIndex, Object value) {
        this.add(new SimpleOperation('=', fieldIndex, value));
        return this;
    }

    public Operations increment(String fieldName, Number value) {
        this.add(new SimpleOperation('+', fieldName, (Object)value));
        return this;
    }

    public Operations increment(Integer fieldIndex, Number value) {
        this.add(new SimpleOperation('+', fieldIndex, (Object)value));
        return this;
    }

    public Operations decrement(String fieldName, Number value) {
        this.add(new SimpleOperation('-', fieldName, (Object)value));
        return this;
    }

    public Operations decrement(Integer fieldIndex, Number value) {
        this.add(new SimpleOperation('-', fieldIndex, (Object)value));
        return this;
    }

    public Operations bitAnd(String fieldName, Number value) {
        this.add(new SimpleOperation('&', fieldName, (Object)value));
        return this;
    }

    public Operations bitAnd(Integer fieldIndex, Number value) {
        this.add(new SimpleOperation('&', fieldIndex, (Object)value));
        return this;
    }

    public Operations bitOr(String fieldName, Number value) {
        this.add(new SimpleOperation('|', fieldName, (Object)value));
        return this;
    }

    public Operations bitOr(Integer fieldIndex, Number value) {
        this.add(new SimpleOperation('|', fieldIndex, (Object)value));
        return this;
    }

    public Operations bitXor(String fieldName, Number value) {
        this.add(new SimpleOperation('^', fieldName, (Object)value));
        return this;
    }

    public Operations bitXor(Integer fieldIndex, Number value) {
        this.add(new SimpleOperation('^', fieldIndex, (Object)value));
        return this;
    }

    public Operations addItem(String fieldName, Object value) {
        this.add(new SimpleOperation('!', fieldName, value));
        return this;
    }

    public Operations addItem(Integer fieldIndex, Object value) {
        this.add(new SimpleOperation('!', fieldIndex, value));
        return this;
    }

    public Operations delItems(String fieldName, Number count) {
        this.add(new SimpleOperation('#', fieldName, (Object)count));
        return this;
    }

    public Operations delItems(Integer fieldIndex, Number count) {
        this.add(new SimpleOperation('#', fieldIndex, (Object)count));
        return this;
    }

    public Operations stringSplice(String fieldName, Integer start, Integer len, String toInsert) {
        this.add(new StringSpliceOperation(fieldName, (int)start, (int)len, toInsert));
        return this;
    }

    public Operations stringSplice(Integer fieldIndex, Integer start, Integer len, String toInsert) {
        this.add(new StringSpliceOperation(fieldIndex, (int)start, (int)len, toInsert));
        return this;
    }
}

