/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.client.factory;

import com.fasterxml.jackson.core.type.TypeReference;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.Timer;
import io.tarantool.balancer.TarantoolBalancer;
import io.tarantool.client.Options;
import io.tarantool.client.TarantoolClient;
import io.tarantool.core.IProtoClient;
import io.tarantool.core.WatcherOptions;
import io.tarantool.core.connection.ConnectionFactory;
import io.tarantool.core.exceptions.ServerException;
import io.tarantool.core.protocol.IProtoRequestOpts;
import io.tarantool.core.protocol.IProtoResponse;
import io.tarantool.mapping.TarantoolJacksonMapping;
import io.tarantool.mapping.TarantoolResponse;
import io.tarantool.pool.HeartbeatOpts;
import io.tarantool.pool.IProtoClientPool;
import io.tarantool.pool.IProtoClientPoolImpl;
import io.tarantool.pool.InstanceConnectionGroup;
import io.tarantool.pool.TripleConsumer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.ValueFactory;

abstract class TarantoolClientImpl
implements TarantoolClient {
    protected final TarantoolBalancer balancer;
    private final NioEventLoopGroup nioEventLoopGroup;
    private final MeterRegistry metricsRegistry;
    private final IProtoClientPool pool;
    private final AtomicBoolean isClosed;

    protected TarantoolClientImpl(List<InstanceConnectionGroup> groups, Map<ChannelOption<?>, Object> channelOptions, int nThreads, Timer timerService, boolean gracefulShutdown, Class<? extends TarantoolBalancer> balancerClass, HeartbeatOpts heartbeatOpts, WatcherOptions watcherOpts, long connectTimeout, long reconnectAfter, MeterRegistry metricsRegistry, TripleConsumer<String, Integer, IProtoResponse> ignoredPacketsHandler, SslContext sslContext, boolean useTupleExtension) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        this.metricsRegistry = metricsRegistry;
        this.nioEventLoopGroup = new NioEventLoopGroup(nThreads);
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)this.nioEventLoopGroup)).channel(NioSocketChannel.class);
        channelOptions.forEach((key, value) -> bootstrap.option(key, value));
        ConnectionFactory factory = new ConnectionFactory(bootstrap, sslContext, timerService);
        this.pool = new IProtoClientPoolImpl(factory, timerService, gracefulShutdown, heartbeatOpts, watcherOpts, this.metricsRegistry, ignoredPacketsHandler, useTupleExtension);
        this.pool.setGroups(groups);
        this.pool.setConnectTimeout(connectTimeout);
        this.pool.setReconnectAfter(reconnectAfter);
        Constructor<? extends TarantoolBalancer> constructor = balancerClass.getConstructor(IProtoClientPool.class);
        this.balancer = constructor.newInstance(this.pool);
        this.isClosed = new AtomicBoolean(false);
    }

    private IProtoRequestOpts convertOptions(Options opts) {
        return IProtoRequestOpts.empty().withRequestTimeout(opts.getTimeout()).withStreamId(opts.getStreamId());
    }

    private CompletableFuture<Boolean> convertPingResult(CompletableFuture<IProtoResponse> future) {
        return future.thenApply(resp -> resp.getRequestType() == 0);
    }

    @Override
    public CompletableFuture<TarantoolResponse<List<?>>> call(String function) {
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.call(function, (ArrayValue)ValueFactory.emptyArray()));
        return TarantoolJacksonMapping.convertFutureResult((CompletableFuture)future);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<List<T>>> call(String function, Class<T> entity) {
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.call(function, (ArrayValue)ValueFactory.emptyArray()));
        return TarantoolJacksonMapping.convertFutureResult((CompletableFuture)future, entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<T>> call(String function, TypeReference<T> entity) {
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.call(function, (ArrayValue)ValueFactory.emptyArray()));
        return TarantoolJacksonMapping.convertFutureResult((CompletableFuture)future, entity);
    }

    @Override
    public CompletableFuture<TarantoolResponse<List<?>>> call(String function, List<?> args) {
        byte[] rawArgs = TarantoolJacksonMapping.toValue(args);
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.call(function, rawArgs));
        return TarantoolJacksonMapping.convertFutureResult((CompletableFuture)future);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<List<T>>> call(String function, List<?> args, Class<T> entity) {
        byte[] rawArgs = TarantoolJacksonMapping.toValue(args);
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.call(function, rawArgs));
        return TarantoolJacksonMapping.convertFutureResult((CompletableFuture)future, entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<T>> call(String function, List<?> args, TypeReference<T> entity) {
        byte[] rawArgs = TarantoolJacksonMapping.toValue(args);
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.call(function, rawArgs));
        return TarantoolJacksonMapping.convertFutureResult((CompletableFuture)future, entity);
    }

    @Override
    public CompletableFuture<TarantoolResponse<List<?>>> call(String function, List<?> args, Options opts) {
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.call(function, TarantoolJacksonMapping.toValue((Object)args), null, this.convertOptions(opts)));
        return TarantoolJacksonMapping.convertFutureResult((CompletableFuture)future);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<List<T>>> call(String function, List<?> args, Options opts, Class<T> entity) {
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.call(function, TarantoolJacksonMapping.toValue((Object)args), null, this.convertOptions(opts)));
        return TarantoolJacksonMapping.convertFutureResult((CompletableFuture)future, entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<T>> call(String function, List<?> args, Object formats, Options opts, TypeReference<T> entity) {
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.call(function, TarantoolJacksonMapping.toValue((Object)args), formats == null ? null : TarantoolJacksonMapping.toValueWithKeySerializer((Object)formats), this.convertOptions(opts)));
        return TarantoolJacksonMapping.convertFutureResult((CompletableFuture)future, entity);
    }

    @Override
    public CompletableFuture<TarantoolResponse<List<?>>> eval(String expression) {
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.eval(expression, (ArrayValue)ValueFactory.emptyArray()));
        return TarantoolJacksonMapping.convertFutureResult((CompletableFuture)future);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<List<T>>> eval(String expression, Class<T> entity) {
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.eval(expression, (ArrayValue)ValueFactory.emptyArray()));
        return TarantoolJacksonMapping.convertFutureResult((CompletableFuture)future, entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<T>> eval(String expression, TypeReference<T> entity) {
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.eval(expression, (ArrayValue)ValueFactory.emptyArray()));
        return TarantoolJacksonMapping.convertFutureResult((CompletableFuture)future, entity);
    }

    @Override
    public CompletableFuture<TarantoolResponse<List<?>>> eval(String expression, List<?> args) {
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.eval(expression, TarantoolJacksonMapping.toValue((Object)args)));
        return TarantoolJacksonMapping.convertFutureResult((CompletableFuture)future);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<List<T>>> eval(String expression, List<?> args, Class<T> entity) {
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.eval(expression, TarantoolJacksonMapping.toValue((Object)args)));
        return TarantoolJacksonMapping.convertFutureResult((CompletableFuture)future, entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<T>> eval(String expression, List<?> args, TypeReference<T> entity) {
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.eval(expression, TarantoolJacksonMapping.toValue((Object)args)));
        return TarantoolJacksonMapping.convertFutureResult((CompletableFuture)future, entity);
    }

    @Override
    public CompletableFuture<TarantoolResponse<List<?>>> eval(String expression, List<?> args, Options opts) {
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.eval(expression, TarantoolJacksonMapping.toValue((Object)args), null, this.convertOptions(opts)));
        return TarantoolJacksonMapping.convertFutureResult((CompletableFuture)future);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<List<T>>> eval(String expression, List<?> args, Options opts, Class<T> entity) {
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.eval(expression, TarantoolJacksonMapping.toValue((Object)args), null, this.convertOptions(opts)));
        return TarantoolJacksonMapping.convertFutureResult((CompletableFuture)future, entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<T>> eval(String expression, List<?> args, Object formats, Options opts, TypeReference<T> entity) {
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.eval(expression, TarantoolJacksonMapping.toValue((Object)args), formats == null ? null : TarantoolJacksonMapping.toValueWithKeySerializer((Object)formats), this.convertOptions(opts)));
        return TarantoolJacksonMapping.convertFutureResult((CompletableFuture)future, entity);
    }

    @Override
    public CompletableFuture<Boolean> ping() {
        CompletionStage future = this.balancer.getNext().thenCompose(IProtoClient::ping);
        return this.convertPingResult((CompletableFuture<IProtoResponse>)future);
    }

    @Override
    public CompletableFuture<Boolean> ping(Options opts) {
        CompletionStage future = this.balancer.getNext().thenCompose(c -> c.ping(this.convertOptions(opts)));
        return this.convertPingResult((CompletableFuture<IProtoResponse>)future);
    }

    @Override
    public void watch(String key, Consumer<TarantoolResponse<?>> callback) {
        this.wrappedWatch(key, value -> callback.accept(TarantoolJacksonMapping.fromEventData((IProtoResponse)value)));
    }

    @Override
    public <T> void watch(String key, Consumer<TarantoolResponse<T>> callback, Class<T> entity) {
        this.wrappedWatch(key, value -> callback.accept(TarantoolJacksonMapping.fromEventData((IProtoResponse)value, (Class)entity)));
    }

    @Override
    public <T> void watch(String key, Consumer<TarantoolResponse<T>> callback, TypeReference<T> entity) {
        this.wrappedWatch(key, value -> callback.accept(TarantoolJacksonMapping.fromEventData((IProtoResponse)value, (TypeReference)entity)));
    }

    private CompletableFuture<IProtoResponse> iprotoWatch(String key) {
        return this.balancer.getNext().thenCompose(c -> {
            Integer serverVersion = c.getServerProtocolVersion();
            if (serverVersion < 6) {
                throw new ServerException("Tarantool doesn't support watch once feature. Need iproto version >= 6, got " + serverVersion);
            }
            return c.watchOnce(key);
        });
    }

    @Override
    public CompletableFuture<TarantoolResponse<List<?>>> watchOnce(String key) {
        return TarantoolJacksonMapping.convertFutureResult(this.iprotoWatch(key));
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<List<T>>> watchOnce(String key, Class<T> entity) {
        return TarantoolJacksonMapping.convertFutureResult(this.iprotoWatch(key), entity);
    }

    @Override
    public <T> CompletableFuture<TarantoolResponse<T>> watchOnce(String key, TypeReference<T> entity) {
        return TarantoolJacksonMapping.convertFutureResult(this.iprotoWatch(key), entity);
    }

    private void wrappedWatch(String key, Consumer<IProtoResponse> callback) {
        this.balancer.getPool().forEach(client -> client.watch(key, callback));
    }

    @Override
    public void unwatch(String key) {
        this.balancer.getPool().forEach(client -> client.unwatch(key));
    }

    @Override
    public void close() throws Exception {
        if (this.isClosed.compareAndSet(false, true)) {
            this.balancer.close();
            this.nioEventLoopGroup.shutdownGracefully().get();
        }
    }

    @Override
    public TarantoolBalancer getBalancer() {
        return this.balancer;
    }

    @Override
    public IProtoClientPool getPool() {
        return this.pool;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }
}

