/*
 * Decompiled with CFR 0.152.
 */
package io.tarantool.client.crud.options;

import io.tarantool.client.crud.options.CrudOptions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LenOptions
implements CrudOptions {
    private static final String TIMEOUT = "timeout";
    private static final String VSHARD_ROUTER = "vshard_router";
    public static final long DEFAULT_TIMEOUT = 5000L;
    private final Long timeout;
    private final Long streamId;
    private final Map<String, Object> crudOptions;

    public LenOptions(Long timeout, Long streamId, Map<String, Object> options) {
        this.crudOptions = options;
        this.timeout = timeout;
        this.streamId = streamId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public Long getStreamId() {
        return this.streamId;
    }

    @Override
    public Map<String, Object> getOptions() {
        return Collections.unmodifiableMap(this.crudOptions);
    }

    public static class Builder {
        private final Map<String, Object> options = new HashMap<String, Object>();
        private long timeout = 5000L;
        private Long streamId;

        public Builder withTimeout(long timeout) {
            if (timeout <= 0L) {
                throw new IllegalArgumentException("timeout should be greater than 0");
            }
            this.timeout = timeout;
            return this;
        }

        public Builder withStreamId(Long streamId) {
            if (streamId < 0L) {
                throw new IllegalArgumentException("streamId should be greater or equal 0");
            }
            this.streamId = streamId;
            return this;
        }

        public Builder withCrudTimeout(long timeout) {
            this.addOption(LenOptions.TIMEOUT, timeout);
            return this;
        }

        private void addOption(String name, Object value) {
            if (name != null) {
                this.options.put(name, value);
            }
        }

        public Builder withVshardRouter(String vshardRouter) {
            this.addOption(LenOptions.VSHARD_ROUTER, vshardRouter);
            return this;
        }

        public Builder withOption(String optionName, Object optionValue) {
            this.addOption(optionName, optionValue);
            return this;
        }

        public LenOptions build() {
            return new LenOptions(this.timeout, this.streamId, this.options);
        }
    }
}

